---
tags: Syllabus, CHEM 118

---

<h1>
  <center>
    CHEM 118 Syllabus
  </center>
</h1>

## Course Information

### Instructor

Instructor Name: Mr. Michael Stogsdill (he, him)
Email Address: michael.stogsdill@mcc.edu
Phone: (567) 343-1425

### Important Dates

| Event                               | Date                    |
| ----------------------------------- | ----------------------- |
| First Day of Class                  | 09/03/2024              |
| Registration Closes                 | 09/09/2024              |
| Midterm Grades Due                  | 11/01/2024              |
| Thanksgiving Break - College Closed | 11/28/2024 - 12/01/2024 |
| Last Day to Drop with W             | 12/11/2024              |
| Last Day of Class                   | 12/18/2024              |
| Final Grades Due                    | 12/20/2024              |

### Required Materials


A non-programmable scientific calculator, such as, Texas Instrument TI-30X IIS or Casio FX-115ESPLUS.


## Course Description


This course is designed for students who need a review of, an introduction to, or additional experience in the basic mathematical and chemical concepts and skills necessary for satisfactory academic work in CHEM-131.


### Prerequisites


- Placement into RDNG-030 (ACSR-030), completion of ELAP-110 with a minimum grade of 2.0, or successful completion of RDNG-016 or ACLT-074 with a minimum grade of 3.0.
- A 2.0 or better in MATH-082. 


### Student Learning Outcomes


Provide an introduction to or a review of basic chemical concepts and associated mathematical operations. 

- Emphasize Chemistry topics known to be troublesome to freshman students. 
- Provide the necessary foundation for the chemistry courses designed for both science and science-related majors. 


## Course Content

### Topics

- The Chemical World
- Measurement and Problem Solving
- Matter and Energy
- Atoms and Elements
- Molecules and Compounds
- Chemical Composition
- Chemical Reactions
- Electrons and the Periodic Table
- Chemical Bonding


### Textbook

Introductory Chemistry, 6th Edition
Nivaldo J. Tro, Santa Barbara City College
© 2018 |Pearson
ISBN-13: 9780134564074 


### Description


Builds 21st century and problem-solving skills, preparing students for success. The best-selling Introductory Chemistry text continues to encourage student interest by showing how chemistry manifests in students' daily lives. Author Nivaldo Tro draws upon his classroom experience as an award-winning instructor to extend chemistry from the laboratory to the student's world, capturing student attention with relevant applications and an engaging writing style. The text provides a superior teaching and learning experience, enabling deep conceptual understanding, fostering the development of problem-solving skills, and encouraging interest in chemistry with concrete examples. Extending chemistry from the lab to the student's world, the text reveals that anyone can master chemistry. 


### Attendance


Attendance will be taken at each meeting of this course. Students who regularly attend their courses typically perform much better.


### Exams


There will be two exams in this course. A midterm exam and a final exam. These exams will be cumulative. Meaning they will include questions on all of the material covered up to that point. The dates of these exams can be found in the schedule below.


### Quizzes


Quizzes will be due following the completion of each chapter. Quizzes can be completed outside of class. The must be completed individually.


## Grades

Student assessment for the course will be derived from the quizzes and exams.

|  Assessment  | Overall Percentage |
| :----------: | :----------------: |
|   Quizzes    |        40%         |
| Midterm Exam |        25%         |
|  Final Exam  |        35%         |



| GPA  | Course Grade |
| :--: | :----------: |
| 4.0  |  92 - 100%   |
| 3.5  |   88 - 91%   |
| 3.0  |   82 - 87%   |
| 2.5  |   76 - 81%   |
| 2.0  |   70 - 75%   |
| 1.5  |   65 - 69%   |
| 1.0  |   60 - 64%   |
| 0.0  |     <60%     |


### Plagiarism

Basically, copying anyone’s work is considered plagiarism unless that person has been appropriately cited. The copying of another student’s work will be considered plagiarism and will not be tolerated. 
I am very adept at detecting cheating. Students caught cheating or plagiarizing will be reprimanded as follows: 1^st^ offense results in zero score for the assignment, 2^nd^ offense referred to academic standards. The repercussions for being referred to academic standards are very severe.  For more information please refer to the academic integrity statement posted in the Online Learning Resources page within Canvas, the relevant section in the college catalog, and the MCC Academic Integrity Website.



## Mott Community College Policies and Resources

### Tutoring Information

Mott Community College offers tutoring services. You can learn more about tutoring services [**here**](https://www.mcc.edu/tutoring/index.shtml).

MCC Tutoring Center

Telephone: [810-232-4696](tel:18102324696)
Email: [Peer.Tutoring@mcc.edu](mailto:Peer.Tutoring@mcc.edu)

**I will be tutoring in the Math and Science Study Center on the second floor of the Gorman Science Center Building from 9:00 am - 12:00 pm on Tuesdays. Please feel free to stop by for additional on-on-one instruction.**

### Title IX of the Education Amendments of 1972:

Consistent with Title IX of the Education Amendments of 1972, Mott Community College will provide appropriate adjustments and/or support to pregnant and parenting students. With medical documentation from a physician, the adjustments and accommodations may include providing a larger classroom desk or a designated lactation room, allowing frequent trips to the restroom, permitting temporary access to elevators, providing opportunities for making up missed work, allowing the student to submit work after a missed deadline due to absence related to pregnancy or childbirth, or providing a leave of absence for a period of time.

For questions about your rights pursuant to Title IX and other non-discrimination related compliance matters, contact the **Title IX Coordinator Wanda Brown** at **titleix@mcc.edu**.

### Care Team

If you or someone you know needs support, is distressed, or exhibits concerning behavior, help by making a referral to the Care Team. The Mott Community College Care Team is committed to improving the safety and well-being of the college community through proactive and supportive interventions. As your instructor, I may contact the Care Team to seek support for you. I encourage you to fill out a referral if you or a classmate are in need of help. **You may contact the Care Team by reporting a concern at**[ **www.mcc.edu/care**](http://www.mcc.edu/care)**. You can also contact the Care Team by calling** **(810) 762-0331****.**

In case of an emergency, please call 9-1-1.

### Civility Statement

Mott Community College is committed to the highest standards of academic and ethical integrity, acknowledging that civility and respect of self -and others - are the foundation of educational excellence.

### Accommodations Policy

Mott Community College is committed to providing equal opportunity for participation in all programs, services, and activities and adheres to Section 504 of the Rehabilitation Act (1973) and the Americans with Disabilities Act, as amended (2008) to provide effective auxiliary aids and services for qualified students with documented disabilities.  Requests for accommodations by students with disabilities may be made by contacting Disability Services at 810-232-9181 or on the [**website**](disabilityservices@mcc.edu) .  Once your eligibility for an accommodation has been determined, you will be issued an Instructor Notification Letter. 

Please present Instructor Notification Letters to instructors at the start of the semester and/or two weeks prior to the accommodation date (test, project, etc.).  Requests received after this date will be honored whenever possible.  

### Incomplete Grade Information

A student must initiate a request for an "I" (Incomplete Grade) from an instructor. The "I" will be given at the sole discretion of the instructor. Typically, an "I" will be given only when the student:

- Has completed at least 75% of the class (excluding the final exam) but is unable to complete the class work because of extraordinary, unusual, or unforeseen circumstances or other compelling reasons,
- Has done passing work in the course and in the instructor's judgment, can complete the required work without repeating the course.
- Is eligible under Title IX - Supporting the Academic Success of Pregnant and Parenting Students. Please view [**this link**](http://www2.ed.gov/about/offices/list/ocr/docs/pregnancy.pdf) for more information. 

### Withdrawal Policy

Dropping a class during the semester is also referred to as Withdrawal from a course. This is the responsibility of the student. A student may withdraw from a class at any time prior to the 90% point of the semester or session. A withdrawal before the “Date of Record” means there is no record of enrollment. A withdrawal after the “Date of Record” but before the last week of the semester means a “W” grade. A "W" grade will be listed on the student’s grade report/transcript if the withdrawal occurs after the Date of Record as listed on the Academic/Registration Calendar.

Students must follow this procedure to officially discontinue enrollment in a particular course. To withdraw, a student must fill out the Class Schedule Worksheet form and file it with the Career & Enrollment Center.

Students who decide not to attend classes must drop these classes themselves. Classes are not automatically dropped for non-attendance.

To be eligible for a tuition refund classes must be dropped within the tuition refund dates, which are listed in the Academic/Registration Calendar.

### Additional Contact Information

#### Science and Math division office 

Telephone: [810-762-0279](tel:18107620279)


#### MCC e-Learning office 

Telephone: [810-762-0224](18107620224)
Email: [elearning@mcc.edu](mailto:elearning@mcc.edu)

#### MCC 2-HELP technical support

Telephone: [810-762-4357](tel:188107624357)
Email: [2help@mcc.edu](mailto:2help@mcc.edu)

### School Closings


Up-to-date closing information is available from the following sources:

#### [MCC's Public Safety Webite](http://www.mcc.edu/public_safety/ps_sch_closing.shtml)

#### Emergency Notification System

As a member of the MCC Community you are initially set to receive (opted-in) notifications as both a voice and text message. In the event of any on-campus emergency a voice or SMS (text message) will be sent. Notifications can be managed through MCC4me > My Mott Apps > Account Manager.

#### Student Email Notification

Students will be notified through their MCC Webmail address of specific class cancellation, site-specific closings, or college-wide closings. Call (810) 232-8989 for a recorded message announcing a school closing. Area radio and television stations will be alerted whenever a decision is made to close the school.

## Schedule

|    Date    | Reading Sections | Assessment |
| :--------: | :--------------: | :--------: |
| 09/05/2024 |    1.1 - 1.5     |            |
| 09/12/2024 |    2.1 - 2.11    | Ch. 1 Quiz |
| 09/19/2024 |    3.1 - 3.7     | Ch. 2 Quiz |
| 09/26/2024 |    3.8 - 3.12    |            |
| 10/03/2024 |     4.1 -4.6     | Ch. 3 Quiz |
| 10/10/2024 |    4.7 - 4.9     |            |
| 10/17/2024 |    5.1 - 5.5     | Ch. 4 Quiz |
| 10/24/2024 |    5.6 - 5.11    |            |
| 10/31/2024 |                  |  Midterm   |
| 11/07/2024 |    6.1 - 6.4     |            |
| 11/14/2024 |    6.5 - 6.9     |            |
| 11/21/2024 |    7.1 - 7.5     | Ch. 6 Quiz |
| 11/28/2024 |   Thanksgiving   |   Break    |
| 12/05/2024 |    7.6 - 7.10    |            |
| 12/12/2024 |                  | Final Exam |


<div style="page-break-after: always; visibility: hidden"> 
\pagebreak 
</div>


# Chapter 1

## Science vs. Philosophy

Science was born out of philosophy. It was developed after it became obvious that philosophy alone could not fully explain the physical universe.

|                     Philosophers                      |                     Scientists                      |
| :---------------------------------------------------: | :-------------------------------------------------: |
|                    Observe Nature                     |                   Observe Nature                    |
|            Explain the Behavior of Nature             |           Explain the Behavior of Nature            |
| Communicate and Debate Ideas with other Philosophers. | Communicate and Debate Ideas with other Scientists. |
|      Truth is revealed through Logic and Debate       |      Truth is revealed through Experimentation      |



## What Is Chemistry?

- Chemists use the **Scientific Method** to discover the relationships between the particle structure of matter and the properties of matter we observe.
  - How does the microscopic properties of matter effect the macroscopic properties?

### Structure Determines Properties
- Everything is made of tiny particles called **atoms** and **molecules**.
- Properties of a substance are determined by the type, amount, and interactions between these pieces.

<img src="./assets/image-20240729111830354.png" alt="image-20240729111830354" style="zoom:50%;" />



## The Scientific Method

- A process for trying to understand nature by observing it and analyzing the way it behaves. 
- **Observations** are made to identify phenomenon to study and collect *data*.
- **Hypotheses** are formed and tested through **experimentation**
- **Conclusions** are drawn by analyzing data obtained from experiments.
- These conclusions are used to *confirm* or *reject* the hypothesis

![image-20240729114539148](./assets/image-20240729114539148.png)



## Observation

- A way of acquiring information about nature.
- The information obtained from observation is  known as Data.
- Some observations are simple descriptions about the characteristics or behavior of nature.
  - This is called *qualitative* data 

“The soda pop is a liquid with a brown color and a sweet taste.  Bubbles are seen floating up through it.”

- Some observations compare a characteristic to a standard numerical scale.
  
   - This is called *quantitative* data

“A 240-mL serving of soda pop contains 27 g of sugar.”



## Hypothesis

- A tentative interpretation or explanation of your observations.
  

“The sweet taste of soda pop is due to the presence of sugar.”

- A good hypothesis is one that can be tested to be proven wrong.
  - One test should be able to invalidate your hypothesis.
  
## Experiments

- Tests of hypotheses, laws, or theories.
  - Can you think of a way to test whether the sweet taste of soda pop is due to the presence of sugar?
  
- Results either validate (confirm) or invalidate (deny) your ideas.
  - Invalidate = Discard or Modify
    - Many times experiments invalidate only parts of the hypothesis or theory, in which case the idea is modified.
  - Validate ≠ Proof your idea will always hold

## Laws

- Summary of observations that combines all past observations into one general statement.
  - Allows you to predict future observations.
  - Law of Conservation of Mass— “In a chemical reaction matter is neither created nor destroyed.”
-  What’s the Difference Between an Observation and a Law?
    - An observation tells you what happened in a single event.
    - A law summarizes all the observations, effectively telling you what you will observe in future events.

## Theories

- General explanation for the characteristics and behavior of nature.
  - Models of nature.
  - Ex. Dalton’s Atomic Theory, Theory of Gravity, Germ Theory
  - Can be used to predict future observations.
- What’s the Difference Between a Hypothesis and a Theory?
  - A hypothesis is an explanation of a single or small number of observations.
  - A theory is an explanation that extends beyond individual observations to an understanding of the underlying causes for the way nature is or behaves.

## What’s the Difference Between a Law and a Theory?
- Laws answer the question “What” will happen.
- Theories tell us "What" will happen but also “Why” it happens.
    - Theories allow to extend your predictions to a wider set of circumstances.

<img src="./assets/image-20240729140309276.png" alt="image-20240729140309276" style="zoom: 33%;" />


## Example from History
### Why Do Some Things Burn?

##### Observations

- Things would stop burning when placed in a closed container.
- Many metals burn to form a white powder called calx.
- Metals can be recovered from their calx by roasting it with charcoal.

### Hypothesis
- Phlogiston Theory is an Explanation of combustion proposed in early/mid-1700s.
  - Combustible substances contained a substance they called phlogiston.
  - When a substance burned it released all or some of its phlogiston into the air .
- How Does Phlogiston Theory Explain the Observations?
  - When a substance is burned in the open, all the phlogiston is released.
  - When a substance is burned in a closed container, the phlogiston is released until it saturates the container, at which point the combustion stops.
  - A metal’s calx is what is left after it releases all its phlogiston.
  - When roasted with charcoal the calx reacquires phlogiston from the charcoal.
    - Charcoal is rich in phlogiston, that’s why charcoal burns.

### Experiment

**If  phlogiston is lost when metals burn, then the metals should lose weight when burned.**

- Morveau’s experiments showed that when a piece of metal burned, the resulting calx weighed more than the original metal.
  - Do Morveau’s observations validate or invalidate the Phlogiston Theory?
  

<img src="https://media.gettyimages.com/id/90775041/photo/guytons-laboratoire-economique-1797-watercolour-showing-an-experimental-set-up-baron-louis.jpg?s=612x612&w=gi&k=20&c=oCorru6YCTmdZSUD72t8jvfK5Z3-nh3fENQxUrj_cok=" alt="https://media.gettyimages.com/id/90775041/photo/guytons-laboratoire-economique-1797-watercolour-showing-an-experimental-set-up-baron-louis.jpg?s=612x612&w=gi&k=20&c=oCorru6YCTmdZSUD72t8jvfK5Z3-nh3fENQxUrj_cok=" style="zoom: 33%;" />



**If a calx is heated, it should remove phlogiston from the air as the calx is converted to the metal.**

- Lavoisier roasted many calx with a large lens and observed that material he called “fixed air” was released into the air. 
  - Do Lavoisier’s observations validate or invalidate the Phlogiston Theory? 

<img src="./assets/image-20240729144555581.png" alt="image-20240729144555581" style="zoom: 25%;" />

## A Better Theory of Combustion

- Lavoisier proposed an alternative theory of combustion.
  - When materials burn, they remove and combine with "fixed air" from the air.
- Does Lavoisier’s idea explain all the previous observations?
- How could you test Lavoisier’s idea? 
  
## How to Succeed in Chemistry
- Be curious and use your imagination.
- Explore and investigate.
- Quantify and calculate
  - Even small differences can be important!
- Commitment
  - Work regularly and carefully.

<div style="page-break-after: always; visibility: hidden"> 
\pagebreak 
</div>

# Chapter 1 Quiz

1. Chemicals make up everything around you, including your own body. (1 point)

​				True				False

2.	Chemists study the properties of substances and the particles that compose those substances. (1 point)

​				True				False

3.	The properties of water do not depend on how the atoms are bonded together in the molecule. (1 point)

​				True				False

4.	Laws are stronger statements than theories. (1 point)

​				True				False

5.	The scientific method emphasizes logic and debate as the way to understand the world. (1 point)

​				True				False

6.	A hypothesis can be proven wrong. (1 point)

​				True				False

7.	The first step in acquiring scientific knowledge is often the1 observation or measurement of some aspect of nature. (1 point)

​				True				False



8.	Which of the statements below is NOT part of the scientific method? (2 point)

A) observation and measurement

B) formation of a hypothesis

C) testing of a hypothesis by experimentation

D) refinement of a hypothesis as needed

E) All of the above steps are part of the scientific method.




9.	What term best describes a brief statement that summarizes many past observations and predicts new ones? (2 point)

A) experiment

B) hypothesis

C) scientific law

D) theory

E) none of the above




10. A sample of wood with a mass of 3.0 grams was burned in an open dish. The ashes weighed 1.2 grams. 

What happened to the rest of the wood?	 (2 point)

A) The remaining mass was destroyed.

B) The remaining 1.8 grams was converted into gaseous compounds.

C) Nothing, the burned wood simply has a mass of 1.2 grams.

D) The remaining 1.8 grams was converted into heat.

E) none of the above




11. Which statement accurately describes the purpose of experiments? (2 point)

A) Experiments are designed to produce the results predicted by a theory.

B) Experiments can be replaced by a simple, logical reasoning of known facts.

C) Experiments are designed to produce unexplainable results for further investigation.

D) Experiments are designed to validate or invalidate a hypothesis, law, or theory.

E) none of the above

<div style="page-break-after: always; visibility: hidden"> 
\pagebreak 
</div>

# Chapter 2

## What Is a Measurement?
- Quantitative observation.
- Comparison to an agreed upon standard.
- Every measurement has a number, a unit, and an indicated degree of uncertainty.

- The unit tells you to what standard you are comparing your object. 
- The number tells you:
  - What multiple of the standard the object measures.
  - The uncertainty in the measurement.

### Scientists have measured the average global temperature rise over the past century to be 0.6 °C

- **°C** tells you that the temperature is being compared to the Celsius temperature scale.
- **0.6** tells you that:
  - The average temperature rise is 0.6 times the standard unit of 1 degree Celsius.
  - The confidence in the measurement is such that we are certain the measurement is between 0.5 and 0.7 °C.

## Scientific Notation

- We commonly measure objects that are many times larger or smaller than our standard of comparison.
- Writing large numbers of zeros is tricky and confusing.
  - Not to mention there’s the 8-digit limit of your calculator

<img src="./assets/image-20240729190505170.png" alt="image-20240729190505170" style="zoom: 33%;" />

<img src="./assets/image-20240729190532017.png" alt="image-20240729190532017" style="zoom: 33%;" />

- Each decimal place in our number system represents a different power of 10.
- Scientific notation writes the numbers so they are easily comparable by looking at the power of 10.

<img src="./assets/image-20240729190655695.png" alt="image-20240729190655695" style="zoom: 33%;" />

<img src="./assets/image-20240729190720954.png" alt="image-20240729190720954" style="zoom: 33%;" />

<img src="./assets/image-20240729191022204.png" alt="image-20240729191022204" style="zoom: 33%;" />


## Exponents

- When the exponent on 10 is positive, it means the number is that many powers of 10 larger. 
  - Sun’s diameter = 1.392 × 10^9^ m = 1.392 × 1000000000 m =  1,392,000,000 m.
  
- When the exponent on 10 is negative, it means the number is that many powers of 10 smaller.
  - Average atom’s diameter = 3 × 10^-10^ m = 3 × 0.0000000001 m = 0.0000000003 m.
  
- To compare numbers written in scientific notation:
  - First compare exponents on 10.
  
  - If exponents are equal, then compare decimal numbers

<img src="./assets/image-20240729191047238.png" alt="image-20240729191047238" style="zoom: 33%;" />

## Writing Numbers in Scientific Notation

1.	Locate the decimal point.
2.	Move the decimal point to obtain a number between 1 and 10.
3.	Multiply the new number by 10*^n^*. Where *n* is the number of places you moved the decimal point.
4.	If you moved the decimal point to the left, then *n* is positive; if you moved it to the right, then *n* is negative.
  - If the original number is 1 or larger, then *n* is positive .
  - If the original number is less than 1, then *n* is negative .

### Example

​	12340
1.  Locate the decimal point.
    12340.

2.  Move the decimal point to obtain a number between 1 and 10.
    1.234

3.  Multiply the new number by 10*^n^* . Where *n* is the number of places you moved the decimal point.
    1.234 x 10^4^

4.  If you moved the decimal point to the left, then n is positive; if you moved it to the right, then n is negative .
    1.234 x 10^4^

### Example

1.  0.00012340

2.  Locate the decimal point.
    0.00012340

3.  Move the decimal point to obtain a number between 1 and 10.
    1.2340

4.  Multiply the new number by 10*^n^* . Where *n* is the number of places you moved the decimal point.
    1.2340 x 10^4^

9.  If you moved the decimal point to the left, then *n* is postive; if you moved it to the right, then *n* is negative .
    1.2340 x 10^-4^


## Writing a Number in Standard Form

1.234 x 10^-6^
- Since the exponent is -6, make the number smaller by moving the decimal point to the left 6 places.
  - When you run out of digits to move around, add zeros.
  - Add a zero in front of the decimal point for decimal numbers.

<img src="./assets/image-20240729192104445.png" alt="image-20240729192104445" style="zoom:50%;" />

### The U.S. population in 2007 was estimated to be 301,786,000 people.  Express this number in scientific notation.

<img src="./assets/image-20240729192223285.png" alt="image-20240729192223285" style="zoom: 25%;" />

<br/>

<br/>

<br/>

<br/>

<br/>

<br/>

### Write the Following Numbers in Scientific Notation

**123.4**														**8.0012**

<br/><br/>

**145000**													    **0.00234**

<br/><br/>

**25.25**													       **0.0123**

<br/><br/>

**1.45**														 **0.000008706**

<br/><br/>

### Write the Following Numbers in Standard Form

**2.1 × 10^3^**													**4.02 × 10^0^**

<br/><br/>

**9.66 × 10^-4^**												     **3.3 × 10^1^**

<br/><br/>

**6.04 × 10^-2^**												     **1.2 × 10^5^**

<br/><br/>

## Inputting Scientific Notation into a Calculator

We’re going to practice inputting the following into your calculator.

- The number -1.23 × 10^-3^

- $\frac{-1.23 \times 10^{-3}}{4.78 \times 10^5}$

- $(-1.37 \times 10^{-4})(5.92 \times 10^2)$

  

## Significant Figures

### Writing numbers to reflect precision.

### Exact Numbers vs. Measurements
- Sometimes you can determine an exact value for a quality of an object.
  - Often by counting.
    - Pennies in a pile.
  - Sometimes by definition
    - 1 ounce is exactly 1/16 pounds.
- Whenever you use an instrument to compare a quality of an object to a standard, there is uncertainty in the comparison.


### Reporting Measurements
- Measurements are written to indicate the uncertainty in the measurement.
- The system of writing measurements we use is called **significant figures**.
- When writing measurements, all the digits written are known with certainty except the last one, which is an estimate.

<img src="./assets/image-20240729193939360.png" alt="image-20240729193939360" style="zoom: 33%;" />

### Estimating the Last Digit

- For instruments marked with a scale, you get the last digit by estimating between the marks.

  - If possible.

- Mentally divide the space into 10 equal spaces, then estimate how many spaces over the indicator is.

<img src="./assets/image-20240729190044580.png" alt="image-20240729190044580" style="zoom: 15%;" />

<img src="./assets/image-20240729194130267.png" alt="image-20240729194130267" style="zoom: 50%;" />

  ### What is the temperature reading on the thermometer to the correct number of digits?

<img src="./assets/image-20240729194347473.png" alt="image-20240729194347473" style="zoom: 20%;" />



## Which Digits are Significant?

- The non-placeholding digits in a reported measurement are called significant figures.
  - Some zeros in a written number are only there to help you locate the decimal point. 
  
- Significant figures tell us the range of values to expect for repeated measurements.
  - The more significant figures there are in a measurement, the smaller the range of values.  Therefore, the measurement is more precise.

<img src="./assets/image-20240729194825658.png" alt="image-20240729194825658" style="zoom:50%;" />

## Counting Significant Figures
- All non-zero digits are significant.
  - 1.5 has 2 significant figures.
- Interior zeros are significant.
  - 1.05 has 3 significant figures.
- Trailing zeros after a decimal point are significant.
  - 1.050 has 4 significant figures.
- Leading zeros are **NOT** significant.
  - 0.001050 has 4 significant figures.
- Zeros at the end of a number without a written decimal point are ambiguous and should be avoided by using scientific notation.
  - If 150 has 2 significant figures, then 1.5 x 10^2^, but if 150 has 3 significant figures, then 1.50 x 10^2^.

**Scientific Numbers are only written with Significant Digits. This is how you avoid ambiguity**

### Significant Figures and Exact Numbers

- Exact numbers have an unlimited number of significant figures. 
- A number whose value is known with complete certainty is exact.
  - From counting individual objects.
  - From definitions.
    - 1 cm is exactly equal to 0.01 m.
  - From integer values in equations.
       - In the equation for the radius of a circle, the 2 is exact.

$$
\bar{r} = \frac{Diameter}{2}
$$


### How many significant figures are in each of the following numbers?

**0.0035**												**1.080**

<br/>

**2371**												**2.97 × 10^5^**

<br/>

**1 dozen = 12**								       			**100,000**

<br/>

### Determine the Number of Significant Figures, the Expected Range of Precision, and Indicate the Last Significant Figure 

**12000**														**120.**

<br/>

**12.00**													 	**1.20 x 10^3^**

<br/>

**0.0012**												      	       **0.00120**

<br/>

**1201**													  	**1201000**

<br/>

## Rounding

- When rounding to the correct number of significant figures, if the number after the place of the last significant figure is:
  - 0 to 4, round down.
    - Drop all digits after the last significant figure and leave the last significant figure alone.
    - Add insignificant zeros to keep the value, if necessary.
  - 5 to 9, round up.
    - Drop all digits after the last significat figure and increase the last significant figure by one.
    - Add insignificant zeros to keep the value, if necessary.
      **Example**
- Rounding to 2 significant figures.
  - 2.34 rounds to 2.3
  - 2.37 rounds to 2.4
  - 2.349865 rounds to 2.3
  - 0.0234 rounds to 0.023 or 2.3 × 10^-2^
  - 0.0237 rounds to 0.024 or 2.4 × 10^-2^
  - 0.02349865 rounds to 0.023 or 2.3 × 10^-2^
  - 234 rounds to 230 or 2.3 × 10^2^ 
  - 237 rounds to 240 or 2.4 × 10^2^ 
  - 234.9865 rounds to 230 or 2.3 × 10^2^ 

## Multiplication and Division with Significant Figures

When multiplying or dividing measurements with significant figures, the result has the same number of significant figures as the measurement with the fewest number of significant figures.

<img src="./assets/image-20240729201437439.png" alt="image-20240729201437439" style="zoom:33%;" />

### Determine the Correct Number of  Significant Figures for Each Calculation. Round and Report the Result.

$\Large\frac{1.01 \times 0.12 \times 53.51}{96} =$



$\Large\frac{56.55 \times 0.920}{34.2585} =$



## Addition and Subtraction with Significant Figures

When adding or subtracting measurements with significant figures, the result has the same number of decimal places as the measurement with the fewest number of decimal places.

<img src="./assets/image-20240729203516297.png" alt="image-20240729203516297" style="zoom: 33%;" />

### Determine the Correct Number of  Significant Figures for Each Calculation. Round and Report the Result.

$\large0.987 + 125.1 - 1.22 =$



$\large0.764 - 3.449 - 5.98 =$




## Both Multiplication/Division and Addition/Subtraction with Significant Figures

- When doing different kinds of operations with measurements with significant figures, evaluate the significant figures in the intermediate answer, then do the remaining steps.
- Follow the standard order of operations.
  - Please Excuse My Dear Aunt Sally.
    ![image-20240729203924340](./assets/image-20240729203924340.png)

<img src="./assets/image-20240729204020374.png" alt="image-20240729204020374" style="zoom: 50%;" />

### Perform the Following Calculations to the Correct Number of Significant Figures

$\large1.10 \times 0.5120 \times 4.0015 - 3.4555 =$



$\Large\frac{4.562 \times 3.99870}{452.6755 - 452.33} =$



$\large(14.84 \times 0.55) - 8.02 =$



## Units

- Units tell the standard quantity to which we are comparing the measured property.
  - Without an associated unit, a measurement is without meaning.
- Scientists use a set of standard units for comparing all our measurements.
  - So we can easily compare our results.
- Each of the units is defined as precisely as possible.
- Scientists generally report results in an agreed upon International System.
- The SI System
  - Système International

|  Quantity   |     Unit      | Symbol |
| :---------: | :-----------: | :----: |
|   Length    |     meter     |   m    |
|    Mass     |   kilogram    |   kg   |
|    Time     |    second     |   s    |
| Temperature |    kelvin     |   K    |
|   Volume    | liter (litre) |   L    |

## Length

- Measure of the two-dimensional distance an object covers.
- The SI unit for length is a meter, about 3½ inches longer than a yard.
  - One ten-millionth the distance from the North Pole to the Equator 
  - Distance between marks on standard metal rod in a Paris vault
  - Distance covered by a certain number of wavelengths of a special color of light

<img src="./assets/image-20240729205453100.png" alt="image-20240729205453100" style="zoom:33%;" />

<img src="./assets/image-20240729213745492.png" alt="image-20240729213745492" style="zoom: 15%;" />

## Mass

- Measure of the amount of matter present in an object.
- The SI unit is the kilogram (kg), about 2 lbs. 3 oz. It's important to note the base unit is **not** the gram.

<img src="./assets/image-20240729214316963.png" alt="image-20240729214316963" style="zoom: 20%;" />

## Time

- Measure of the duration of an event.
- The SI units is the second (s)
  - 1 s is defined as the period of time it takes for a specific number of radiation events of a specific transition from cesium-133.

<img src="https://upload.wikimedia.org/wikipedia/commons/thumb/3/3d/Cesium.jpg/1280px-Cesium.jpg" alt="Some pale gold metal, with a liquid-like texture and lustre, sealed in a glass ampoule" style="zoom:15%;" />

## Temperature

- Measure of the average amount of kinetic energy.
  - The higher the temperature the greater the average kinetic energy
- Heat flows from the matter that has high thermal energy into matter that has low thermal energy.
  -  Until they reach the same temperature.
- Heat is exchanged through molecular collisions between the two materials.
  Related Units in the 

## SI System
- All units in the SI system are related to the standard unit by a power of 10.
- The power of 10 is indicated by a prefix.
- The prefixes are always the same, regardless of the standard unit.
- It is usually best to measure a property in a unit close to the size of the property.
  - It reduces the number of confusing zeros.
  Common Prefixes in the 

<img src="./assets/image-20240729215341568.png" alt="image-20240729215341568" style="zoom: 50%;" />



<img src="./assets/image-20240729215550961.png" alt="image-20240729215550961" style="zoom: 33%;" />



##### Which of the Following Units Would Be Best Used for Measuring the Diameter of a Quarter? 

- kilometer
- meter
- centimeter
- micrometer
- megameters

## Volume

- Derived unit.
  - Any length unit cubed.
  
  <img src="./assets/image-20240729222236832.png" alt="image-20240729222236832" style="zoom: 25%;" />
- Measure of the amount of space occupied.
- SI unit = cubic meter (m^3^)
- Commonly measure liquid or gas volume in milliliters (mL).
  - 1 L is slightly larger than 1 quart.
  - 1 L =  1 dm^3^ = 1000 ml = 10^3^ mL 
  - 1 ml = 0.001 L = 10^-3^ L
  - 1 mL = 1 cm^3^
    

<img src="./assets/image-20240729222302370.png" alt="image-20240729222302370" style="zoom:15%;" />
      
##### Which Is Larger?
- 1 yard or 1 meter?
- 1 mile or 1 km?
- 1 cm or 1 inch?
- 1 kg or 1 lb?
- 1 mg or 1 μg?
- 1 qt or 1 L?
- 1 L or 1 gal?
- 1 gal or 1000 cm^3^?

### How to use Units

- Always write every number with its associated unit.
- Always include units in your calculations.
 - You can do the same kind of operations on units as you can with numbers.
    - cm × cm = cm^2^
    - cm + cm = cm
    - cm ÷ cm = 1
- You can use units as a guide to problem solving 
  - This is called dimensional analysis.

## Conversions

- Many problems in chemistry involve using relationships to convert one unit of measurement to another.
- Conversion factors are relationships between two units.
  - May be exact or measured.
  - Both parts of the conversion factor have the same number of significant figures.
- Conversion factors generated from equivalence statements.

$$
1 \text{ inch} = 2.54 \text{ cm}
$$

$$
\frac{2.54 \text{ cm}}{1 \text{ in}} \hspace{20mm} \frac{1 \text{ in}}{2.54 \text{ cm}}
$$

- Arrange conversion factors so the starting unit cancels.
  - The starting unit should in the denominator of the conversion factor.
$$
2 \color{red}\cancel{\color{black}\text{ hr}}\color{black} \left(\frac{30 \text{ mi}}{1 \color{red}\cancel{\color{black}\text{ hr}}} \right) = 60 \text{ miles}
$$
- May string conversion factors.
  - So we do not need to know every relationship, as long as we can find something else the starting and desired units are related to :

$$
5 \color{red}\cancel{\color{black}\text{ cups}}\color{black}\left( \frac{1 \color{blue}\cancel{\color{black}\text{ pint}}}{2 \color{red}\cancel{\color{black}\text{ cups}}} \right) \left( \frac{1 \text{ quart}}{2 \color{blue}\cancel{\color{black}\text{ pints}}} \right) = 1.25 \text{ quarts}
$$

##### Convert 7.8 km to miles

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

##### Convert 30.0 g to Ounces

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

##### An Italian recipe for making creamy pasta sauce calls for 0.75 L of cream.  Your measuring cup measures only in cups.  How many cups should you use?

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

##### Convert 30.0 mL to Quarts

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

##### Convert 2,659 cm^2^ to Square Meters

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

## Mass and Volume
- Two main characteristics of matter.
- Cannot be used to identify what type of matter something is.
  - If you are given a large glass containing 100 g of a clear, colorless liquid and a small glass containing 25 g of a clear, colorless liquid, are both liquids the same stuff?
- Even though mass and volume are individual properties, for a given type of matter they are related to each other!

## Density
- Ratio of mass to volume.

$$
D=\frac{m}{V}
$$

- Its value depends on the kind of material, not the amount.
  - Solids = g/cm^3^ (g/ml)
  - Liquids = g/mL
  - Gases = g/L
- Volume of a solid can be determined by water displacement—Archimedes Principle.
- Density :  solids > liquids > gases
  - Water is an exception
- When volumes are equal, the more dense substance will be heavier .
- When the mass of two samples is equal, the more dense substance will have smaller volume.
- Heating causes objects causes objects to expand. Lowering their density.
    - Volume will increase
    - Mass will remain the same
- In a heterogeneous mixture, the more dense object sinks.

##### Solve the density equation for mass and volume.

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

##### Platinum has become a popular metal for fine jewelry.  A man gives a woman an engagement ring and tells her that it is made of platinum.  Noting that the ring felt a little light, the woman decides to perform a test to determine the ring’s density before giving him an answer about marriage.  She places the ring on a balance and finds it has a mass of 5.84 grams.  She then finds that the ring displaces 0.556 cm^3^ of water.  Is the ring made of platinum? (Density Pt = 21.4 g/cm^3^)

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

##### What Is the Density of Metal if a 100.0 g Sample Added to a Cylinder of Water Causes the Water Level to Rise from 25.0 mL to 37.8 mL?

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

##### How much does 4.0 cm^3^ of lead (11.3 g/cm^3^) weigh?

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

##### The gasoline in an automobile gas tank has a mass of 60.0 kg and a density of 0.752 g/cm^3^.  What is the volume?

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

##### A 55.9 kg person displaces 57.2 L of water when submerged in a water tank.  What is the density of the person in g/cm^3^?

<div style="page-break-after: always; visibility: hidden"> 
\pagebreak 
</div>


# Chapter 2 Quiz

1. Numbers are usually written so that the uncertainty is in the last reported digit. (1 Point)

​				True				False

2. If you count 7 pennies, you can only report one significant figure in that measurement. (1 Point)

​				True				False

3. Measurements have an unlimited number of significant figures. (1 Point)

​				True				False

4. Zeros located between two numbers are not significant. (1 Point)

​				True				False

5.  A trailing zero after a decimal point is significant. (1 Point)

​				True				False

6. Trailing zeros at the end of a number, but before an implied decimal point, are ambiguous. (1 Point)

​				True				False

7. In multiplication and division calculations, the answer will have the same number of decimal places as the number carrying the fewest decimal places. (1 Point)

​				True				False

8. In addition and subtraction calculations, the answer will have the same number of significant digits as the number carrying the most decimal places. (1 Point)

​				True				False

9. In addition or subtraction, the result carries the same number of decimal places as the quantity carrying the fewest decimal places. (1 Point)

​				True				False

10. Scientific numbers are reported so that every digit is certain except the last, which is estimated. (1 Point)

​				True				False

11. The mass of an object depends on gravity. (1 Point)

​				True				False




12. The correct scientific notation for the number 0.07805 is:  (2 Point)

A) 7.805 × 10^2^

B) 7.805 × 102

C) 7.805 × 10^-2^

D) 0.7805 × 10^-2^

E) none of the above



13. The correct scientific notation for the number 500.0 is:  (2 Point)

A) 5 × 10^2^

B) 5.00 × 10^2^

C) 5.000 × 10^2^

D) 5 × 10^-2^

E) none of the above



14. The correct decimal representation of 1.709 × 10^-5^ is:  (2 Point)

A) 170900

B) 0.0001709

C) 0.00001709

D) 1709

E) none of the above



15. The correct decimal representation of 6.453 × 10^3^ is:  (2 Point)

A) 6,453

B) 0.006453

C) 6.5 × 10^3^

D) 6.453

E) none of the above



16. The correct number of significant figures in the number 12501 is:  (2 Point)

A) 5

B) 7

C) 4

D) ambiguous

E) none of the above



17. The correct number of significant figures in the number 9.08 x 10^-4^ is  (2 Point)

A) 3

B) 4

C) 5

D) ambiguous

E) none of the above



18. When the value 4.449 is rounded to two significant figures, the number should be reported as:  (2 Point)

A) 4.4

B) 4.5

C) 4.44

D) 4.45

E) none of the above



19. Determine the answer for the equation below with correct number of significant figures: 

3.2 × 1.729 = ________   (2 Point)

A) 5.5328

B) 5.533

C) 5.54

D) 5.5

E) none of the above



20. Determine the answer to the following equation with correct number of significant figures:

2.02 + 8.102 - 0.0297 = ________   (2 Point)

A) 10.0923

B) 10.09

C) 10.1

D) 10.092

E) none of the above



21. The correct prefix for the multiplier 1,000,000 is:  (2 Point)

A) mega (M)

B) milli (m)

C) micro (μ)

D) nano (n)

E) none of the above



22. What is the standard SI unit for mass?  (2 Point)

A) kilogram

B) gram

C) pound

D) ton

E) none of the above

<div style="page-break-after: always; visibility: hidden"> 
\pagebreak 
</div>

# Chapter 3
## What is Matter?
- Matter is defined as anything that occupies space and has mass

- Even though it appears to be smooth and continuous, matter is actually composed of a lot of tiny little pieces we call **atoms** and **molecules**

- Atoms are the tiny particles that make up all matter.

  <img src="./assets/image-20240730151901883.png" alt="image-20240730151901883" style="zoom:33%;" />

- In most substances, the atoms are joined together in units called molecules

  <img src="./assets/image-20240730151918390.png" alt="image-20240730151918390" style="zoom:33%;" />

## Classifying Matter by Physical State

- Matter can be classified as solid, liquid or gas based on what properties it exhibits 

| Phase      | Shape      | Volume     | Compress | Flow |
| ---------- | ---------- | ---------- | -------- | ---- |
| **Solid**  | Fixed      | Fixed      | No       | No   |
| **Liquid** | Indefinite | Fixed      | No       | Yes  |
| **Gas**    | Indefinite | Indefinite | Yes      | Yes  |

- These properties are the result of the arrangement of the atoms and molecules comprising a sample of matter. 

![image-20240730152354376](./assets/image-20240730152354376.png)

## Solid

- The particles in a solid are packed close together and are fixed in position
  - though they may vibrate
  
- The close packing of the particles results in solids being incompressible

- The inability of the particles to move around results in solids retaining their shape and volume when placed in a new container; and prevents the particles from flowing

  <img src="./assets/image-20240730152701577.png" alt="image-20240730152701577" style="zoom:50%;" />

- Some solids have their particles arranged in an orderly geometric pattern – we call these **crystalline solids**.

  - Salt and Diamonds are examples

- Other solids have particles that do not show a regular geometric pattern over a long range. They are called **amorphous solids**

  - Plastic and Glass are examples

  <img src="./assets/image-20240802170717791.png" alt="image-20240802170717791" style="zoom:40%;" />

## Liquids

- The particles in a liquid are closely packed, but they have some ability to move around 

- the close packing results in liquids being incompressible

- The ability of the particles to move allows liquids to take the shape of their container and to flow. However they don’t have enough freedom to escape and expand to fill the container.

## Gases

- In the gas state, the particles have complete freedom from each other

- The particles are constantly flying around, bumping into each other and the container

- In the gas state, there is a lot of empty space between the particles
  - on average 
- Because there is a lot of empty space, the particles can be squeezed closer together – therefore gases are compressible

<img src="./assets/image-20240730153409308.png" alt="image-20240730153409308" style="zoom:50%;" />

- Because the particles are not held in close contact and are moving freely, gases expand to fill and take the shape of their container, and will flow



## Pure Substances vs. Mixtures

<img src="./assets/image-20240730171256220.png" alt="image-20240730171256220" style="zoom:50%;" />

- In a **Pure Substance** the entire sample is made of the same atoms or molecules.

  - All samples have the same properties

- In **Mixtures**  different samples may have components present in different percentages

  - Samples with varying composition will exhibit different properties.

  

## Elements and Compounds

- Substances which can not be broken down into simpler substances by chemical reactions are called **elements**.

- Most substances are chemical combinations of elements.  These are called **compounds**.
  - Compounds can be broken down into elements
  - Properties of the compound not related to the properties of the elements that compose it

### Elements

- Smallest piece of an **element** is called an **atom**
  - There are subatomic particles, but these are no longer the element
- Every sample of an element is made up of lots of identical atoms
- 118 known, of which about 91 are found in nature
  - The others are man made. Usually inside a particle accelerator.
- There is a natural distribution of elements known as there **abundance**
  - The abundance and form of an element varies in different parts of the environment
  - Oxygen most abundant element (by mass) on earth and in the human body

### Compounds

- Smallest piece of a **compound** is called a **molecule**
  - Molecules are made of atoms
  - All molecules of a compound are identical
  - Each molecule has the same number and type of atoms
 - Composed of elements in fixed percentages
  - water is 89 mass% O & 11 mass% H
- Billions of known compounds
- Same elements can form more than one different compound
  - Water and hydrogen peroxide contain just hydrogen and oxygen
  - Carbohydrates all contain just C, H and O
  



## Mixtures  

- Mixtures come in two forms **homogeneous** and **heterogeneous**.

- Homogeneous Mixtures are uniform throughout 

  - Appears to be one thing
  - Every piece of a sample has identical properties 
    - Another sample with the same components may have different properties
  - Homogeneous mixtures are sometimes called solutions

- Heterogeneous Mixtures are non-uniform 

- They contain different regions with different properties

  

  | Pure Substances                                              | Mixtures                                                     |
  | ------------------------------------------------------------ | ------------------------------------------------------------ |
  | All samples have the same physical and chemical properties   | Different samples may show different properties              |
  | Constant composition; all samples have the same components in the same percentages. | Variable composition; samples made with the same pure substances may have different percentages |
  | Homogeneous                                                  | Homogeneous or Heterogeneous                                 |
  | Separate components of a **compound** based on chemical properties | Separate into components based on physical properties        |
  | Temperature usually stays constant while melting or boiling  | Temperature changes while melting or boiling because composition changes |

  

## Properties of Matter

- **Physical Properties** are the characteristics of matter that can be changed without changing its composition
- **Chemical Properties** are the characteristics that determine how the composition of matter changes as a result of contact with other matter or the influence of energy 

### Some Physical Properties
- mass
- volume
- density
- phase
- magnetic susceptability
- specific heat
- melting point
- boiling point
- volatility
- taste
- solubility
- electrical condictivity
- thermal conductivity
- malleability
- ductility

### Some Chemical Properties

- acidity
- basicity
- corrosiveness
- reactivity
- explosiveness
- flammability
- combustibility
- reduction potential

### Properties of a Mixture

<img src="./assets/image-20240730192115701.png" alt="image-20240730192115701" style="zoom:50%;" />



### Physical Changes

- Physical Changes are changes in the properties of matter that do not effect its composition

  - Heating water raises its temperature. But it is still water. 

  - Evaporating butane from a lighter

  - Dissolving sugar in water 



### Chemical Changes

- Chemical Changes involve a change in a sample’s composition. A Chemical Reaction.

  - Rusting is iron combining with oxygen to make iron(III) oxide

  - Burning butane from a lighter changes it into carbon dioxide and water

  - Silver combines with sulfur in the air to make tarnish

<img src="./assets/image-20240802162212381.png" alt="image-20240802162212381" style="zoom: 50%;" />



### Phase Changes are Physical Changes

- Boiling = liquid to gas
- Melting = solid to liquid
- Subliming = solid to gas
- Condensing = gas to liquid
- Freezing = liquid to solid
- Deposition = gas to solid
- State changes require heating or cooling the substance
  - Evaporation is not a simple phase change, it is a solution process

<img src="./assets/image-20240730192910216.png" alt="image-20240730192910216" style="zoom:80%;" />

### Separation of Mixtures

- Mixtures are separated based on different physical properties of the components

  | Physical Property | Separation Technique |
  | ----------------- | -------------------- |
  | Boiling Point     | Distillation         |
  | Phase             | Filtration           |
  | Surface Adhesion  | Chromatography       |
  | Volatility        | Evaporation          |
  | Density           | Centrifugation       |




##### Distillation and Filtration

<img src="./assets/image-20240802161855169.png" alt="image-20240802161855169" style="zoom:50%;" />

## Law of Conservation of Mass

- This Law is attributed to Antoine Lavoisier

> Matter is neither created nor destroyed in a chemical reaction

- The total amount of matter present before a chemical reaction is always the same as the total amount after
- The total mass of all the reactants is equal to the total mass of all the products
- Total amount of matter remains constant in a chemical reaction

##### 58 grams of butane burns in 208 grams of oxygen to form 176 grams of carbon dioxide and 90 grams of water
$$
\ce{
butane + oxygen -> carbon dioxide + water
\\
58 g + 208 g -> 176 g + 90 g
\\
266 g -> 266 g
}
$$


## Energy

- We have observed something that has neither mass or volume, Energy.

- Energy is anything that has the capacity to do work

- Even though Chemistry is the study of matter, matter is effected by energy
  - it can cause physical and/or chemical changes in matter



### Law of Conservation of Energy

>  Energy can neither be created nor destroyed 

- The total amount of energy in the universe is constant – there is no process that can increase or decrease that amount
- However we can transfer energy from one place in the universe to another, and we can change its form
	- When a piece of matter possesses energy, it can give some it to another object
- All chemical and physical changes result in matter releasing or absorbing energy



### Kinds of Energy

- **Kinetic Energy** is energy of motion, or energy that is being transferred from one object to another

- **Potential Energy** is energy that is stored

<img src="./assets/image-20240730194304561.png" alt="image-20240730194304561" style="zoom:67%;" />

- **Electrical Energy** is kinetic energy associated with the flow of electrical charge

- **Thermal Energy** is kinetic energy associated with molecular motion

- **Light** or **Radiant Energy** is kinetic energy associated with energy of subatomic particles called photons

- **Nuclear Energy** is potential energy in the nucleus of atoms 

- **Chemical Energy** is potential energy in the attachment of atoms or because of their position
- We use energy to accomplish all kinds of processes, but according to the Law of Conservation of Energy we don’t really use it up!
  - When we use energy we are changing it from one form to another
  - For example, converting the chemical energy in gasoline into mechanical energy to make your car move 
- In practice no process is 100% efficient. Some energy will be loss usually in the form of heat. 



### Units of Energy

- **calorie** (cal) is the amount of energy needed to raise one gram of water by 1°C
- 1 *food calorie* or **Calorie** (cal)[Note the capital "C"} is 1,000 *calories* (cal) [Lower case "c"]l
  - 1 Cal = 1000 cal = 1 kcal
- Joule (J) is equal to the amount of work done when a force of 1 newton displaces a mass through a distance of 1 meter in the direction of the force applied.
  - It is the standard SI unit for energy
- Kilowatt-hour (kWh) is the energy delivered by 1000 Watts of power over one hour.
  - Typically used when dealing with large amounts of energy

<img src="./assets/image-20240802162347839.png" alt="image-20240802162347839" style="zoom: 67%;" />

##### A candy bar contains 225 Cal of nutritional energy.  How many joules does it contain?

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

### Exothermic vs. Endothermic

- A chemical change (reaction) can either release or absorb energy
- Chemical reactions where energy is released are called **exothermic**
- Chemical reactions where energy is absorbed are called **endothermic**
- Energy is usually transferred in the form of heat

<img src="./assets/image-20240802165044263.png" alt="image-20240802165044263" style="zoom: 67%;" />

##### Classify each process as exothermic or endothermic.

a. gasoline burning in a car
b. isopropyl alcohol evaporating from skin
c. water condensing as dew during the night

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

### Heat

- Heat is the exchange of thermal energy between samples of matter
- Heat flows from the matter that has high thermal energy to matter that has low thermal energy
  - Until they reach the same temperature
- Heat is exchanged through molecular collisions between two samples
  
## The Meaning of Temperature

- Temperature is a measure of the average kinetic energy of the molecules in a sample
- Not all molecules have in a sample the same amount of  kinetic energy
- A higher temperature means a larger *average* kinetic energy

### Fahrenheit

- The Fahrenheit Temperature Scale used as its two reference points the freezing point of concentrated saltwater (0 °F) and average body temperature (100 °F)
  - more accurate measure now set average body temperature at 98.6 °F
- Room temperature is about 75 °F 


### Celsius

- The Celsius Temperature Scale used as its two reference points the freezing point of distilled water (0 °C) and boiling point of distilled water (100 °C)
  - more reproducible standards
  - most commonly used in science
- Room temperature is about 25 °C 

### Fahrenheit vs. Celsius

- A Celsius degree is 1.8 times larger than a Fahrenheit degree
- 0 °C is 32 °F
- Because the scales are offset from one another, we have a more complicated formula for converting between them.

<img src="./assets/image-20240802154441310.png" alt="image-20240802154441310" style="zoom: 33%;" />

### The Kelvin Temperature Scale

- Both the Celsius and Fahrenheit scales have negative numbers
- The Kelvin scale is an absolute scale, meaning it does not allow for negative values. 
- 0 K is called **Absolute Zero**. The lowest possible temperature. 
  - All molecular motion would stop at 0 K
  - Absolute Zero is a theoretical value and has not yet been achieved in lab.

## Kelvin vs. Celsius
- The size of a “degree” on the Kelvin scale is the same as on the Celsius scale
  - that makes 1 K 1.8 times larger than 1°F
- The 0 standard on the Kelvin scale is a much lower temperature than on the Celsius scale

<img src="./assets/image-20240802155223971.png" alt="image-20240802155223971" style="zoom: 13%;" />



<img src="./assets/image-20240802165126717.png" alt="image-20240802165126717" style="zoom: 67%;" />




##### Convert 310 K to Fahrenheit


## Energy and the Temperature of Matter

- The amount the temperature of an object increases depends on the amount of heat energy added (q).
  - If you double the added heat energy the temperature will increase twice as much.
- The amount the temperature of an object increases depends on its mass
  - If you double the mass it will take twice as much heat energy to raise the temperature the same amount.

### Heat Capacity

- Heat capacity is the amount of heat *an object* must absorb to raise its temperature 1°C
  - cal/°C or J/°C
  - Metals have low heat capacities
  - Thermal insulators high
  - Extensive quantity
- Specific heat = heat capacity of 1 gram of the substance
  - cal/g°C or J/g°C
  - Waters specific heat = 4.184 J/g°C for liquid 
    - 1.000 cal/g°C
- The larger a material’s specific heat is, the more energy it takes to raise its temperature.
  - Water’s high specific heat is the reason it is such a good cooling agent
- like density, specific heat is a property of the type of matter
  - It can be used to identify the type of matter
- it doesn’t matter how much material you have 
  - Intensive quantity

|     Substance     | Specific Heat ($\frac{\text{J}}{\text{g}\cdot^\cdot\text{C}}$) |
| :---------------: | :----------------------------------------------------------: |
|     Aluminum      |                            0.895                             |
|      Calcium      |                            0.656                             |
| Carbon (diamond)  |                            0.508                             |
| Carbon (graphite) |                            0.708                             |
|      Copper       |                            0.377                             |
|       Gold        |                            0.129                             |
|       Iron        |                            0.448                             |
|       Lead        |                            0.129                             |
|      Silver       |                            0.712                             |
|    Water (*l*)    |                            4.184                             |
|    Water (*s*)    |                             2.03                             |
|    Water (*g*)    |                             2.02                             |


## Heat Gain or Loss by an Object

- The amount of heat energy gained or lost by an object depends on 3 factors
  - The mass of the substance (*m*)
  - The sunstances **Specific Heat Capacity** (*c*) 
  - The temperature changed, T~F~ - T~i~, or ΔT

$$
\Large
q = mc\Delta T
$$



##### Gallium is a solid metal at room temperature, but melts at 29.9°C.  If you hold gallium in your hand, it melts from body heat.  How much heat must 2.5 g of gallium absorb from your hand to raise its temperature from 25.0°C to 29.9°C?  The heat capacity of gallium is 0.372 J/g°C

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

##### A backpacker wants to carry enough fuel to heat 2.5 kg ofwater from 25 °C to 100.0 °C. If the fuel she carries produces 36 kJ of heat per gram when it burns, how muchfuel should she carry? (For the sake of simplicity, assume that the transfer of heat is 100% efficient.)

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

##### If 89 J of heat are added to a pure gold coin with a mass of 12 g, what is its temperature change?

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

##### An iron nail with a mass of 12 g absorbs 15 J of heat. If the nail was initially at 28 °C, what is its final temperature?

<div style="page-break-after: always; visibility: hidden"> 
\pagebreak 
</div>

# Chapter 3 Quiz

1. An amorphous solid has long range, repeating order. (1 Point)

​				True				False

2. Liquids have definite volume and shape. (1 Point)

​				True				False

3. Solids have indefinite shape but a defined volume. (1 Point)

​				True				False

4. Saltwater is a mixture. (1 Point)

​				True				False

5. Calcium is a pure substance. (1 Point)

​				True				False

6. Flammability of gasoline is a chemical property. (1 Point)

​				True				False

7. The boiling of water is a physical change. (1 Point)

​				True				False

8. In physical changes, the atoms or molecules that compose the matter do not change their identity, even though the matter may change its appearance. (1 Point)

​				True				False

9. All chemical changes are endothermic. (1 Point)

​				True				False

10. Like mass, energy can neither be created nor destroyed. (1 Point)

​				True				False

11. An increase of temperature implies the atoms/molecules of a substance are moving faster. (1 Point)

​				True				False

12. The coldest temperature possible is 0 °C. (1 Point)

​				True				False



 

13. Which of the following statements about matter is FALSE? (2 Point)

A) Matter occupies space and has mass.

B) Matter exists in either a solid, liquid or gas state.

C) Matter is ultimately composed of atoms.

D) Matter is always smooth and continuous.

E) none of the above



14. A pure substance is:  (2 Point)

A) composed of two or more different types of atoms or molecules combined in variable proportions.

B) composed of only one type of atom or molecule.

C) composed of two or more regions with different compositions.

D) composed of two or more different types of atoms or molecules with a constant composition.

E) none of the above



15. When ammonium nitrate (NH~4~NO~3~) is heated, it produces nitrous oxide (N~2~O) and water (H~2~O). If 50.0 g of ammonium nitrate is heated yielding 32.0 g of water, what mass of nitrous oxide was produced? (2 Point)

A) 8.0 g

B) 18.0 g

C) 82.0 g

D) 32.0 g

E) none of the above



16. How many joules are there in a 255 Calorie snack bar? (2 Point)

A) 2.55 × 10^-6^ J

B) 1.07 × 10^6^ J

C) 1.07 × 10^3^ J

D) 6.09 × 10^4^ J

E) none of the above



17. If a particular process is exothermic, then energy was (2 Point)

A) absorbed

B) not transferred

C) released

D) destroyed

E) none of the above



18. What is the value of 47°C on the Kelvin temperature scale? (2 Point)

A) 273 K

B) 320 K

C) 300 K

D) 226 K

E) none of the above



19. What is the value of 27°C on the Fahrenheit temperature scale? (2 Point)

A) -6.8

B) 106

C) 300

D) 81

E) none of the above



20. A lead ball is heated from 25.0 °C to 103 °C by 40.5 joules of heat. Given the specific heat of lead is 0.128 J/g∙°C, what is the mass of the ball? (2 Point)

A) 3.07 g

B) 12.7 g

C) 41.0 g

D) 4.06 g

E) none of the above



21. How much heat (kJ) is needed to raise the temperature of 100.0 grams of water from 25.0°C to 50.0°C? (2 Point)

A) 10450 kJ

B) 0.598 kJ

C) 1.05 kJ

D) 10.5 kJ

E) none of the above

<div style="page-break-after: always; visibility: hidden"> 
\pagebreak 
</div>

# Chapter 4

## Atoms and Elements

- Atoms are incredibly small, yet they compose everything.
- Atoms are the pieces of elements.
  - Each has its own, unique kind of atom.
  - They have different structures. Therefore they have different properties.
- Properties of the atoms determine the properties of the elements.

<img src="./assets/image-20240803132443218.png" alt="image-20240803132443218" style="zoom: 25%;" />

### The Divisibility of Matter

- Infinitely divisible
  - For any two points, there is always a point between. 
- Ultimate particle
  - Upon division, eventually a particle is reached which can no longer be divided. 

<img src="./assets/image-20240803143831716.png" alt="image-20240803143831716" style="zoom: 33%;" />

<img src="./assets/image-20240803143840221.png" alt="image-20240803143840221" style="zoom: 25%;" />

### Dalton’s Atomic Theory

1. Each Element is composed of tiny, indestructible particles called atoms.
2. All atoms of an element are identical.
  - They have the same mass, volume, and other physical and chemical properties.
3. Atoms combine in simple, whole-number ratios to form molecules of compounds.  
  - Because atoms are unbreakable, they must combine as whole atoms.
  - The nature of the atom determines the ratios in which it combines.  
  - Each molecule of a compound contains the exact same types and numbers of atoms.
    - Law of Constant Composition
    - Chemical formulas

<img src="./assets/image-20240803144354770.png" alt="image-20240803144354770" style="zoom:50%;" />

- Using compositions of compounds and assumed formulas, Dalton was able to determine the relative masses of all the atoms.
  - Dalton based his scale on H = 1 amu. 
  - We now base it on C-12 = 12 amu exactly.
  - amu = atomic mass unit. 
- Absolute sizes of atoms:
     Mass of H atom= 1.67 x 10^-24^ g.
     Volume of H atom = 2.1 x 10^-25^ cm^3^.

## Charges

- There are two kinds of charges, called positive (+) and negative (-).
  - Opposite charges attract.
  - Like charges repel.
  - Neutral objects **either** have no charge **or** equal amounts of opposite charges.


<img src="./assets/image-20240803150812796.png" alt="image-20240803150812796" style="zoom: 25%;" />

### The Electron

- Work done by J. J. Thomson and others proved that the atom had pieces called **electrons**.

- Thomson found that electrons are much smaller than atoms and carry a negative charge.
  - The mass of the electron is 1/1836^th^ the mass of a hydrogen atom.
  - The charge on the electron is the fundamental unit of charge that we call –1 charge unit.

##### The  Plum Pudding Model

<img src="./assets/image-20240803151759042.png" alt="image-20240803151759042" style="zoom:50%;" />

1.	The mass of the atom is due to the mass of the electrons.
2.	There must be a lot of empty space in the atom. 
  - Since the electrons are negative, it is assumed you must keep them apart so they will not repel each other.

### Rutherford’s Experiment

**How can you prove something is empty? Put something through it.**

- Use large target atoms.
  - Use very thin sheets of target so they do not absorb the “bullet”. 
- Use very small particles as “bullet” with very high energy. 
  - But not so small that electrons will effect it.
- Rutherford used Gold Foil and alpha (α) particle radiation
  - Alpha particles have a mass of 4 amu & charge of +2 c.u.
  - Gold has a mass of 197 amu and is very malleable.

<img src="./assets/image-20240803155733295.png" alt="image-20240803155733295" style="zoom:50%;" />

- Over 98% of the alpha particles went straight through.
- About 2% of the alpha particles went through, but were deflected by large angles.
- About 0.01% of the alpha particles bounced off the gold foil.

> “...As if you fired a 15”-canon shell at a piece of tissue paper and it came back and hit you.”

##### Rutherford’s Conclusions

- Because almost all the particles went straight through, atoms are mostly empty space.
- Because of the few particles that bounced back, atoms contain a dense particle that was small in volume, compared to the atom, but large in mass. 
- Because of the large deflections of some of the particles, he concluded that the dense particle was positively charged.
  - It would have to be to repel the positively charged alpha particles.

<img src="./assets/image-20240803161132758.png" alt="image-20240803161132758" style="zoom: 67%;" />

##### The Nuclear Model
1.	The atom contains a tiny dense center called the nucleus.
  - The amount of space taken by the nucleus is only about 1 trillionth the volume of the atom.
2.	The nucleus has essentially the entire mass of the atom.
The electrons weigh so little they contribute practically no mass to the atom.
3.	The nucleus is positively charged. 
  - The amount of positive charge balances the negative charge of the electrons.
4.	The electrons are dispersed in the empty space of the atom surrounding the nucleus.
  - Like water droplets in a cloud. 

### The Proton

- Rutherford proposed that the nucleus had a particle that had the same amount of charge as an electron but opposite sign.
- He called these particles are called protons.
- Protons have a charge of +1 c.u. and a mass of 1 amu or 1.67262 × 10^-27^ kg.
- Since protons and electrons have the same amount of charge, for the atom to be neutral, there must be equal numbers of protons and electrons.

### The Neutron

**How could beryllium have 4 protons stuck together in the nucleus? Shouldn’t they repel each other?**

- If a beryllium atom has 4 protons, then it should weigh 4 amu, but it actually weighs 9.01 amu!  
  - Where is the extra mass coming from?
- To answer these questions, Rutherford proposed that there was another particle in the nucleus.
  - Since this particle could not carry a charge he called it the neutron.
  - Neutrons have a mass of 1 amu or 1.67262 × 10^-27^ kg.

### The Modern Atom

- We now know atoms are composed of three main pieces
  - protons
  - neutrons
  - electrons.
- The nucleus contains protons and neutrons.
- The radius of the atom is about 105 times larger than the radius of the nucleus.

<img src="./assets/image-20240803162524736.png" alt="image-20240803162524736" style="zoom:50%;" />

### The Nature of Electrical Charge

- Electrical charge is a fundamental property of protons and electrons.
- When a proton and electron are paired, the result is a neutral charge.
  - Because they have equal amounts of charge.

<img src="./assets/image-20240803164851359.png" alt="image-20240803164851359" style="zoom: 25%;" />

| Subatomic Particle | Mass (g)          | Mass (amu) | Charge (c.u.) | Location | Symbol     |
| ------------------ | ----------------- | ---------- | ------------- | -------- | ---------- |
| Proton             | 1.67262 × 10^-24^ | 1.0073     | 1+            | Nucleus  | p^+^, H^+^ |
| Electron           | 9.1 × 10^-28^     | 0.00055    | 1-            | Orbital  | e^-^       |
| Neutron            | 1.67493 × 10^-24^ | 1.0087     | 0             | Nucleus  | n, n^0^    |



##### An Atom Has 20 Protons.  Determine if Each of the Following Statements Is True or False?

A. If it is a neutral atom, it will have 20 electrons.
B. If it also has 20 neutrons, its mass will be approximately 40 amu.
C. If it has 18 electrons, it will have a net 2+ charge.

## The Periodic Table

### Mendeleev

<img src="./assets/image-20240803165400595.png" alt="image-20240803165400595" style="zoom:15%;" />

- Ordered elements by atomic mass.
- Saw a repeating pattern of properties. 
- Periodic law
  - When the elements are arranged in order of increasing relative mass, certain sets of properties recur periodically?
  - Used pattern to predict properties of undiscovered elements.
- Where atomic mass order did not fit other properties, he reordered by other properties.
  - Te & I

<img src="./assets/image-20240803165702109.png" alt="image-20240803165702109" style="zoom:55%;" />



<img src="./assets/image-20240803165731949.png" alt="image-20240803165731949" style="zoom:50%;" />

### Modern Periodic Table

- Each element has a unique number of protons in its nucleus.
  - All carbon atoms have 6 protons in their nuclei.
  - The number of protons in the nucleus of an atom is called the atomic number.
  - *Z* is the short-hand designation for the atomic number. 
- Because each element’s atoms have a unique number of protons, each element can be identified by its atomic number.
- The elements are arranged on the Periodic Table in order of their atomic numbers.
- Each element has a unique name and symbol.
  - The symbol is either one or two letters

- Elements with similar chemical and physical properties are in the same column.
  - Columns are called **Groups** or **Families**.
  - Designated by a number
- Rows are called **Periods**.
  - Each period shows the pattern of properties repeated in the next period.

<img src="./assets/image-20240803170930547.png" alt="image-20240803170930547" style="zoom: 50%;" />

##### What is the atomic number of boron, B?

<br/>
<br/>

##### What is the atomic mass of silicon, Si?

<br/>
<br/>

##### How many protons does a chlorine atom have?

<br/>
<br/>

##### How many electrons does a neutral neon atom have? 

<br/>
<br/>

##### Will an atom with 6 protons, 6 neutrons, and 6 electrons be electrically neutral?

<br/>
<br/>

##### Will an atom with 27 protons, 32 neutrons, and 27 electrons be electrically neutral? 

<br/>
<br/>

##### Will an Na atom with 10 electrons be electrically neutral?

<br/>
<br/>

### Periodicity

<img src="./assets/image-20240803172830897.png" alt="image-20240803172830897" style="zoom:50%;" />

##### Metals

- Solids at room temperature, except Hg.
- Reflective surface.
- Conduct heat.
- Conduct electricity.
- Malleable..
- Ductile.
- Lose electrons and form cations in reactions.
- About 75% of the elements are metals.
- Lower left on the table.

##### Nonmetals

- Found in all 3 states at standard temperature and pressure.
- Poor conductors of heat.
- Poor conductors of electricity.
- Solids are brittle.
- Gain electrons in reactions to become anions.
- Upper right on the table.
  - Except H.

##### Metalloids

- Show some properties of metals and some of nonmetals.
- Also known as semiconductors.

<img src="./assets/image-20240803175958369.png" alt="image-20240803175958369" style="zoom:50%;" />

##### Classify Each Element as Metal, Nonmetal, or Metalloid.

- Xenon, Xe
- Tungsten, W
- Bromine, Br
- Arsenic, As
- Cerium, Ce

### Groups

<img src="./assets/image-20240803174438496.png" alt="image-20240803174438496" style="zoom: 67%;" />

<img src="./assets/image-20240803174725666.png" alt="image-20240803174725666" style="zoom: 67%;" />

## Charge and Ions

- In a chemical change, the number of protons in the nucleus of the atom doesn’t change.
  - Radioactive and nuclear changes are an exception
- Atoms in a compound are often electrically charged, these are called ions.
- Atoms acquire a charge by gaining or losing electrons.
  - Never protons!

$$
\large
\text{Ionic Charge} = \# \text{ protons} - \# \text{ electrons}
$$

$$
\large
q = n_{p^+} - n_{e^-}
$$

- Ions with a positive charge are called **cations**.
  - Metals
  - More protons than electrons.
  - Form by losing electrons.

- Ions with a negative charge are called **anions**.
  - Nonmetals
  - More electrons than protons.
  - Form by gaining electrons.

- Chemically, ions are much different than the neutral atoms.
- Anions are named by changing the ending of the name to –ide.

$$
\ce{
Fluorine \hspace{5mm} F + 1 e^- -> F- \hspace{5mm} Fluoride Ion
\\
Oxygen \hspace{5mm} O + 2e^- -> O^2- \hspace{5mm} Oxide Ion
}
$$

- Cations are named the same as the metal.

$$
\ce{
Sodium \hspace{5mm} Na -> Na+ + 1e^- \hspace{5mm} Sodium Ion
\\
Calcium \hspace{5mm} Ca -> Ca^{2+} + 2e^- \hspace{5mm} Calcium Ion
}
$$

- The charge on a ion can often be determined from the group number on the periodic table.

<img src="./assets/image-20240803182027336.png" alt="image-20240803182027336" style="zoom:50%;" />

##### Fill in the Table

|  Ion   | p^+^ | e^-^ |
| :----: | :--: | :--: |
| Cl^1-^ |      |      |
| K^1+^  |      |      |
| S^2-^  |      |      |
| Sr^2+^ |      |      |
| Ca^2+^ |      |      |



### Valence Electrons and Ion Charge

- The highest energy electrons in an atom are called the valence electrons.
- Metals form cations by losing their valence electrons to get the same number of electrons as the previous noble gas.
  - Main group metals.
  - Li^+^ has the same number of electrons as He
  - Al^3+^ has the same number of electrons as Ne
- Nonmetals form anions by gaining electrons to have the same number of electrons as the next noble gas.
  - Cl^-^ has the same number of electrons as Ar
  - Se^2-^ has the same number of electrons as Kr



## Isotopes

- Soddy discovered that the same element could have atoms with different masses, which he called isotopes.
  - There are two isotopes of chlorine found in nature, one that has a mass of about 35 amu and another that weighs about 37 amu.
- The **atomic mass** is a *weighted average* of the weights of all the naturally occurring atoms.
  - The atomic mass of chlorine is 35.45 amu.
- The **exact mass** is the mass of a specific isotope
- All isotopes of an element are chemically identical.
- All isotopes of an element have the same number of protons and a different number of neutrons.
  - Isotopes of an element have different masses.
- Isotopes are identified by their **mass numbers**.

$$
\text{Mass Number} = \# \text{ Protons} + \# \text{ Neutrons}
$$

  - Unlike the atomic mass or the exact mass, *mass number* is always a whole number
    Isotopes

<img src="./assets/image-20240803220604142.png" alt="image-20240803220604142" style="zoom: 80%;" />

<img src="./assets/image-20240803220714842.png" alt="image-20240803220714842" style="zoom: 67%;" />

<img src="./assets/image-20240803220754394.png" alt="image-20240803220754394" style="zoom: 80%;" />

<img src="./assets/image-20240803220827752.png" alt="image-20240803220827752" style="zoom: 80%;" />

- Each isotope has a **natural abundance** based on the relative amount of the isotope found in nature
  - Natural abundance is the probability of finding a particular isotope in a sample of an element

  - Cl-35 makes up about 75% of chlorine atoms in nature, and Cl-37 makes up the remaining 25%.

<img src="./assets/image-20240803220239808.png" alt="image-20240803220239808" style="zoom: 67%;" />



##### What is the atomic mass of Neon?

| Isotope | Atomic Mass | Natural Abundance (%) |
| :-----: | :---------: | :-------------------: |
| ^20^Ne  |   19.992    |         90.48         |
| ^21^Ne  |   20.994    |         0.27          |
| ^22^Ne  |   21.991    |         9.25          |

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

##### How Many Protons and Neutrons Are in an Atom of $\ce{^52_24Cr}$?

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

##### Gallium has two naturally occurring isotopes. Ga-69 with Mass 68.9256 Amu and Abundance of 60.11% and Ga-71 with Mass 70.9247 Amu and Abundance of 39.89%.  Calculate the Atomic Mass of Gallium.

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

##### If Copper Is 69.17% Cu-63 with a Mass of 62.9396 Amu and the Rest Cu-65 with a Mass of 64.9278 Amu, Find Copper’s Atomic Mass.

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

<div style="page-break-after: always; visibility: hidden"> 
\pagebreak 
</div>
# Chapter 4 Quiz




1.	The atom is the fundamental building block of matter. (1 Point)
				True				False
2.	A molecule is the smallest identifiable unit of a compound. (1 Point)
				True				False
3.	You can continually divide matter into smaller and smaller pieces without ever coming to an end.          	(1 Point)
				True				False
4.	The gold foil experiment proved that atoms contain a dense nucleus. (1 Point)
				True				False
5.	Protons and neutrons each have a mass of approximately 1 amu. (1 Point)
				True				False
6.	A positive charge attracts negative charges and repels other positive charges. (1 Point)
				True				False
7.	If two atoms each contain different numbers of neutrons, the atoms must be from different elements.       	(1 Point)
				True				False
8.	In the modern periodic table, elements are listed in order of increasing atomic number rather than increasing relative mass. (1 Point)
				True				False
9.	Metals are located on the upper-right side of the periodic table. (1 Point)
				True				False
10.	A cation forms when an atom losses an electron. (1 Point)
				True				False
11.	The exact mass of individual atoms of an element may vary. (1 Point)
				True				False

13.	Which statement below accurately describes the contributions of Thomson?  (2 Points)

A) discovered the existence of protons
B) created the modern periodic table
C) proposed the atom contained a dense nucleus
D) discovered the existence of electrons
E) none of the above

14.	Which statement reflects the results of Rutherford's gold foil experiments?  (2 Points)

A) Almost all of the alpha particles were deflected back in the direction from which they came.
B) Almost all of the alpha particles sputtered gold atoms off of the surface of the foil.
C) Almost all of the alpha particles were deflected while passing through the foil.
D) Almost all of the alpha particles passed directly through the foil.
E) none of the above

15.	An atom containing 12 protons, 10 neutrons, and 12 electrons  (2 Points)

A) is charge-neutral.
B) is an ion.
C) is an oxygen atom.
D) cannot exist.
E) none of the above

16.	Which of the following elements has an atomic number of 6?  (2 Points)

A) H
B) C
C) He
D) Be
E) none of the above

17.	Which of the following elements has 16 protons?  (2 Points)

A) C
B) Zn
C) Mg
D) O
E) none of the above

18.	What is the atomic symbol for gold?  (2 Points)

A) S
B) Ag
C) Au
D) Si
E) none of the above

19.	What is the atomic symbol for silicon?  (2 Points)

A) Sn
B) Ti
C) Tn
D) Si
E) none of the above

20.	Ne is a member of which family?  (2 Points)

A) noble gases
B) halogens
C) alkaline earth metals 
D) alkali metals
E) none of the above

21.	Identify the element that is a nonmetal, a gas, and has an elemental symbol that starts with the letter "A."  (2 Points)

A) Ac
B) Ar
C) Au
D) Al
E) none of the above

22.	Ions are formed when atoms  (2 Points)

A) gain or lose protons.
B) gain or lose electrons.
C) gain or lose neutrons.
D) Each of these results in ion formation.
E) None of these results in ion formation.

23.	What is the correct formula for sodium ion with 10 electrons?  (2 Points)

A) S^+^
B) K+
C) Na^+^
D) So^-^
E) none of the above

24.	How many electrons are in Br^-^ ?  (2 Points)

A) 4
B) 7
C) 34
D) 36
E) none of the above

25.	How many electrons does O^2-^ have?  (2 Points)

A) 2
B) 16
C) 10
D) 8
E) none of the above

26.	How many protons and neutrons are in Cl-37?  (2 Points)

A) 20 protons, 17 neutrons
B) 17 protons, 37 neutrons
C) 17 protons, 20 neutrons
D) 37 protons, 17 neutrons
E) none of the above

27.	A specific isotope of an element is known to have 35 protons and 45 neutrons. Which symbol would properly represent this isotope?  (2 Points)

A) Br-80
B) Hg-45
C) Hg-35
D) Br-45
E) none of the above

<div style="page-break-after: always; visibility: hidden"> 
\pagebreak 
</div>

# Chapter 5

## Molecules and Compounds

- Compounds have chemical and physical properties distinct from their component elements.
  - Salt
    - Sodium—shiny, reactive, poisonous.
    - Chlorine—pale yellow gas, reactive, poisonous.
    - Sodium chloride—table salt.
  - Sugar
    - Carbon—pencil or diamonds.
    - Hydrogen—flammable gas.
    - Oxygen—a gas in air.

### Law of Constant Composition

- All samples of a pure substance contain the same elements in the same percentages (ratios).
  - The smallest piece of a compound is called a molecule.
  - Every molecule of a compound has the same number and type of atoms.
  - Since all the molecules of a compound are identical, every sample will have the same 
  ratio of the elements.
  - Since all molecules of a compound are identical, every sample of the compound will have the same properties.
- Mixtures have variable composition.

<img src="./assets/image-20240804132356737.png" alt="image-20240804132356737" style="zoom: 33%;" />

- If we decompose water by electrolysis, we get 16.0 grams of oxygen to every 2.00 grams of hydrogen. 

<img src="https://2012books.lardbucket.org/books/beginning-chemistry/section_18/9679947ab90398b8826bea46aa85c1c6.jpg" alt="https://2012books.lardbucket.org/books/beginning-chemistry/section_18/9679947ab90398b8826bea46aa85c1c6.jpg" style="zoom: 15%;" />

- Water has a constant mass ratio of oxygen to hydrogen of 8.0

$$
\text{Mass Ratio} = \frac{m_O}{m_H} = \frac{16.0 \text{ g}}{2.0 \text{ g}} = 8.0
$$

##### Show that Two Samples of Carbon Dioxide Are Consistent with the Law of Constant Composition. 

| Sample | Carbon (g) | Oxygen (g) |
| :----: | :--------: | :--------: |
|   1    |    1.8     |    4.8     |
|   2    |    6.4     |    17.1    |

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

##### Show that Hematite Has Constant Composition if a 10.0 g Sample Has 7.2 g Fe and the Rest Is Oxygen; and a Second Sample Has 18.1 g Fe and 6.91 g O.

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

### Polyatomics

**Certain groups of atoms are bonded together to form what is called a polyatomic ion that acts as a single unit**

![image-20240804141730110](./assets/image-20240804141730110.png)


### Molecular Formulas Describe Compounds

- We describe the compound by describing the number and type of each atom in the simplest unit of the compound.
  - Molecules or ions.
- Each element is represented by its letter symbol.
- The number of atoms of each element is written to the right of the element as a subscript.
  - If there is only one atom, the 1 subscript is not written.

<img src="./assets/image-20240804141830611.png" alt="image-20240804141830611" style="zoom: 67%;" />

- **Polyatomic groups** are placed in parentheses. 
  - If more than one.

<img src="./assets/image-20240804142032701.png" alt="image-20240804142032701" style="zoom:67%;" />

- Order of Elements in a Formula
  - Metals are written first.
  - Nonmetals are written in order
- There are occasional exceptions for historical or informational reasons.
  - H~2~O, but NaOH . 

<img src="./assets/image-20240804141933657.png" alt="image-20240804141933657" style="zoom:67%;" />

##### Hematite is composed of four oxide ions for every three iron ions. What is the chemical formula for hematite?

<br/>
<br/>
<br/>
<br/>

##### Acetone molecules contain six hydrogen atoms, three carbon atoms, and one oxygen atom. What is it's chemical formula? 

<br/>
<br/>
<br/>
<br/>

##### Determine the Total Number of Atoms or Ions in One Formula Unit of Each of the Following.

Mg(C~2~H~3~O~2~)~2~

Hg~6~(PO~4~)~2~

(NH~4~)~3~PO~4~

### Structural Formulas

- **Structural formulas** use lines to represent chemical bonds
- Unlike **molecular formulas**, structural formulas demonstrate how the atoms in a molecular are connected.

<img src="./assets/image-20240804143410969.png" alt="image-20240804143410969" style="zoom: 67%;" />

### Empirical Formulas

- An **empirical formula** is the simplest whole-number ratio of atoms of each
element in a compound.

| Molecular Formula | Empirical Formula |
| :---------------: | :---------------: |
|     C~6~H~6~      |        CH         |
|   C~2~O~4~H~2~    |      CO~2~H       |
|   Al(NO~3~)~3~    |   Al(NO~3~)~3~    |



## Classifying Materials

<img src="./assets/image-20240804144133125.png" alt="image-20240804144133125" style="zoom: 50%;" />

### Atomic Elements

- Atomic elements have single atoms as their basic units. 
  - Most elements fall into this category

### Molecular Elements

- Molecular elements do not normally exist in nature with single atoms as
  their basic units. 
  - Smallest unit is a molecule.
  - Two or more nonmetals.
  - These elements usually exist as diatomic molecules.

<img src="./assets/image-20240804144825453.png" alt="image-20240804144825453" style="zoom: 80%;" />

### Molecular Compounds

- **Molecular compounds** are composed of two or more nonmetals.
  - The basic units are molecules.
  - For instance, H~2~O, CO~2~, C~3~H~6~O

<img src="./assets/image-20240804181747198.png" alt="image-20240804181747198" style="zoom:33%;" />

### Ionic Compounds

- **Ionic compounds** are composed of one or more cations (+) paired with one or more
anions (-)
- Usually metals + nonmetals.
- The basic unit of ionic compounds is the **formula unit**.
- Smallest electrically neutral collection of ions


- 
-   No real individual units, instead have a 3-dimensional array of cations and anions.

<img src="./assets/image-20240804230611827.png" alt="image-20240804230611827" style="zoom:50%;" />

##### Classify Each of the Following as Either an Atomic Element, Molecular Element, Molecular Compound, or Ionic Compound. 

Aluminum, Al.

Aluminum chloride, AlCl~3~.

Chlorine, Cl~2~.

Acetone, C~3~H~6~O.

Carbon monoxide, CO.

Cobalt, Co.

### Writing Ionic Formulas

**Ionic compounds are electrically neutral therefore there must be an equal number of positive and negative charges**

$$
\text{Total Positive Charge} + \text{Total Negative Charge} = 0
$$

We know sodium (Na) tends to form a cation with a 1+ charge 

$$
\ce{
Na -> Na+ + e-
}
$$

We also know that sulfur tends to form an anion with a 2- charge

$$
\ce{
S + 2e- -> S^{2-}
}
$$

To achieve an electrically neutral ionic compound, we will need two sodium ions for each sulfide ion.

$$
\ce{
2Na+ + S^{2-} -> Na2S 
}
$$

#### Rules

1. Write the symbol for the metal cation and its charge.
1. Write the symbol for the nonmetal anion and its charge.
1. Charge (without sign) becomes subscript for the other ion.
1. Reduce subscripts to smallest whole-number ratio.
1. Check that the sum of the charges of the cation cancels the sum of the anions.

<img src="./assets/image-20240805155606069.png" alt="image-20240805155606069" style="zoom:33%;" />

##### What Are the Formulas for Compounds Made from the Following Ions?

- Potassium ion with a nitride ion

- Calcium ion with a bromide ion

- Aluminum ion with a sulfide ion

- Magnesium ion with sulfite ion

- Copper ion with a chloride ion

- Ammonium ion with nitrate ion

## Naming

### Common Names

**Some compounds have common names mostly due to historic significance**

- H~2~O = Water, steam, ice.
- NH~3~ = Ammonia.
- CH~4~ = Methane.
- NaCl = Table salt.
- C~12~H~22~O~11~ = Table sugar.

### Ionic compounds.
<img src="./assets/image-20240805163740167.png" alt="image-20240805163740167" style="zoom:50%;" />

<img src="./assets/image-20240805163939396.png" alt="image-20240805163939396" style="zoom:50%;" />

<img src="./assets/image-20240805164019795.png" alt="image-20240805164019795" style="zoom:50%;" />

<img src="./assets/image-20240805164316237.png" alt="image-20240805164316237" style="zoom: 55%;" />

#### Binary Ionic

##### Type 1

<img src="./assets/image-20240805164215350.png" alt="image-20240805164215350" style="zoom: 67%;" />

##### Type 2

<img src="./assets/image-20240805164425314.png" alt="image-20240805164425314" style="zoom:67%;" />

**When the anion is a polyatomic, the suffix is not changed**

##### Write the name for the following ionic compounds

- KCl
- Na~2~O
- CaBr~2~
- CoF~2~
- CuCl
- Mg(NO~2~)~2~
- Li~2~SO~4~
- (NH~4~)~3~PO~4~
- Al~2~(SO~3~)~3~

Write the formula for the following ionic compounds

- Copper(II) Bromide
- Iron(III) fluoride
- Calcium Sulfate
- Lithium Phosphate
- Sodium Oxide

### Molecular compounds.


- 2 or more nonmetals

<img src="./assets/image-20240805165402994.png" alt="image-20240805165402994" style="zoom:67%;" />

<img src="./assets/image-20240805165428184.png" alt="image-20240805165428184" style="zoom:67%;" />


### Acids

- Formula starts with hydrogen (H).
  - H~2~SO~4~, HBr
- Sour taste
- Though acids are molecular, they behave as ionic when dissolved in water.

$$
\ce{
HA -> H+ + A-
}
$$

- May be binary or oxyacid.

<img src="./assets/image-20240805213718131.png" alt="image-20240805213718131" style="zoom:50%;" />

<img src="./assets/image-20240805213754630.png" alt="image-20240805213754630" style="zoom:50%;" />
$$
\ce{
HCl -> H+ + Cl-
}
$$

$$
\ce{
HNO3 -> H+ + NO3-
}
$$

#### Binary Acids

- Binary acids have H+1 cation and nonmetal anion

<img src="./assets/image-20240805213819156.png" alt="image-20240805213819156" style="zoom:67%;" />

##### Name the following binary acids

- HF
- HBr
- HI
- H~2~S

#### Oxyacids

- Oxyacids have H^+1^ cation and polyatomic anion.

<img src="./assets/image-20240805214222544.png" alt="image-20240805214222544" style="zoom: 67%;" />

- The names of acids containing oxyanions ending with -*ite*

<img src="./assets/image-20240805214322780.png" alt="image-20240805214322780" style="zoom: 67%;" />

- The names of acids containing oxyanions ending with -*ate*

<img src="./assets/image-20240805214454179.png" alt="image-20240805214454179" style="zoom:67%;" />



##### Name the following oxyacids

- H~2~SO~4~
- HNO~3~
- HNO~2~
- H~3~PO~4~



##### Write the chemical equation for the following acid

- Sulfurous Acid
- Hydrochloric Acid
- Nitrous Acid
- Chromic Acid



## Formula Mass

- The mass of an individual molecule or formula unit.
  - Also known as molecular mass or molecular weight.
  - Sum of the masses of the atoms in a single molecule or formula unit.

$$
\text{H}_2\text{O}
$$

$$
2 \text{ H} \hspace{5mm} 2 (1.008 \text{ amu}) = 2.016 \text{ amu}
$$
$$
\text{O} \hspace{5mm} 15.99 \text{ amu}
$$

$$
2.016 \text{ amu} + 15.99 \text{ amu} = 18.01 \text{ amu}
$$

##### Calculate the Formula Mass for the following compounds

$\ce{Al2(SO4)3}$





$\ce{C6H8O2}$





$\ce{Ba(NO3)2}$



<div style="page-break-after: always; visibility: hidden"> 
\pagebreak 
</div>

# Chapter 6

## Chemical Composition

**Why Is Knowledge of  Composition Important?**

- Everything in nature is either chemically or physically combined with other substances.
  - To know the amount of a specific element in a sample, you need to know what fraction of the sample it is.
- Some Applications:
  - The amount of sodium in sodium chloride for diet.
  - The amount of iron in iron ore for steel production.
  - The amount of hydrogen in water for hydrogen fuel.
  - The amount of chlorine in freon to estimate ozone depletion.

<img src="./assets/image-20240806135132520.png" alt="image-20240806135132520" style="zoom:50%;" />

### The Mole

**Counting Nails by the Pound**

- I want to buy a certain number of nails for a project, but the hardware store sells nails by the pound.
  - How do I know how many nails I am buying when I buy a pound of nails?

##### A hardware store customer buys 2.60 pounds of nails.  A dozen nails has a mass of 0.150 pounds.  How many nails did the customer buy?

1 dozen nails = 0.150 lbs.
12 nails = 1 dozen nails

##### A marble company produces three kinds of marbles. What is the average mass of the marbles? The company sells the marbles in bags of sixteen. What is the average mass of a bag of marbles in pounds?

| Color  | Mass (oz) | Daily Production |
| ------ | --------- | ---------------- |
| Red    | 2.1       | 1500             |
| Blue   | 2.4       | 1300             |
| Orange | 1.9       | 1400             |




- If we know the average mass of a particular number of atoms, we can use this information to convert the mass of an element sample to the number of atoms in the sample.
- We can choose a clever quantity to make the units work out convienently 
  - The quantity of atoms we will use is 6.022 x 10^23^ and we call this a **mole**.
  - 1 mole = 6.022 x 10^23^ things.
  - Like 1 dozen = 12 things or 1 bag = 16 things
  - Avogadro’s number.
- The mole is based on careful measurements made on the carbon-12 isotope
  - Mole = Number of things equal to the number of atoms in 12 g of C-12. 
  - 1 atom of C-12 weighs exactly 12 amu.
  - 1 mole of C-12 weighs exactly 12 g.


##### A Silver Ring Contains 1.1 x 10^22^ Silver Atoms.  How Many Moles of Silver Are in the Ring?

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

##### Calculate the Number of Atoms in 2.45 Mol of Copper.

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

### Moles and Mass

- The mass of one mole of atoms is called the molar mass.
  - The molar mass ($\frac{\text{g}}{\text{mol}}$) of an element is numerically equal to the element’s atomic mass ($\frac{\text{amu}}{\text{atom}}$).
  - The molar mass ($\frac{\text{g}}{\text{mol}}$) of a compound is numerically equal to the compounds formula mass ($\frac{\text{amu}}{\text{molecule}}$). 

##### Calculate the Moles of Sulfur  in 57.8 G of Sulfur.

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

##### Calculate the Mass of Carbon 2.21 ⨯ 10^-3^ moles of Pencil Lead.

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

##### Calculate the Mass of Carbon 2.21 ⨯ 10^-3^ moles of Pencil Lead.

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

### Mass and Atoms

- Using the number of moles allows us to convert between the mass of a sample (a measurable quantity) and the number of atoms or molecules.

<img src="./assets/NMolesMass-1722974061669-2.png" alt="NMolesMass" style="zoom: 80%;" />


##### How Many Aluminum Atoms Are in a Can Weighing 16.2 g?

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

##### What is the mass of 2.94 ⨉ 10^22^ atoms of Cu?

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

##### What is the mass of 2.94 ⨉ 10^22^ atoms of Cu?

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

##### Calculate the Mass of 1.75 Mol of H~2~O.

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

##### How Many Moles Are in 50.0 g of PbO~2~?

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

##### How Many Formula Units Are in 50.0 g of PbO~2~?

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

##### What Is the Mass of 4.78 x 10^24^ NO~2~ Molecules?

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>


### Chemical Formulas as Conversion Factors

1 spider ≡ 8 legs.
1 chair ≡ 4 legs.
1 H~2~O molecule ≡ 2 H atoms  ≡ 1 O atom.

<img src="./assets/image-20240806160232739.png" alt="image-20240806160232739" style="zoom: 25%;" />

- If we know how many parts are in the whole unit, by counting the number of whole units, we can effectively count the parts.
- Since we count atoms and molecules in mole units, we can find the number of moles of a constituent element if we know the number of moles of the compound.

$$
\ce{
16 mole H2O \left( \frac{2 mole H}{1 mole H2O} \right) = 32 mole H
}
$$

##### Calculate the Moles of Oxygen  in 1.7 Moles of CaCO~3~.

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

##### Find the Mass of Carbon in 55.4 g C~10~H~14~O.

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

##### Find the Mass of Sodium in 6.2 g of NaCl

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

### Percent Composition

- To determine the mass of a component from the mass of a compound you must go through the molar ratios.
- However, the molar ratios and molar masses of the components for a specific compound is always the same.
  - We can be clever to make our math a little simpler

##### Find the Mass of Sodium in 6.2 g of NaCl using the percent composition.

$$
\ce{
6.2 g NaCl \left(\frac{1 mole NaCl}{58.44 g NaCl}\right) \left(\frac{1 mole Na}{1 mole NaCl}\right) \left(\frac{22.99 g Na}{1 mole Na}\right)
}
$$

$$
\ce{
= 6.2 g NaCl \left(\frac{22.9 g Na}{58.44 g NaCl}\right)
}
$$

$$
\ce{
= 6.2 g NaCl (0.392) = 2.43 g Na
}
$$

$$
\ce{
Percent Composition Sodium in Sodium Chloride = 0.392 \times 100 \% = 39.2 \%
}
$$

- The percent composition tells you the mass of a constituent element in 100 g of the compound.

##### Find the Mass Percent of Cl in C~2~Cl~4~F~2~.

#### The experimental mass analysis of the compound.

- The percent composition of a sample can be measured directly through experimentation
  - The percentages may not always total to 100% due to rounding.

- The percent composition data can be used to find the empirical formula of the compound 
  - The simplest, whole-number ratio of atoms in a molecule.
  - The molecular formula is a multiple of the empirical formula.

#### Rules for finding an Empirical Formula from Percent Composition

1.	Convert the percentages to grams.
	a.	Skip if already grams.
2.	Convert grams to moles.
	a.	Use molar mass of each element.
3.	Write a pseudoformula using moles as subscripts.
4.	Divide all by smallest number of moles.
5.	Multiply all mole ratios by number to make all whole numbers, if necessary.
    a.	If ratio 0.5, multiply all by 2; if ratio 0.33 or 0.67, multiply all by 3, etc. 
    b.	Skip if already whole numbers after Step 4.

##### A laboratory analysis of aspirin determined the following mass percent composition.  Find the empirical formula.

| Element | Percent Composition |
| :-----: | :-----------------: |
|    C    |       60.00 %       |
|    H    |       4.48 %        |
|    O    |       35.53 %       |

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

##### A 3.24-g sample of titanium reacts with oxygen to form 5.40 g of the metal oxide. What is the formula of the oxide? 

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

##### Determine the Empirical Formula of Stannous Fluoride, which Contains 75.7% tin and the Rest Fluorine.

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

#### Determine the Empirical Formula of Hematite, which Contains 72.4% Fe and the Rest Oxygen.

### Molecular Formulas From Empirical Formulas

- The molecular formula is a multiple of the empirical formula.
- To determine the molecular formula, you need to know the empirical formula and the molar mass of the compound.

##### Determine the Molecular Formula of Cadinene if it has a Molar Mass of 204 g/mol and an Empirical Formula of C~5~H~8~. 

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

##### Benzopyrene has a Molar Mass of 252 g/mol and an Empirical Formula of C~5~H~3~.  What is its Molecular Formula?

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

##### Determine the Molecular Formula of Nicotine, which has a Molar Mass of 162 g/mol and is 74.0% C, 8.7% H, and the Rest N.

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

<div style="page-break-after: always; visibility: hidden"> 
\pagebreak 
</div>

# Chapter 6 Quiz



1.	Volume is used as a method of counting atoms. (1 Point)

​				True				False

2.	The numerical value of the mole is defined as being equal to the number of atoms in exactly 1 grams of pure hydrogen-1. (1 Point)

​				True				False

3.	 Avogadro's Number is 6.022 × 10^23^ (1 Point)

​				True				False

4.	The lighter the atom, the more mass in one mole of that atom. (1 Point)

​				True				False

5.	One mole of helium has more atoms in it than one mole of neon. (1 Point)

​				True				False

6.	One mole of zinc contains 65.39 zinc atoms. (1 Point)

​				True				False

7.	 One mole of CH~4~ has more atoms in it than one mole of Na. (1 Point)

​				True				False

8.	A molecular formula gives the specific number of each type of atom in a molecule. (1 Point)

​				True				False

9.	An empirical formula gives the smallest whole number ratio of each type of atom in a molecule. (1 Point)

​				True				False

10.	How many atoms are in 6.72 moles of scandium? (2 Points)


A) 6.02 × 10^23^

B) 1.12 × 10^-23^

C) 4.05 × 10^24^

D) 1.12 × 10^23^

E) none of the above




11.	How many moles of Co are in 2.38 × 10^25^ Co atoms? (2 Points)


A) 39.5

B) 1.43 × 10^49^

C) 3.95 × 10^24^

D) 79.0

E) none of the above




12.	One mole of beryllium has a mass of ________ g. (2 Points)


A) 208.98

B) 10.811

C) 9.012

D) 4.00

E) none of the above




13.	What is the mass of 0.605 moles of chlorine gas (Cl~2~)? (2 Points)


A) 21.45 g

B) 42.90 g

C) 117.2 g

D) 58.6 g

E) none of the above



14.	You have 10.0 g each of Na, C, Pb, Cu and Ne. Which contains the largest number of moles? (2 Points)


A) Na

B) C

C) Pb

D) Cu

E) Ne




15.	How many moles of silver are contained in 0.926 kg of silver? (2 Points)


A) 1.54 ⨯ 10^-21^

B) 8.58

C) 5.58 ⨯ 10^26^

D) 8.58 ⨯ 10^-3^

E) none of the above




16.	How many atoms are in 15.6 grams of silicon? (2 Points)


A) 2.64 × 10^26^

B) 3.34 × 10^23^

C) 0.555

D) 438

E) none of the above




17.	What is the mass of 3.09 × 10^24^ molecules of C~2~H~2~ in grams? (2 Points)

A) 5.07 g

B) 9.91 g

C) 133 g

D) 0.160 g

E) none of the above




18.	If 3.011 × 10^23^ molecules have a mass of 20.04 grams, what is the molar mass of this substance?  (2 Points)


A) 40.08 g/mol

B) 10.02 g/mol

C) 20.04 g/mol

D) 6.658 × 10^-23^ g/mol

E) none of the above



19.	Calculate the molar mass of ammonium phosphate, (NH~4~)~3~PO~4~. (2 Points)


A)  114.12 g/mol

B) 113.01 g/mol

C) 131.05 g/mol

D) 149.09 g/mol

E) none of the above




21. A 42.7 gram sample of potassium nitrate (KNO~3~) contains how many grams of potassium? (2 Points)


A) 39.1 g

B) 16.5 g

C) 21.4 g

D) 8.54 g

E) none of the above




22.	Bauxite is an ore that contains the element aluminum. If you obtained 589 grams of aluminum from an ore sample that initially weighed 2.03 kilograms, what is the mass percent of aluminum in this bauxite ore? (2 Points)

A) 71.0 %

B) 3.44 %

C) 29.0 %

D) 96.6 %

E) none of the above




23.	What is the mass percent of chlorine in hydrochloric acid? (2 Points)

A) 2.8 %

B) 35.5 %

C) 97.2 %

D) 70.1 %

E) none of the above


<div style="page-break-after: always; visibility: hidden"> 
\pagebreak 
</div>


# Chapter 7


## Chemical Reactions


- Reactions involve chemical changes in matter resulting in new substances.
- Chemical bonds are broken and formed to produce new molecules.
  - Molecules can combine to make bigger molecules.
  - Molecules can decompose into smaller molecules or atoms.
  - Atoms can be exchanged between molecules or transferred to another molecule.
  - Atoms can gain or lose electrons, turning them into ions.
    - Or changing the charge on ions that are already there.

#### Evidence of Chemical Reactions

- Look for evidence of a new substance.
- Permanent Visual clues.
  - Color change. 
  - Precipitate formation. 
    - Solid that forms when liquid solutions are mixed.
  - Gas bubbles. 
  - Large energy changes.
    - Large Temperature Changes
    - Emission of light.
- Other clues.
  - New odor. 
  - Whooshing sound from a tube. 
  - Permanent new phase.
  **Evidence is Not Proof!**

In order to be absolutely sure that a chemical reaction has taken place, you need to go down to the molecular level and analyze the structures of the molecules at the beginning and end. 

##### Decide Whether Each of the Following Involve a Chemical Reaction.

- Photosynthesis
- Heating sugar until it turns black
- Heating ice until it becomes a liquid
- Digestion of food
- Dissolving sugar in water
- Burning paper


### Chemical Equations

- Short-hand way of describing a reaction.
- Provides lots of information about the reaction.
  - Formulas of reactants and products.
  - Phases of reactants and products.
  - Relative numbers of reactant and product molecules that are required.
  - Can be used to determine masses of reactants used and products that can be made.

### Symbols used in Chemical Equations

|  Phase  |  Symbol  |
| :-----: | :------: |
|   gas   | ( *g* )  |
| liquid  | ( *l* )  |
|  solid  | ( *s* )  |
| aqueous | ( *aq* ) |

|   Energy   |  Symbol  |
| :--------: | :------: |
|    heat    | $\Delta$ |
|   light    |  $h\nu$  |
| mechanical | $shock$  |
| electrical |  $elec$  |

| Symbol     | Meaning                                                      |
| ---------- | ------------------------------------------------------------ |
| $\ce{->}$  | Indicates the direction of the reaction. From the **reactants** on the left to the **products** on the right. |
| $\ce{<=>}$ | Indicates the reaction is capable of running in both directions (*reversible*) |



#### The Combustion of Methane

<img src="./assets/image-20240806220342637.png" alt="image-20240806220342637" style="zoom: 33%;" />

**Methane gas burns to produce carbon dioxide gas and gaseous water.**

$$
\ce{
CH4($g$) + O2($g$) -> CO2($g$) + H2O($g$)
}
$$


##### Balancing the Reaction

- As written there is not the same number of atoms on each side
  - This violates the *Law of Conservation of Mass*
  - O and H do not *balance*.



<img src="./assets/image-20240806220922262.png" alt="image-20240806220922262" style="zoom:50%;" />

<img src="./assets/image-20240806220952206.png" alt="image-20240806220952206" style="zoom:50%;" />

- To correct this we have to adjust the **stoichiometric coefficients** 
  - These indicate the number of each molecule participate in the reaction

<img src="./assets/image-20240806221132969.png" alt="image-20240806221132969" style="zoom:50%;" />



- This equation is balanced, meaning that there are equal numbers of atoms of each element on the reactant and product sides.
- To obtain the number of atoms of an element, multiply the subscript by the coefficient.

<img src="./assets/image-20240806221348788.png" alt="image-20240806221348788" style="zoom:50%;" />


### Rules for Writing Balanced Chemical Equations

1. Write a skeletal equation by writing the formula of each reactant and product.
2. Count the number of atoms of each element on each side of the equation.
     - Polyatomic ions may often be counted as if they are one “element”.
3. Pick an element to balance.

     - If an element is found in only one compound on both sides, balance it first.
     - Metals before nonmetals.
     - Leave free elements until last. 
4. Find the least common multiple (LCM) of the number of atoms on each side.
5. Multiply each count by a factor to make it equal to the LCM.
6. Use this factor as a coefficient in the equation.

     - If there is already a coefficient there, multiply it by the factor.
     - It must go in front of entire molecules, not between atoms within a molecule.
7. Recount and repeat until balanced. 

##### When magnesium metal burns in air, it produces a white, powdery compound magnesium oxide.

<img src="./assets/image-20240806223239505.png" alt="image-20240806223239505" style="zoom: 80%;" />

1. Write a skeletal equation

$$
\ce{
Mg($s$) + O2($g$) -> MgO($s$)
}
$$

2. Count the number of atoms on each side.

$$
\ce{
1 <- Mg -> 1
}
$$
$$
\ce{
2 <- O -> 1
}
$$

3. Pick an element to balance.

Magnesium is already balanced so oxygen is the obvious choice.

4. Find the LCM of both sides 

The least common multiple of 2 and 1 is 2.

5. Multiply each side by factor so it equals LCM.
6. Use factors as coefficients in front of the compound containing the element.

$$
\ce{
Mg($s$) + O2($g$) -> 2MgO($s$)
}
$$
$$
\ce{
1 <- Mg -> 1 \times 2
}
$$
$$
\ce{
2 <- O -> 1 \times 2
}
$$

7. Recount
$$
\ce{
1 <- Mg -> 2
}
$$
$$
\ce{
2 <- O -> 2
}
$$

8. and Repeat—attacking an unbalanced element.

$$
\ce{
2 Mg($s$) + O2($g$) -> 2 MgO($s$)
}
$$
$$
\ce{
2 \times 1 <- Mg -> 2 
}
$$
$$
\ce{
2 <- O -> 2
}
$$

9. Recount—Mg not balanced now

$$
\ce{
2 <- Mg -> 2 
}
$$
$$
\ce{
2 <- O -> 2
}
$$





##### Under appropriate conditions at 1000°C, ammonia gas reacts with oxygen gas to produce gaseous nitrogen monoxide and steam. Write a balanced chemical equation for this reaction.

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

##### When aluminum metal reacts with oxygen in the air, it produces a white, powdery compound called aluminum oxide. Write a balanced chemical equation for this reaction.

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

##### Acetic acid reacts with the metal aluminum to make aqueous aluminum acetate and gaseous hydrogen. Write a balanced chemical equation for this reaction.

$$
\ce{
Al($s$) + HC2H3O2($aq$) ->  Al(C2H3O2)3($aq$) + H2($g$)
}
$$

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>
<br/>
<br/>
<br/>



##### Write a balanced chemical for the combustion of ethanol (C~2~H~5~OH).

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>
<br/>
<br/>
<br/>


### Aqueous Solutions

- Many times, the chemicals we are reacting together are dissolved in water.
  - Mixtures of a chemical dissolved in water are called **aqueous solutions**.
- Dissolving the chemicals in water helps them to react together faster.
  - The water separates the chemicals into individual molecules or ions.
  - The separate, free-floating particles come in contact more frequently so the reaction speeds up. 
- We can predict whether or not a reaction will happen in aqueous media by considering various *driving forces*
  - “Forces” that drive a reaction:
    - Formation of a solid.
    - Formation of water.
    - Formation of a gas.
    - Transfer of electrons.

#### Dissociation


- When ionic compounds dissolve in water, the anions and cations are separated from each other. 
  - This is called dissociation.
  - Not all ionic compounds will dissolve in water!
  - When compounds containing polyatomic ions dissociate, the polyatomic group stays together as one ion.

**Sodium chloride dissociates in water to form sodium cations and chloride anions.**
$$
\ce{
NaCl($aq$) ->  Na^{+}($aq$)  +  Cl^{-}($aq$)
}
$$

<img src="./assets/image-20240806231350799.png" alt="image-20240806231350799" style="zoom:50%;" />



**Silver Nitrate dissociates in water to form silver cations and nitrate anions **
$$
\ce{
AgNO3($aq$) -> Ag+($aq$) + NO3-($aq$)
}
$$
<img src="./assets/image-20240806231656990.png" alt="image-20240806231656990" style="zoom:50%;" />



**Silver chloride does not dissolve or dissociate. It is *insoluble* in water.**



<img src="./assets/image-20240806231921607.png" alt="image-20240806231921607" style="zoom:50%;" />



#### Electrolytes

- **Electrolytes** are substances whose water solution is a conductor of electricity.
  - All electrolytes have ions dissolved in water.
- **Strong electrolyte's** molecules or formula units dissociate completely into ions.
  - Salts, some acids and bases
- **Weak electrolyte's** molecules or formula units dissociate partially into ions.
  - Organic acids, alcohols
- **Nonelectrolyte's** molecules or formula units do not dissociate into ions.
  - Sugars


### Solubility

**When Will a Salt Dissolve?**

- A compound is **soluble** in a liquid if it dissolves in that liquid.
  - NaCl is soluble in water, but AgCl is not.
- A compound is **insoluble** if a significant amount does not dissolve in that liquid.
  - AgCl is insoluble in water.
- Predicting whether a compound will dissolve in water is not easy.
  - A convenient way to do it is to do some experiments to test whether a compound will dissolve in water, then develop some rules based on those experimental results.

#### Solubility Rules

<img src="./assets/image-20240806232932674.png" alt="image-20240806232932674" style="zoom: 40%;" />



<img src="./assets/image-20240806233023234.png" alt="image-20240806233023234" style="zoom: 40%;" />

##### Determine if Each of the Following Is Soluble in Water


- KOH
- AgBr
- CaCl~2~
- Pb(NO~3~)~2~
- PbSO~4~

#### Precipitation Reactions

- Many reactions are done by mixing aqueous solutions of electrolytes together.
- When this is done, often a reaction will take place from the cations and anions in the two solutions that are exchanging.
- If the ion exchange results in forming a compound that is insoluble in water, it will come out of solution as a precipitate.

**Process for Predicting the Products of a Precipitation Reaction**
1. Write the formula for the reactants
2. Determine what ions each aqueous reactant has.
3. Exchange ions.
    - cations from one reactant with anions from the other.
4. Balance charges of combined ions to get formula of each product.
5. Balance the equation.
6. Determine solubility of each product in water.
    - Use the solubility rules.
- If product is insoluble or slightly soluble, it will precipitate.
- If neither product will precipitate, no reaction.
  
##### When an Aqueous Solution of Sodium Carbonate Is Added to an Aqueous Solution of Copper(II) Chloride, a White Solid Forms. Write the formulas of the reactants and Determine the ions present when each reactant dissociates.

##### Predict the Products and Balance the Equation

$\ce{KCl($aq$) + AgNO3($aq$) -> }$



$\ce{Na2S($aq$) + CaCl2($aq$) ->}$



### Ionic Equations

- Equations that describe the chemicals put into the water and the product molecules are called **molecular equations**.

$$
\ce{
2 KOH($aq$) + Mg(NO3)2($aq$) -> 2 KNO3($aq$) + Mg(OH)2($s$)
}
$$

- Equations that describe the actual dissolved species are called **complete ionic equations**. 
  - Aqueous electrolytes are written as ions.
    - Soluble salts, strong acids, strong bases.
  - Insoluble substances and nonelectrolytes written in molecule form.
  - Solids, liquids, and gases are not dissolved, therefore, molecule form.

$$
\ce{
2K+($aq$) + 2OH^-($aq$) + Mg^2+($aq$) + 2NO3^-($aq$) -> 2K+($aq$) + 2NO3^-($aq$) + Mg(OH)2($s$)
}
$$

- Notice that both the reactant and the product sides contain 2K^+^ and 2NO~3~^-^ ions.
  - These are called **spectator ions**
- Canceling the spectator ions results in the **net ionic equation**.

$$
\ce{
Mg^2+($aq$) + 2OH^-($aq$)  ->  Mg(OH)2($s$)
}
$$

#### Summary

- A molecular equation is a chemical equation showing the complete, neutral formulas for every compound in a reaction.
- A complete ionic equation is a chemical equation showing all of the species as they are actually present in solution. 
- A net ionic equation is an equation showing only the species that actually participate in the reaction.  


##### Write the Ionic and Net Ionic Equation.

$$
\ce{
K2SO4($aq$) + Ba(NO3)2($aq$) -> 2 KNO3($aq$) + BaSO4($s$) 
}
$$

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

$$
\ce{
Na2CO3($aq$) + 2 HCl($aq$) -> 2 NaCl($aq$) + CO2($g$) + H2O($l$)
}
$$

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

### Acid/Base Reactions

#### Properties of Acids

- Sour taste.
- React with “active” metals, not noble metals.
  - I.e., Al, Zn, Fe, but not Cu, Ag or Au.

$$
\ce{
Zn(*s*) + 2HCl(*aq*) -> ZnCl2(*aq*) + H2(*g*)
}
$$

- Corrosive.
- React with carbonates, producing CO2.
  - Marble, baking soda, chalk, limestone.

$$
\ce{
CaCO3(*aq*) + 2HCl(*aq*) -> CaCl2(*aq*) + CO2(*g*) + H2O(*l*)
}
$$

- React with bases to form ionic salts and often water.

#### Properties of Bases

- Taste bitter
- Caustic
- Feel slippery
- React with acids to form ionic salts.

$$
\ce{
HCl($aq$) + NaOH($aq$) -> H2O($l$) + NaCl($aq$)
}
$$

<img src="./assets/image-20240810133634323.png" alt="image-20240810133634323" style="zoom:50%;" />


#### Neutralization Reactions

- The H^+1^ from the acid combines with the OH^-1^ from the base to make water.
The cation from the base combines with the anion from the acid to make the salt.

$$
\text{acid} + \text{base} \longrightarrow \text{salt} + \text{water}
$$
$$
\ce{
2 HNO3($aq$) + Ca(OH)2($aq$) -> Ca(NO3)2($aq$) + 2 H2O($l$)
}
$$

- The net ionic equation for an acid-base reaction is often

$$
\ce{
H^{+1}($aq$) + OH^{-1}($aq$) -> H2O($l$)
}
$$

  - As long as the salt that forms is soluble in water.

#### Process for Predicting the Products of an Acid–Base Reaction

1. Determine what ions each aqueous reactant has.
2. Exchange ions.
  - cation from one reactant with anion from the other.
  - H^+^ combines with OH^−^ to make water.
3. Balance charges of combined ions to get formula of the salt.
4. Balance the equation.
5. Determine solubility of the salt.
  - Use the solubility rules.
  - If the salt is insoluble or slightly soluble, it will precipitate.

##### Write the Molecular, Ionic, and Net-Ionic Equation for the Reaction of Aqueous Nitric Acid with Aqueous Calcium Hydroxide.

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>
<br/>
<br/>


##### Complete and Balance These Acid–Base Reactions.

$\ce{NH4OH($aq$) + H2SO4($aq$) ->}$

<br/>
<br/>

$\ce{Al(OH)3($aq$) + H2SO3($aq$) ->}$

<br/>
<br/>

$\ce{Ba(OH)2($aq$) + HF($aq$) ->}$

<br/>
<br/>


### Gas Evolution Reactions


- Reactions in which the driving force is the production of a material that escapes as a gas are called gas evolution reactions.
- Some reactions form a gas directly from the ion exchange.

$$
\ce{
K2S($aq$) + H2SO4($aq$) -> K2SO4($aq$) + H2S($g$)
}
$$

- Other reactions form a gas by the decomposition of one of the ion exchange products into a gas and water.

$$
\ce{
K2SO3($aq$) + H2SO4($aq$) -> K2SO4($aq$) + H2SO3($aq$) -> K2SO4($aq$) + H2O($l$) + SO2($g$)
}
$$

#### Compounds that Undergo Gas Evolving Reactions

- Metal Sulfides, M~n~S or MHS

$$
\ce{
K2S($aq$) + 2HCl($aq$) -> 2KCl($aq$) + H2S($g$)
}
$$

- Carbonates, M~n~CO~3~ or MHCO~3~

$$
\ce{
K2CO3($aq$) + 2HCl($aq$) -> 2KCl($aq$) + CO2($g$) + H2O($l$)
}
$$

- Sulfites, M~n~SO~3~ or MHSO~3~

$$
\ce{
K2SO3($aq$) + 2HCl($aq$) -> 2KCl($aq$) + SO2($g$) + H2O($l$)
}
$$

- Ammonium Salts, (NH~4~)~n~A

$$
\ce{
KOH($aq$) + NH4Cl($aq$) -> KCl($aq$) + NH3($aq$) + H2O($l$)
}
$$

#### Process for Predicting the Products of a Gas-Evolving Reaction

1. Determine what ions each aqueous reactant has.
2. Exchange ions.
  - cation from one reactant with an ion from the other.
3. Balance charges of combined ions to get formula of each product.
4. Check to see if either product is H2S.
5. Check to see if either product decomposes. If so, rewrite as H~2~O(*l*) and a gas.
6. Balance the equation.
7. Determine solubility of other product in water.


##### When an Aqueous Solution of Sodium Sulfite Is Added to an Aqueous Solution of Nitric Acid, a Gas Evolves.

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

##### Complete the Following Reactions.

$\ce{PbS($s$) + H2SO4($aq$) ->}$

<br/>
<br/>

$\ce{HNO3($aq$) + NaHCO3($aq$) ->}$

<br/>
<br/>

### Oxidation Reduction Reactions

- Redox reactions occur when one chemical species loses one or more electrons to another.
  - The species that loses electrons in the reaction is **oxidized**. 
  - The species that gains electrons in the reaction is **reduced**.
  - You cannot have one without the other.

![image-20240810154252637](./assets/image-20240810154252637.png)

- In combustion, the O atoms in O~2~ are reduced, and the non-O atoms in the other material are oxidized.
- Metals react with nonmetals to form ionic compounds.
  - The metal loses electrons and becomes a cation (oxidation).
  - The nonmetal gains electrons and becomes an anion (rduction).
  - The net result electrons are transferred from the metal to the nonmetal.

#### Example Metal with Nonmetal

In the reaction

$$
\ce{
Mg + Cl2 -> MgCl2
}
$$

The magnesium atoms are oxidized.

$$
Mg -> Mg^{2+} + 2e-
$$

The chlorine atoms are reduced.

$$
\ce{
Cl + 1e- -> Cl-
}
$$

#### Example Combustion Reactions

- Reactions in which O~2~(*g*) is a reactant are called combustion reactions.
- Combustion reactions release lots of energy. They are exothermic.
- Combustion reactions are a subclass of oxidation–reduction reactions.
- 
In the following reaction 

$$
\ce{
2 Mg($s$) + O2($g$) -> 2 MgO($s$)
}
$$

The magnesium atoms are oxidized.

$$
\ce{
Mg -> Mg^{2+} + 2e-
}
$$

The oxygen atoms are reduced.

$$
\ce{
O + 2e- -> O^{2-}
}
$$

Even though the following reaction does not involve ion formation, electrons are still transferred.

$$
\ce{
CH4($g$) + 2O2($g$) -> CO2($g$) + 2H2O($g$)
}
$$

The carbon atoms are oxidized.

$$
\ce{
C^{4-} -> C^{4+} + 8 e-
}
$$

- These are *not charges*, they are called **oxidation numbers**
  - They help us see the electron transfer.

The oxygen atoms are reduced.

$$
\ce{
O + 2e- -> O^{2-}
}
$$

#### Recognizing Redox Reactions

- Any reaction where O~2~ is a reactant or a product is a redox reaction.
- Any reaction between a metal and a nonmetal is redox.
- Any reaction where electrons are transferred is redox. 
- When a free element gets combined into a compound, it will be either oxidized or reduced.

$$
\ce{
N2($g$) + H2($g$) -> NH3($g$)
}
$$

- When a metal cation changes its charge
  - Oxidized if its charge increases or reduced if its charge decreases.

$$
\ce{
CuCl($aq$) + FeCl3($aq$) -> FeCl2($aq$) + CuCl2($aq$)
}
$$

##### Decide Whether Each of the Following Reactions Is a Redox Reaction.

$\ce{2Al($s$) + 3Br2($l$) -> 2AlBr3($s$)}$

<br/>
<br/>

$\ce{CaSO3($s$) + 2HCl($aq$) -> CaCl2($aq$) + SO2($g$) + H2O($l$)}$

<br/>
<br/>

$\ce{Fe2O3($s$) + C($s$) -> Fe($s$) + 3CO($g$)}$

<br/>
<br/>

$\ce{SO2($g$) + O2($g$) + H2O($l$) -> H2SO4($aq$)}$


## Classifying Reactions

**One way is based on the process that happens.**

<img src="./assets/image-20240810160542210.png" alt="image-20240810160542210" style="zoom:50%;" />

**Another scheme classifies reactions by what the atoms do.**

<img src="./assets/image-20240810161113258.png" alt="image-20240810161113258" style="zoom:50%;" />

<img src="./assets/image-20240810160903750.png" alt="image-20240810160903750" style="zoom: 67%;" />

### Synthesis Reactions

- Also known as composition or combination reactions.
  - Two (or more) reactants combine together to make one product.
  - Simpler substances combining together. 

$$
\ce{
2CO + O2 -> 2CO2
}
$$
$$
\ce{
2Mg + O2 -> 2MgO
}
$$
$$
\ce{
HgI2 + 2KI -> K2HgI4
}
$$

### Decomposition Reactions

- A large molecule is broken apart into smaller molecules or its elements.
  - Caused by addition of energy into the molecule.
- One reactant breaks into two or more products.

$$
\ce{
2FeCl3($s$) ->[$elec$] 2FeCl2($l$) + Cl2($g$)
}
$$
$$
\ce{
2HgO($s$) ->[\Delta] 2Hg($l$) + O2($g$)
}
$$
$$
\ce{
2O3 ->[$h\nu$] 3O2($g$)
}
$$

### Single Displacement Reactions

- Reactions that involve one atom displacing another and replacing it in a compound.

#### Examples

$$
\ce{
Zn($s$) + 2HCl($aq$) -> ZnCl2($aq$) + H2($g$)
}
$$

the atom Zn displaces H from the compound.

$$
\ce{
Fe2O3($s$) + Al($s$) -> Fe($s$) + Al2O3($s$)
}
$$

the Al atom displaces the Fe atoms

$$
\ce{
2 Na($s$) + 2H2O($aq$) -> 2NaOH($aq$) + H2($g$)
}
$$

Na atoms displaces the H atoms

$$
\ce{
Zn($s$) + CuCl2($aq$) -> Cu($s$) + ZnCl2($aq$)
}
$$

<img src="./assets/image-20240810162526404.png" alt="image-20240810162526404" style="zoom: 25%;" />

### Double Displacement Reactions

- Two ionic compounds exchange ions.
- May be followed by decomposition of one of the products to make a gas.
- Precipitation, acid–base, and gas evolving reactions are also double displacement reactions.

### Examples of Double Displacement

$$
\ce{
CaCl2($aq$) + Na2CO3($aq$) -> CaCO3($s$) + 2NaCl($aq$)
}
$$
$$
\ce{
Ba(OH)2($s$) + 2HNO3($aq$) -> Ba(NO3)2($aq$) + 2H2O($l$)
}
$$
$$
\ce{
Li2CO3($aq$) + 2HCl($aq$) -> 2LiCl($aq$) + CO2($g$) + H2O($l$)
}
$$

##### Classify the Following Reactions as Synthesis, Decomposition, Single Displacement, or Double Displacement.

$\ce{3Mg($s$) + 2FeCl3($aq$) -> 3MgCl2($aq$) + 2Fe($s$)}$

<br/>
<br/>

$\ce{CO2($g$) + H2O($l$) -> H2CO3($aq$)}$

<br/>
<br/>

$\ce{3KOH($aq$) + H3PO4($aq$) -> K3PO4($aq$) + 3H2O($l$)}$ 

<br/>
<br/>

$\ce{CaCO3($s$) ->[\Delta] CaO($s$) + CO2($g$)}$

<br/>
<br/>



# Chapter 7 Quiz




1. 	The reaction of baking soda (NaHCO~3~) and vinegar (C~2~H~3~O~2~H) to produce carbon dioxide gas is an example of a gas evolution reaction. 	(1 Point)

​				True				False

2. 	Combustion reactions are a subcategory of precipitation reactions.  (1 Point)

​				True				False

3. 	Color change is evidence that a chemical reaction has occurred.  (1 Point)

​				True				False

4. 	The formation of a gas is evidence of a chemical reaction while the emission of light is not.  (1 Point)

​				True				False

5.	Bubbles in water that appear, without boiling, indicates that a chemical reaction is occurring.  (1 Point)

​				True				False

6.	When balancing a chemical equation you may alter the subscripts but not the coefficients.  (1 Point)

​				True				False

7.	A strong electrolyte solution contains compounds that completely dissociate in water.  (1 Point)

​				True				False

8.	When compounds containing polyatomic ions dissolve, the polyatomic ions usually dissolve as intact units.  (1 Point)

​				True				False

9.	All compounds containing HO^-^ are soluble.  (1 Point)

​				True				False

10.	 Compounds containing Cl^-^, Br^-^, and I^-^ are mostly insoluble.  (1 Point)

​				True				False

11.	 A *complete ionic equation* shows all ionic species that are present in solution.  (1 Point)

​				True				False

12.	A spectator ion is one that does not actively participate in a chemical reaction.  (1 Point)

​				True				False

13.	One of the characteristics of a precipitation reaction is the formation water.  (1 Point)

​				True				False

14.	An oxidation-reduction reaction must involve reaction with oxygen.  (1 Point)

​				True				False

15.	Combustion reactions release heat and so can be classified as *endothermic*.  (1 Point)

​				True				False

16.	Decomposition reactions usually require energy to initiate the reaction.  (1 Point)

​				True				False



17. A reaction which forms a gaseous product is an example of a(n)________.  (2 Points)



A) oxidation-reduction reaction

B) combustion reaction 

C) precipitation reaction

D) gas evolution reaction

E) none of the above



18.	 A reaction in which a substance reacts with oxygen, emitting heat and forming oxygen-containing compounds is an example of a(n)  (2 Points)



A) acid-base reaction.

B) combustion reaction.

C) precipitation reaction.

D) gas evolution reaction.

E) none of the above



19.	Which of the following statements about balancing reactions is FALSE?	  (2 Points)



A) If there is no coefficient or subscript, a one is implied.

B) Spectator ions still participate in the reaction and can never be cancelled.

C) Subscripts are multiplied by the coefficients to determine the number of atoms in a compound.

D) Coefficients are added to compounds to ensure both sides of the reaction have equal numbers of each atom.

E) All of the above statements are true.



20. Which coefficient would balance the equation when filled into the blank spaces?  (2 Points) 

$$
\ce{
\_\_\_ Ba($s$) + \_\_\_ HBr($aq$) -> \_\_\_ BaBr2($aq$) + \_\_\_ H2($g$)
}
$$

A) 1, 2, 1, 1

B) 1, 2, 1, 2

C) 2, 1, 2, 1

D) 1, 1, 1, 1

E) none of the above



21. Which coefficient would balance the equation when filled into the blank spaces?  (2 Points)

$$
\ce{
\_\_\_ Al($s$) + \_\_\_ HNO2($aq$) -> \_\_\_ Al(NO2)3($aq$) + \_\_\_ H2($g$)
}
$$

A) 2, 1, 1, 1

B) 1, 3, 1, 3

C) 1, 6, 3, 2

D) 2, 6, 2, 3

E) none of the above




22.	Which of the following equations is NOT balanced properly?  (2 Points)



A) 2Cr + 6HCl → 2CrCl~3~ + 3H~2~

B) 2NaHCO~3~ → Na~2~CO~3~ + CO~2~ + H~2~O

C) Cr~2~(SO~4~)~3~ + 6KOH → 2Cr(OH)~3~ + 3 K~2~SO~4~

D) 4NH~3~ + 14O~2~ → 4NO~2~ + 6H~2~O

E) none of the above



23.	 The compound sodium sulfate is soluble in water. When this compound dissolves in water, which ions listed below would be present in solution?  (2 Points)



A) 2Na^+^ and SO~3~^2-^

B) 2Na^+^ and SO~4~^2-^

C) 2Na^+^ and S^-^

D) Na^+^ and SO~4~^-^

E) none of the above



24.	Which is a spectator ion in the following complete ionic equation:  (2 Points)

$$
\ce{
Ag^+($aq$) + NO3^-($aq$) + K^+($aq$) + Br^-($aq$) -> AgBr($s$) + K^+($aq$) + NO3^-($aq$)
}
$$



A) Ag^+^

B) Br^-^

C) NO~3~^-^

D) AgBr 

E) none of the above




25.	What type of reaction is the generic equation $\ce{AB + CD -> AD + CB}$?  (2 Points)



A) synthesis/combination

B) decomposition

C) single displacement

D) double-displacement

E) none of the above



(27)	What type of reaction is the generic equation $\ce{A + BC -> AC + B}$?  (2 Points)



A) synthesis/combination

B) decomposition

C) single displacement

D) double-displacement

E) none of the above



28. What type of reaction is the generic equation $\ce{A + B  -> AB}$?  (2 Points)



A) synthesis/combination

B) decomposition

C) single displacement

D) double-displacement

E) none of the above


<div style="page-break-after: always; visibility: hidden"> 
\pagebreak 
</div>
