---
tags: Syllabus, CHEM 118

---

# Chapter 6

## Chemical Composition

**Why Is Knowledge of  Composition Important?**

- Everything in nature is either chemically or physically combined with other substances.
  - To know the amount of a specific element in a sample, you need to know what fraction of the sample it is.
- Some Applications:
  - The amount of sodium in sodium chloride for diet.
  - The amount of iron in iron ore for steel production.
  - The amount of hydrogen in water for hydrogen fuel.
  - The amount of chlorine in freon to estimate ozone depletion.

<img src="./assets/image-20240806135132520.png" alt="image-20240806135132520" style="zoom:50%;" />

### The Mole

**Counting Nails by the Pound**

- I want to buy a certain number of nails for a project, but the hardware store sells nails by the pound.
  - How do I know how many nails I am buying when I buy a pound of nails?

##### A hardware store customer buys 2.60 pounds of nails.  A dozen nails has a mass of 0.150 pounds.  How many nails did the customer buy?

1 dozen nails = 0.150 lbs.
12 nails = 1 dozen nails

##### A marble company produces three kinds of marbles. What is the average mass of the marbles? The company sells the marbles in bags of sixteen. What is the average mass of a bag of marbles in pounds?

| Color  | Mass (oz) | Daily Production |
| ------ | --------- | ---------------- |
| Red    | 2.1       | 1500             |
| Blue   | 2.4       | 1300             |
| Orange | 1.9       | 1400             |




- If we know the average mass of a particular number of atoms, we can use this information to convert the mass of an element sample to the number of atoms in the sample.
- We can choose a clever quantity to make the units work out convienently 
  - The quantity of atoms we will use is 6.022 x 10^23^ and we call this a **mole**.
  - 1 mole = 6.022 x 10^23^ things.
  - Like 1 dozen = 12 things or 1 bag = 16 things
  - Avogadro’s number.
- The mole is based on careful measurements made on the carbon-12 isotope
  - Mole = Number of things equal to the number of atoms in 12 g of C-12. 
  - 1 atom of C-12 weighs exactly 12 amu.
  - 1 mole of C-12 weighs exactly 12 g.


##### A Silver Ring Contains 1.1 x 10^22^ Silver Atoms.  How Many Moles of Silver Are in the Ring?

To determine the number of moles of silver in the ring, we can use Avogadro's number. Avogadro's number is $ 6.022 \times 10^{23} $ atoms/mol, which is the number of atoms present in one mole of any substance. 

The relationship between moles, number of atoms, and Avogadro's number is given by the equation:

$$
\text{moles} = \frac{\text{number of atoms}}{\text{Avogadro's number}}
$$

For this specific problem, the number of silver atoms present in the silver ring is $ 1.1 \times 10^{22} $ atoms. Thus, to find the number of moles, we substitute the given values into the formula:

$$
\text{moles of silver} = \frac{1.1 \times 10^{22} \text{ atoms}}{6.022 \times 10^{23} \text{ atoms/mol}}
$$

Let's calculate the number of moles:

1. Plug in the values:

   $$
   \text{moles of silver} = \frac{1.1 \times 10^{22}}{6.022 \times 10^{23}}
   $$

2. Perform the division:

   $$
   \text{moles of silver} \approx 1.826 \times 10^{-2} \text{ mol}
   $$

Therefore, the silver ring contains approximately $ 1.826 \times 10^{-2} $ moles of silver.

##### Calculate the Number of Atoms in 2.45 Mol of Copper.

To find the number of atoms in 2.45 mol of copper (Cu), we will use Avogadro's number.

$
\text{Number of atoms} = 2.45 \, \text{mol} \times 6.022 \times 10^{23} \, \text{atoms/mol} = 1.475 \times 10^{24} \, \text{atoms}
$

### Moles and Mass

- The mass of one mole of atoms is called the molar mass.
  - The molar mass ($\frac{\text{g}}{\text{mol}}$) of an element is numerically equal to the element’s atomic mass ($\frac{\text{amu}}{\text{atom}}$).
  - The molar mass ($\frac{\text{g}}{\text{mol}}$) of a compound is numerically equal to the compounds formula mass ($\frac{\text{amu}}{\text{molecule}}$). 

##### Calculate the Moles of Sulfur  in 57.8 G of Sulfur.

The formula mass of sulfur (S) is 32.07 $\pu{g //mol}$. The moles can be calculated by
$$
\ce{
moles S = 57.8 g S \left(\frac{1 mole S}{32.07 g S}\right) = 1.80 mole S
}
$$


##### Calculate the Mass of Carbon 2.21 ⨯ 10^-3^ moles of Pencil Lead.

The formula mass of carbon (C) is 12.01 $\pu{g // mol}$. We can calculate the mass of carbon with
$$
\ce{
2.21 \times 10^{-3} moles C \left(\frac{12.01 g C}{1 mole C}\right) = 0.0265 g C
}
$$

### Mass and Atoms

- Using the number of moles allows us to convert between the mass of a sample (a measurable quantity) and the number of atoms or molecules.

<img src="./assets/NMolesMass-1722974061669-2.png" alt="NMolesMass" style="zoom: 80%;" />


##### How Many Aluminum Atoms Are in a Can Weighing 16.2 g?

The formula mass of aluminum (Al) is 26.98 $\pu{g // mol}$. The number of atoms present in 16.2 g sample of aluminum is
$$
\ce{
16.2 g Al \left(\frac{1 mole Al}{26.98 g Al}\right) \left(\frac{6.022 \times 10^{23} Al atoms}{1 mole Al}\right) = 3.62 \times 10^{23} Al atoms 
}
$$

##### What is the mass of 2.94 ⨉ 10^22^ atoms of Cu?

The formula mass of copper (Cu) is 63.55 $\pu{g //mol}$. The mass of this many atoms of copper is therefore
$$
\ce{
2.94 \times 10^{22} Cu atoms \left(\frac{1 mole Cu}{6.022 \times 10^{23} Cu atoms}\right) \left(\frac{63.55 g}{1 mole Cu}\right) = 3.10 g Cu
}
$$


**Calculate the Mass of 1.75 Mol of H~2~O.**

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

##### How Many Moles Are in 50.0 g of PbO~2~?

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

##### How Many Formula Units Are in 50.0 g of PbO~2~?

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

##### What Is the Mass of 4.78 x 10^24^ NO~2~ Molecules?

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>


### Chemical Formulas as Conversion Factors

1 spider ≡ 8 legs.
1 chair ≡ 4 legs.
1 H~2~O molecule ≡ 2 H atoms  ≡ 1 O atom.

<img src="./assets/image-20240806160232739.png" alt="image-20240806160232739" style="zoom: 25%;" />

- If we know how many parts are in the whole unit, by counting the number of whole units, we can effectively count the parts.
- Since we count atoms and molecules in mole units, we can find the number of moles of a constituent element if we know the number of moles of the compound.

$$
\ce{
16 mole H2O \left( \frac{2 mole H}{1 mole H2O} \right) = 32 mole H
}
$$

##### Calculate the Moles of Oxygen  in 1.7 Moles of CaCO~3~.

$$
\ce{
1.7 moles CaCO3 \left(\frac{3 mole O}{1 mole CaCO3}\right) = 5.1 moles O
}
$$



##### Find the Mass of Carbon in 55.4 g C~10~H~14~O.

This is now a three step process
$$
\ce{
Mass of C10H14O -> Moles C10H14O -> Moles of Carbon -> Mass of Carbon
\\\\
}
$$
First we need to know the formula mass of C~10~H~14~O and the atomic mass of carbon (12.01 $\pu{g // mol}$).
$$
\ce{
M_{C_{10}H_{14}O} = 10 C (12.01 \pu{g // mol}) + 14 H (1.01 \pu{g // mol}) + 1 O (16.00 \pu{g // mol}) = 150.24 \pu{g // mol}
}
$$
Now we can perform the three step calculation all at once.
$$
\ce{
55.4 g C10H14O \left(\frac{1 mole C10H14O}{150.24 g}\right)\left(\frac{10 mole C}{1 mole C10H14O}\right)\left(\frac{12.01 g C}{1 mole C}\right) = 44.29 g C
}
$$


##### Find the Mass of Sodium in 6.2 g of NaCl

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

### Percent Composition

- To determine the mass of a component from the mass of a compound you must go through the molar ratios.
- However, the molar ratios and molar masses of the components for a specific compound is always the same.
  - We can be clever to make our math a little simpler

##### Find the Mass of Sodium in 6.2 g of NaCl using the percent composition.

$$
\ce{
6.2 g NaCl \left(\frac{1 mole NaCl}{58.44 g NaCl}\right) \left(\frac{1 mole Na}{1 mole NaCl}\right) \left(\frac{22.99 g Na}{1 mole Na}\right)
}
$$

$$
\ce{
= 6.2 g NaCl \left(\frac{22.9 g Na}{58.44 g NaCl}\right)
}
$$

$$
\ce{
= 6.2 g NaCl (0.392) = 2.43 g Na
}
$$

$$
\ce{
Percent Composition Sodium in Sodium Chloride = 0.392 \times 100 \% = 39.2 \%
}
$$

- The percent composition tells you the mass of a constituent element in 100 g of the compound.

##### Find the Mass Percent of Cl in C~2~Cl~4~F~2~.

#### The experimental mass analysis of the compound.

- The percent composition of a sample can be measured directly through experimentation
  - The percentages may not always total to 100% due to rounding.

- The percent composition data can be used to find the empirical formula of the compound 
  - The simplest, whole-number ratio of atoms in a molecule.
  - The molecular formula is a multiple of the empirical formula.

#### Rules for finding an Empirical Formula from Percent Composition

1.	Convert the percentages to grams.
	a.	Skip if already grams.
2.	Convert grams to moles.
	a.	Use molar mass of each element.
3.	Write a pseudoformula using moles as subscripts.
4.	Divide all by smallest number of moles.
5.	Multiply all mole ratios by number to make all whole numbers, if necessary.
    a.	If ratio 0.5, multiply all by 2; if ratio 0.33 or 0.67, multiply all by 3, etc. 
    b.	Skip if already whole numbers after Step 4.

##### A laboratory analysis of aspirin determined the following mass percent composition.  Find the empirical formula.

| Element | Percent Composition |
| :-----: | :-----------------: |
|    C    |       60.00 %       |
|    H    |       4.48 %        |
|    O    |       35.53 %       |

These problems are not a simple formula. Instead, we need to follow an algorithm. It is important to follow all of the steps very carefully.

First we will assume that we have 100 g of sample and calculate the mass of each element in that sample.
$$
\ce{
100 g sample \left(\frac{60.00 g C}{100 g sample}\right) = 60.00 g C
\\
100 g sample \left(\frac{4.48 g H}{100 g sample}\right) = 4.48 g H
\\
100 g sample \left(\frac{35.53 g O}{100 g sample}\right) = 35.53 g O
}
$$
We can now calculate the number of moles of each element in the sample.
$$
\ce{
60.00 g C \left(\frac{1 mole C}{12.01 g C}\right) = 4.996 mole C
\\
4.48 g H \left(\frac{1 mole H}{1.01 g H}\right) = 4.436 mole H
\\
35.53 g O \left(\frac{1 mole O}{16.00 g O}\right) = 2.221 mole O
}
$$
Now, I’m going to write a silly chemical formula.
$$
\ce{
C_{4.996}H_{4.436}O_{2.221}
}
$$
We can’t have fractional subscripts. To handle this we will begin by dividing all of the subscripts by the smallest subscript.
$$
\ce{
C_{\frac{4.996}{2.221}}H_{\frac{4.436}{2.221}}O_{\frac{2.221}{2.221}}
\\\\
\ce{
C_{2.249}H_{1.997}O
}
}
$$
Now comes the trickier part, we need to decide how to round these values. You should round the values to the nearest quarter or third. For instance, these values should be rounded as
$$
\ce{
C_{2.25}H_{2}O
}
$$
We can now finally clear the fractional subscripts by multiplying all of the values by four.
$$
\ce{C9H8O4}
$$


##### A 3.24-g sample of titanium reacts with oxygen to form 5.40 g of the metal oxide. What is the formula of the oxide? 

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

##### Determine the Empirical Formula of Stannous Fluoride, which Contains 75.7% tin and the Rest Fluorine.

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

#### Determine the Empirical Formula of Hematite, which Contains 72.4% Fe and the Rest Oxygen.

### Molecular Formulas From Empirical Formulas

- The molecular formula is a multiple of the empirical formula.
- To determine the molecular formula, you need to know the empirical formula and the molar mass of the compound.

##### Determine the Molecular Formula of Cadinene if it has a Molar Mass of 204 g/mol and an Empirical Formula of C~5~H~8~. 

Remember that the subscripts of the empirical formula are the least common multiple of the molecular formulas subscripts. We can decide what the molecular formula is by making a table of possible molecular formulas and their formula masses.

| Chemical Formula | Formula Mass           |
| ---------------- | ---------------------- |
| $\ce{C5H8}$      | 68.12 $\pu{g // mol}$  |
| $\ce{C10H16}$    | 133.24 $\pu{g // mol}$ |
| $\ce{C15H24}$    | 204.36 $\pu{g // mol}$ |
| $\ce{C20H32}$    | 272.48 $\pu{g // mol}$ |

From these results it is clear that the actual molecular formula is C~15~H~24~.

##### Benzopyrene has a Molar Mass of 252 g/mol and an Empirical Formula of C~5~H~3~.  What is its Molecular Formula?

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

##### Determine the Molecular Formula of Nicotine, which has a Molar Mass of 162 g/mol and is 74.0% C, 8.7% H, and the Rest N.

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>



# Chapter 7


## Chemical Reactions


- Reactions involve chemical changes in matter resulting in new substances.
- Chemical bonds are broken and formed to produce new molecules.
  - Molecules can combine to make bigger molecules.
  - Molecules can decompose into smaller molecules or atoms.
  - Atoms can be exchanged between molecules or transferred to another molecule.
  - Atoms can gain or lose electrons, turning them into ions.
    - Or changing the charge on ions that are already there.

#### Evidence of Chemical Reactions

- Look for evidence of a new substance.
- Permanent Visual clues.
  - Color change. 
  - Precipitate formation. 
    - Solid that forms when liquid solutions are mixed.
  - Gas bubbles. 
  - Large energy changes.
    - Large Temperature Changes
    - Emission of light.
- Other clues.
  - New odor. 
  - Whooshing sound from a tube. 
  - Permanent new phase.
  **Evidence is Not Proof!**

In order to be absolutely sure that a chemical reaction has taken place, you need to go down to the molecular level and analyze the structures of the molecules at the beginning and end. 

##### Decide Whether Each of the Following Involve a Chemical Reaction.

- Photosynthesis
- Heating sugar until it turns black
- Heating ice until it becomes a liquid
- Digestion of food
- Dissolving sugar in water
- Burning paper


### Chemical Equations

- Short-hand way of describing a reaction.
- Provides lots of information about the reaction.
  - Formulas of reactants and products.
  - Phases of reactants and products.
  - Relative numbers of reactant and product molecules that are required.
  - Can be used to determine masses of reactants used and products that can be made.

### Symbols used in Chemical Equations

|  Phase  |  Symbol  |
| :-----: | :------: |
|   gas   | ( *g* )  |
| liquid  | ( *l* )  |
|  solid  | ( *s* )  |
| aqueous | ( *aq* ) |

|   Energy   |  Symbol  |
| :--------: | :------: |
|    heat    | $\Delta$ |
|   light    |  $h\nu$  |
| mechanical | $shock$  |
| electrical |  $elec$  |

| Symbol     | Meaning                                                      |
| ---------- | ------------------------------------------------------------ |
| $\ce{->}$  | Indicates the direction of the reaction. From the **reactants** on the left to the **products** on the right. |
| $\ce{<=>}$ | Indicates the reaction is capable of running in both directions (*reversible*) |



#### The Combustion of Methane

<img src="./assets/image-20240806220342637.png" alt="image-20240806220342637" style="zoom: 33%;" />

**Methane gas burns to produce carbon dioxide gas and gaseous water.**

$$
\ce{
CH4($g$) + O2($g$) -> CO2($g$) + H2O($g$)
}
$$


##### Balancing the Reaction

- As written there is not the same number of atoms on each side
  - This violates the *Law of Conservation of Mass*
  - O and H do not *balance*.



<img src="./assets/image-20240806220922262.png" alt="image-20240806220922262" style="zoom:50%;" />

<img src="./assets/image-20240806220952206.png" alt="image-20240806220952206" style="zoom:50%;" />

- To correct this we have to adjust the **stoichiometric coefficients** 
  - These indicate the number of each molecule participate in the reaction

<img src="./assets/image-20240806221132969.png" alt="image-20240806221132969" style="zoom:50%;" />



- This equation is balanced, meaning that there are equal numbers of atoms of each element on the reactant and product sides.
- To obtain the number of atoms of an element, multiply the subscript by the coefficient.

<img src="./assets/image-20240806221348788.png" alt="image-20240806221348788" style="zoom:50%;" />


### Rules for Writing Balanced Chemical Equations

1. Write a skeletal equation by writing the formula of each reactant and product.
2. Count the number of atoms of each element on each side of the equation.
     - Polyatomic ions may often be counted as if they are one “element”.
3. Pick an element to balance.

     - If an element is found in only one compound on both sides, balance it first.
     - Metals before nonmetals.
     - Leave free elements until last. 
4. Find the least common multiple (LCM) of the number of atoms on each side.
5. Multiply each count by a factor to make it equal to the LCM.
6. Use this factor as a coefficient in the equation.

     - If there is already a coefficient there, multiply it by the factor.
     - It must go in front of entire molecules, not between atoms within a molecule.
7. Recount and repeat until balanced. 

##### When magnesium metal burns in air, it produces a white, powdery compound magnesium oxide.

<img src="./assets/image-20240806223239505.png" alt="image-20240806223239505" style="zoom: 80%;" />

1. Write a skeletal equation

$$
\ce{
Mg($s$) + O2($g$) -> MgO($s$)
}
$$

2. Count the number of atoms on each side.

$$
\ce{
1 <- Mg -> 1
}
$$
$$
\ce{
2 <- O -> 1
}
$$

3. Pick an element to balance.

Magnesium is already balanced so oxygen is the obvious choice.

4. Find the LCM of both sides 

The least common multiple of 2 and 1 is 2.

5. Multiply each side by factor so it equals LCM.
6. Use factors as coefficients in front of the compound containing the element.

$$
\ce{
Mg($s$) + O2($g$) -> 2MgO($s$)
}
$$
$$
\ce{
1 <- Mg -> 1 \times 2
}
$$
$$
\ce{
2 <- O -> 1 \times 2
}
$$

7. Recount
$$
\ce{
1 <- Mg -> 2
}
$$
$$
\ce{
2 <- O -> 2
}
$$

8. and Repeat—attacking an unbalanced element.

$$
\ce{
2 Mg($s$) + O2($g$) -> 2 MgO($s$)
}
$$
$$
\ce{
2 \times 1 <- Mg -> 2 
}
$$
$$
\ce{
2 <- O -> 2
}
$$

9. Recount—Mg not balanced now

$$
\ce{
2 <- Mg -> 2 
}
$$
$$
\ce{
2 <- O -> 2
}
$$





##### Under appropriate conditions at 1000°C, ammonia gas reacts with oxygen gas to produce gaseous nitrogen monoxide and steam. Write a balanced chemical equation for this reaction.

First we need to interpret the problem to write a skeletal chemical equation. We will need to use our naming skills.
$$
\ce{
NH3($g$) + O2($g$) -> NO($g$) + H2O($g$)
}
$$

$$
\ce{
1 <- N -> 1
\\
3 <- H -> 2
\\
2 <- O -> 2
}
$$

We need to balance hydrogen. This will require changing two coefficients.
$$
\ce{
2NH3($g$) + O2($g$) -> NO($g$) + 3H2O($g$)
}
$$

$$
\ce{
2 <- N -> 1
\\
6 <- H -> 6
\\
2 <- O -> 4
}
$$

Now we must decide whether to balance nitrogen or oxygen. Pro tip, since we can balance O~2~ without effecting the balance of any other element, we should save it for last. We will balance nitrogen.
$$
\ce{
2NH3($g$) + O2($g$) -> 2NO($g$) + 3H2O($g$)
}
$$

$$
\ce{
2 <- N -> 2
\\
6 <- H -> 6
\\
2 <- O -> 5
}
$$

Okay, we’re close. But we still have a problem there is no whole value value coefficient for O~2~ that will balance the equation. We could use a fraction though.
$$
\ce{
2NH3($g$) + \frac{5}{2}O2($g$) -> 2NO($g$) + 3H2O($g$)
}
$$

$$
\ce{
2 <- N -> 2
\\
6 <- H -> 6
\\
5 <- O -> 5
}
$$

But we can’t use fractional coefficients? That’s okay, we can multiply all of the coefficients by 2 to clear the fraction.
$$
\ce{
4 NH3($g$) + 5 O2($g$) -> 4 NO($g$) + 6 H2O($g$)
}
$$

$$
\ce{
4 <- N -> 4
\\
12 <- H -> 12
\\
10 <- O -> 10
}
$$



##### When aluminum metal reacts with oxygen in the air, it produces a white, powdery compound called aluminum oxide. Write a balanced chemical equation for this reaction.

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

##### Acetic acid reacts with the metal aluminum to make aqueous aluminum acetate and gaseous hydrogen. Write a balanced chemical equation for this reaction.

$$
\ce{
Al($s$) + HC2H3O2($aq$) ->  Al(C2H3O2)3($aq$) + H2($g$)
}
$$

There is a little trick we can use to help us balance these types of chemical equations. We can treat the polyatomic as if it is a single element. For example our initial count could be
$$
\ce{
1 <- Al -> 1
\\
1 <- H -> 2
\\
1 <- C2H3O2 -> 3
}
$$
We can now balance the hydrogen and acetate ions.
$$
\ce{
Al($s$) + 3HC2H3O2($aq$) ->  Al(C2H3O2)3($aq$) + \frac{3}{2}H2($g$)
}
$$

$$
\ce{
1 <- Al -> 1
\\
3 <- H -> 3
\\
3 <- C2H3O2 -> 3
}
$$

We can now clear the fractional coefficient by multiplying all of the coefficients by two.
$$
\ce{
2 Al($s$) + 6 HC2H3O2($aq$) ->  2 Al(C2H3O2)3($aq$) + 3 H2($g$)
}
$$

$$
\ce{
2 <- Al -> 2
\\
6 <- H -> 6
\\
6 <- C2H3O2 -> 6
}
$$



##### Write a balanced chemical for the combustion of ethanol (C~2~H~5~OH).

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>
<br/>
<br/>
<br/>


### Aqueous Solutions

- Many times, the chemicals we are reacting together are dissolved in water.
  - Mixtures of a chemical dissolved in water are called **aqueous solutions**.
- Dissolving the chemicals in water helps them to react together faster.
  - The water separates the chemicals into individual molecules or ions.
  - The separate, free-floating particles come in contact more frequently so the reaction speeds up. 
- We can predict whether or not a reaction will happen in aqueous media by considering various *driving forces*
  - “Forces” that drive a reaction:
    - Formation of a solid.
    - Formation of water.
    - Formation of a gas.
    - Transfer of electrons.

#### Dissociation


- When ionic compounds dissolve in water, the anions and cations are separated from each other. 
  - This is called dissociation.
  - Not all ionic compounds will dissolve in water!
  - When compounds containing polyatomic ions dissociate, the polyatomic group stays together as one ion.

**Sodium chloride dissociates in water to form sodium cations and chloride anions.**
$$
\ce{
NaCl($aq$) ->  Na^{+}($aq$)  +  Cl^{-}($aq$)
}
$$

<img src="./assets/image-20240806231350799.png" alt="image-20240806231350799" style="zoom:50%;" />



**Silver Nitrate dissociates in water to form silver cations and nitrate anions **
$$
\ce{
AgNO3($aq$) -> Ag+($aq$) + NO3-($aq$)
}
$$
<img src="./assets/image-20240806231656990.png" alt="image-20240806231656990" style="zoom:50%;" />



**Silver chloride does not dissolve or dissociate. It is *insoluble* in water.**



<img src="./assets/image-20240806231921607.png" alt="image-20240806231921607" style="zoom:50%;" />



#### Electrolytes

- **Electrolytes** are substances whose water solution is a conductor of electricity.
  - All electrolytes have ions dissolved in water.
- **Strong electrolyte's** molecules or formula units dissociate completely into ions.
  - Salts, some acids and bases
- **Weak electrolyte's** molecules or formula units dissociate partially into ions.
  - Organic acids, alcohols
- **Nonelectrolyte's** molecules or formula units do not dissociate into ions.
  - Sugars


### Solubility

**When Will a Salt Dissolve?**

- A compound is **soluble** in a liquid if it dissolves in that liquid.
  - NaCl is soluble in water, but AgCl is not.
- A compound is **insoluble** if a significant amount does not dissolve in that liquid.
  - AgCl is insoluble in water.
- Predicting whether a compound will dissolve in water is not easy.
  - A convenient way to do it is to do some experiments to test whether a compound will dissolve in water, then develop some rules based on those experimental results.

#### Solubility Rules

<img src="./assets/image-20240806232932674.png" alt="image-20240806232932674" style="zoom: 40%;" />



<img src="./assets/image-20240806233023234.png" alt="image-20240806233023234" style="zoom: 40%;" />

##### Determine if Each of the Following Is Soluble in Water


- KOH
- AgBr
- CaCl~2~
- Pb(NO~3~)~2~
- PbSO~4~

#### Precipitation Reactions

- Many reactions are done by mixing aqueous solutions of electrolytes together.
- When this is done, often a reaction will take place from the cations and anions in the two solutions that are exchanging.
- If the ion exchange results in forming a compound that is insoluble in water, it will come out of solution as a precipitate.

**Process for Predicting the Products of a Precipitation Reaction**
1. Write the formula for the reactants
2. Determine what ions each aqueous reactant has.
3. Exchange ions.
    - cations from one reactant with anions from the other.
4. Balance charges of combined ions to get formula of each product.
5. Balance the equation.
6. Determine solubility of each product in water.
    - Use the solubility rules.
- If product is insoluble or slightly soluble, it will precipitate.
- If neither product will precipitate, no reaction.
  
##### When an Aqueous Solution of Sodium Carbonate Is Added to an Aqueous Solution of Copper(II) Chloride, a White Solid Forms. Write the formulas of the reactants and Determine the ions present when each reactant dissociates.

##### Predict the Products and Balance the Equation

$\ce{KCl($aq$) + AgNO3($aq$) -> }$



$\ce{Na2S($aq$) + CaCl2($aq$) ->}$



### Ionic Equations

- Equations that describe the chemicals put into the water and the product molecules are called **molecular equations**.

$$
\ce{
2 KOH($aq$) + Mg(NO3)2($aq$) -> 2 KNO3($aq$) + Mg(OH)2($s$)
}
$$

- Equations that describe the actual dissolved species are called **complete ionic equations**. 
  - Aqueous electrolytes are written as ions.
    - Soluble salts, strong acids, strong bases.
  - Insoluble substances and nonelectrolytes written in molecule form.
  - Solids, liquids, and gases are not dissolved, therefore, molecule form.

$$
\ce{
2K+($aq$) + 2OH^-($aq$) + Mg^2+($aq$) + 2NO3^-($aq$) -> 2K+($aq$) + 2NO3^-($aq$) + Mg(OH)2($s$)
}
$$

- Notice that both the reactant and the product sides contain 2K^+^ and 2NO~3~^-^ ions.
  - These are called **spectator ions**
- Canceling the spectator ions results in the **net ionic equation**.

$$
\ce{
Mg^2+($aq$) + 2OH^-($aq$)  ->  Mg(OH)2($s$)
}
$$

#### Summary

- A molecular equation is a chemical equation showing the complete, neutral formulas for every compound in a reaction.
- A complete ionic equation is a chemical equation showing all of the species as they are actually present in solution. 
- A net ionic equation is an equation showing only the species that actually participate in the reaction.  


##### Write the Complete Ionic and Net Ionic Equation.

$$
\ce{
K2SO4($aq$) + Ba(NO3)2($aq$) -> 2 KNO3($aq$) + BaSO4($s$) 
}
$$

To arrive at the *complete ionic equation*, we must decompose all of the *aqueous* species into their constituent ions.
$$
\ce{
2K+($aq$) + SO4($aq$) + Ba^2+($aq$) + 2NO3^-($aq$) -> 2K+($aq$) + 2NO3^-($aq$) + BaSO4($s$)
}
$$
To derive the *net ionic equation*, we must cancel any **spectator species**: ions, atoms, or molecules that appear unchanged on both sides of the equation.
$$
\ce{
SO4($aq$) + Ba^2+($aq$) -> BaSO4($s$)
}
$$
Now, you can try
$$
\ce{
Na2CO3($aq$) + 2 HCl($aq$) -> 2 NaCl($aq$) + CO2($g$) + H2O($l$)
}
$$

<br/>
<br/>
<br/>
<br/>
<br/>
<br/>

### Acid/Base Reactions

#### Properties of Acids

- Sour taste.
- React with “active” metals, not noble metals.
  - I.e., Al, Zn, Fe, but not Cu, Ag or Au.

$$
\ce{
Zn(*s*) + 2HCl(*aq*) -> ZnCl2(*aq*) + H2(*g*)
}
$$

- Corrosive.
- React with carbonates, producing CO2.
  - Marble, baking soda, chalk, limestone.

$$
\ce{
CaCO3(*aq*) + 2HCl(*aq*) -> CaCl2(*aq*) + CO2(*g*) + H2O(*l*)
}
$$

- React with bases to form ionic salts and often water.

#### Properties of Bases

- Taste bitter
- Caustic
- Feel slippery
- React with acids to form ionic salts.

$$
\ce{
HCl($aq$) + NaOH($aq$) -> H2O($l$) + NaCl($aq$)
}
$$

<img src="./assets/image-20240810133634323.png" alt="image-20240810133634323" style="zoom:50%;" />


#### Neutralization Reactions

- The H^+1^ from the acid combines with the OH^-1^ from the base to make water.
The cation from the base combines with the anion from the acid to make the salt.

$$
\text{acid} + \text{base} \longrightarrow \text{salt} + \text{water}
$$
$$
\ce{
2 HNO3($aq$) + Ca(OH)2($aq$) -> Ca(NO3)2($aq$) + 2 H2O($l$)
}
$$

- The net ionic equation for an acid-base reaction is often

$$
\ce{
H^{+1}($aq$) + OH^{-1}($aq$) -> H2O($l$)
}
$$

  - As long as the salt that forms is soluble in water.

#### Process for Predicting the Products of an Acid–Base Reaction

1. Determine what ions each aqueous reactant has.
2. Exchange ions.
  - cation from one reactant with anion from the other.
  - H^+^ combines with OH^−^ to make water.
3. Balance charges of combined ions to get formula of the salt.
4. Balance the equation.
5. Determine solubility of the salt.
  - Use the solubility rules.
  - If the salt is insoluble or slightly soluble, it will precipitate.

##### Write the Molecular, Complete Ionic, and Net-Ionic Equation for the Reaction of Aqueous Nitric Acid with Aqueous Calcium Hydroxide.

First, we interpret the problem to write a skeletal chemical equation.
$$
\ce{
HNO3($aq$) + Ca(OH)2($aq$) -> Ca(NO3)2($aq$) + H2O($l$)
}
$$
Next, we must balance the equation.
$$
\ce{
2HNO3($aq$) + Ca(OH)2($aq$) -> Ca(NO3)2($aq$) + 2H2O($l$)
}
$$
Now we can decompose all of the aqueous species into their constituent ions.
$$
\ce{
2 H+($aq$) + 2NO3^-($aq$) + Ca^2+($aq$) + 2OH^-($aq$) -> Ca^2+($aq$) + 2NO3^-($aq$) + 2H2O($l$) 
}
$$
Finally, we cancel all of the spectator species to derive the *net ionic equation*.
$$
\ce{
2 H+($aq$) + 2OH^-($aq$) -> 2H2O($l$) 
}
$$



##### Complete and Balance These Acid–Base Reactions.

$\ce{NH4OH($aq$) + H2SO4($aq$) ->}$

<br/>
<br/>

$\ce{Al(OH)3($aq$) + H2SO3($aq$) ->}$

<br/>
<br/>

$\ce{Ba(OH)2($aq$) + HF($aq$) ->}$

<br/>
<br/>


### Gas Evolution Reactions


- Reactions in which the driving force is the production of a material that escapes as a gas are called gas evolution reactions.
- Some reactions form a gas directly from the ion exchange.

$$
\ce{
K2S($aq$) + H2SO4($aq$) -> K2SO4($aq$) + H2S($g$)
}
$$

- Other reactions form a gas by the decomposition of one of the ion exchange products into a gas and water.

$$
\ce{
K2SO3($aq$) + H2SO4($aq$) -> K2SO4($aq$) + H2SO3($aq$) -> K2SO4($aq$) + H2O($l$) + SO2($g$)
}
$$

#### Compounds that Undergo Gas Evolving Reactions

- Metal Sulfides, M~n~S or MHS

$$
\ce{
K2S($aq$) + 2HCl($aq$) -> 2KCl($aq$) + H2S($g$)
}
$$

- Carbonates, M~n~CO~3~ or MHCO~3~

$$
\ce{
K2CO3($aq$) + 2HCl($aq$) -> 2KCl($aq$) + CO2($g$) + H2O($l$)
}
$$

- Sulfites, M~n~SO~3~ or MHSO~3~

$$
\ce{
K2SO3($aq$) + 2HCl($aq$) -> 2KCl($aq$) + SO2($g$) + H2O($l$)
}
$$

- Ammonium Salts, (NH~4~)~n~A

$$
\ce{
KOH($aq$) + NH4Cl($aq$) -> KCl($aq$) + NH3($aq$) + H2O($l$)
}
$$

#### Process for Predicting the Products of a Gas-Evolving Reaction

1. Determine what ions each aqueous reactant has.
2. Exchange ions.
  - cation from one reactant with an ion from the other.
3. Balance charges of combined ions to get formula of each product.
4. Check to see if either product is H~2~S.
5. Check to see if either product decomposes. If so, rewrite as H~2~O(*l*) and a gas.
6. Balance the equation.
7. Determine solubility of other product in water.


##### When an Aqueous Solution of Sodium Sulfite Is Added to an Aqueous Solution of Nitric Acid, a Gas Evolves.

First, we interpret the problem to write a skeletal chemical equation.
$$
\ce{
Na2SO3($aq$) + HNO3($aq$) -> NaNO3($aq$) + H2SO3($aq$)
}
$$
Now we balance the equation
$$
\ce{
Na2SO3($aq$) + 2HNO3($aq$) -> 2NaNO3($aq$) + H2SO3($aq$)
}
$$
Now the tricky part, we need to recogize that H~2~SO~3~ is going to decompose into SO~2~ gas and liquid water.
$$
\ce{
Na2SO3($aq$) + 2HNO3($aq$) -> 2NaNO3($aq$) + H2SO3($aq$) -> 2NaNO3($aq$) + SO2($g$) + H2O($l$)
}
$$


##### Complete the Following Reactions.

$\ce{PbS($s$) + H2SO4($aq$) ->}$

<br/>
<br/>

$\ce{HNO3($aq$) + NaHCO3($aq$) ->}$

<br/>
<br/>

### Oxidation Reduction Reactions

- Redox reactions occur when one chemical species loses one or more electrons to another.
  - The species that loses electrons in the reaction is **oxidized**. 
  - The species that gains electrons in the reaction is **reduced**.
  - You cannot have one without the other.

![image-20240810154252637](./assets/image-20240810154252637.png)

- In combustion, the O atoms in O~2~ are reduced, and the non-O atoms in the other material are oxidized.
- Metals react with nonmetals to form ionic compounds.
  - The metal loses electrons and becomes a cation (oxidation).
  - The nonmetal gains electrons and becomes an anion (rduction).
  - The net result electrons are transferred from the metal to the nonmetal.

#### Example Metal with Nonmetal

In the reaction

$$
\ce{
Mg + Cl2 -> MgCl2
}
$$

The magnesium atoms are oxidized.

$$
Mg -> Mg^{2+} + 2e-
$$

The chlorine atoms are reduced.

$$
\ce{
Cl + 1e- -> Cl-
}
$$

#### Example Combustion Reactions

- Reactions in which O~2~(*g*) is a reactant are called combustion reactions.
- Combustion reactions release lots of energy. They are exothermic.
- Combustion reactions are a subclass of oxidation–reduction reactions.
- 
In the following reaction 

$$
\ce{
2 Mg($s$) + O2($g$) -> 2 MgO($s$)
}
$$

The magnesium atoms are oxidized.

$$
\ce{
Mg -> Mg^{2+} + 2e-
}
$$

The oxygen atoms are reduced.

$$
\ce{
O + 2e- -> O^{2-}
}
$$

Even though the following reaction does not involve ion formation, electrons are still transferred.

$$
\ce{
CH4($g$) + 2O2($g$) -> CO2($g$) + 2H2O($g$)
}
$$

The carbon atoms are oxidized.

$$
\ce{
C^{4-} -> C^{4+} + 8 e-
}
$$

- These are *not charges*, they are called **oxidation numbers**
  - They help us see the electron transfer.

The oxygen atoms are reduced.

$$
\ce{
O + 2e- -> O^{2-}
}
$$

#### Recognizing Redox Reactions

- Any reaction where O~2~ is a reactant or a product is a redox reaction.
- Any reaction between a metal and a nonmetal is redox.
- Any reaction where electrons are transferred is redox. 
- When a free element gets combined into a compound, it will be either oxidized or reduced.

$$
\ce{
N2($g$) + H2($g$) -> NH3($g$)
}
$$

- When a metal cation changes its charge
  - Oxidized if its charge increases or reduced if its charge decreases.

$$
\ce{
CuCl($aq$) + FeCl3($aq$) -> FeCl2($aq$) + CuCl2($aq$)
}
$$

##### Decide Whether Each of the Following Reactions Is a Redox Reaction.

$\ce{2Al($s$) + 3Br2($l$) -> 2AlBr3($s$)}$

The left side of the equation has aluminum and bromine as neutral elemental species. The right side has an ionic compound composed of Al^3+^ and Br^-^ ions. This implies that electrons were transferred from aluminum to bromine. Therefore, this is a redox reaction.

$\ce{CaSO3($s$) + 2HCl($aq$) -> CaCl2($aq$) + SO2($g$) + H2O($l$)}$

The ionic species in this reaction do not change their charge. This is not a redox reaction. It is a gas evolution reaction.

$\ce{Fe2O3($s$) + C($s$) -> Fe($s$) + 3CO($g$)}$

Iron is converted from a Fe^3+^ ion to a neutral Fe atom. This is therefore a redox reaction.

$\ce{SO2($g$) + O2($g$) + H2O($l$) -> H2SO4($aq$)}$

Sulfur is associated with two oxygen atoms on the left and four oxygen atoms on the right. This is a tell-tale sign of oxidation. This is a redox reaction.


## Classifying Reactions

**One way is based on the process that happens.**

<img src="./assets/image-20240810160542210.png" alt="image-20240810160542210" style="zoom:50%;" />

**Another scheme classifies reactions by what the atoms do.**

<img src="./assets/image-20240810161113258.png" alt="image-20240810161113258" style="zoom:50%;" />

<img src="./assets/image-20240810160903750.png" alt="image-20240810160903750" style="zoom: 67%;" />

### Synthesis Reactions

- Also known as composition or combination reactions.
  - Two (or more) reactants combine together to make one product.
  - Simpler substances combining together. 

$$
\ce{
2CO + O2 -> 2CO2
}
$$
$$
\ce{
2Mg + O2 -> 2MgO
}
$$
$$
\ce{
HgI2 + 2KI -> K2HgI4
}
$$

### Decomposition Reactions

- A large molecule is broken apart into smaller molecules or its elements.
  - Caused by addition of energy into the molecule.
- One reactant breaks into two or more products.

$$
\ce{
2FeCl3($s$) ->[$elec$] 2FeCl2($l$) + Cl2($g$)
}
$$
$$
\ce{
2HgO($s$) ->[\Delta] 2Hg($l$) + O2($g$)
}
$$
$$
\ce{
2O3 ->[$h\nu$] 3O2($g$)
}
$$

### Single Displacement Reactions

- Reactions that involve one atom displacing another and replacing it in a compound.

#### Examples

$$
\ce{
Zn($s$) + 2HCl($aq$) -> ZnCl2($aq$) + H2($g$)
}
$$

the atom Zn displaces H from the compound.

$$
\ce{
Fe2O3($s$) + Al($s$) -> Fe($s$) + Al2O3($s$)
}
$$

the Al atom displaces the Fe atoms

$$
\ce{
2 Na($s$) + 2H2O($aq$) -> 2NaOH($aq$) + H2($g$)
}
$$

Na atoms displaces the H atoms

$$
\ce{
Zn($s$) + CuCl2($aq$) -> Cu($s$) + ZnCl2($aq$)
}
$$

<img src="./assets/image-20240810162526404.png" alt="image-20240810162526404" style="zoom: 25%;" />

### Double Displacement Reactions

- Two ionic compounds exchange ions.
- May be followed by decomposition of one of the products to make a gas.
- Precipitation, acid–base, and gas evolving reactions are also double displacement reactions.

### Examples of Double Displacement

$$
\ce{
CaCl2($aq$) + Na2CO3($aq$) -> CaCO3($s$) + 2NaCl($aq$)
}
$$
$$
\ce{
Ba(OH)2($s$) + 2HNO3($aq$) -> Ba(NO3)2($aq$) + 2H2O($l$)
}
$$
$$
\ce{
Li2CO3($aq$) + 2HCl($aq$) -> 2LiCl($aq$) + CO2($g$) + H2O($l$)
}
$$

##### Classify the Following Reactions as Synthesis, Decomposition, Single Displacement, or Double Displacement.

$\ce{3Mg($s$) + 2FeCl3($aq$) -> 3MgCl2($aq$) + 2Fe($s$)}$

Single Displacement

$\ce{CO2($g$) + H2O($l$) -> H2CO3($aq$)}$

Synthesis

$\ce{3KOH($aq$) + H3PO4($aq$) -> K3PO4($aq$) + 3H2O($l$)}$ 

Double Displacement

$\ce{CaCO3($s$) ->[\Delta] CaO($s$) + CO2($g$)}$

Decomposition

# Chapter 8

## Quantities in Chemical Reactions

### Global Warming
- Scientists have measured an average 0.6 °C rise in atmospheric temperature since 1860.
- During the same period atmospheric CO~2~ levels have risen 25%.

![image-20241130202325522](./assets/image-20241130202325522.png)

### The Source of Increased CO~2~?

- The primary source of the increased CO~2~ levels are combustion reactions of fossil fuels we use to get energy.
  -1860 corresponds to the beginning of the Industrial Revolution in the U.S. and Europe.

$$
\ce{CH4($g$) + 2O2($g$) -> CO2($g$) + 2H2O($g$)}
$$

<img src="./assets/image-20241130202537083.png" alt="image-20241130202537083" style="zoom: 33%;" />
$$
\ce{2C8H18($l$) + 25 O2($g$) -> 16 CO2($g$) + 18H2O($g$)}
$$
<img src="./assets/image-20241130202653490.png" alt="image-20241130202653490" style="zoom: 50%;" />

### Stoichiometry

- The amount of every substance used and made in a chemical reaction is related to the amounts of all the other substances in the reaction.
  - Law of Conservation of Mass.
  - Balancing equations by balancing atoms.
- The study of the numerical relationship between chemical quantities in a chemical reaction is called **stoichiometry**.

#### Making Pancakes

- The number of pancakes you can make depends on the amount of the ingredients you use.

![image-20241130203011501](./assets/image-20241130203011501.png)

$$
\ce{
1 cup flour + 2 eggs + 1 tsp baking powder -> 5 pancakes 
}
$$

- From these quantity relationships, we can write 12 **stoichiometric ratios**

$$
\ce{
\frac{1 cup flour}{2 eggs} \hspace{10mm} \frac{1 cup flour}{1 tsp baking powder} \hspace{10mm} \frac{1 cup flour}{5 pancakes}
\\\\
\frac{2 eggs}{1 cup flour} \hspace{10mm} \frac{2 eggs}{1 tsp baking powder} \hspace{10mm} \frac{2 eggs}{5 pancakes}
\\\\
\frac{1 tsp baking powder}{1 cup flour} \hspace{10mm} \frac{1 tsp baking powder}{2 eggs} \hspace{10mm} \frac{1 tsp baking powder}{5 pancakes}
\\\\
\frac{5 pancakes}{1 cup flour} \hspace{10mm} \frac{5 pancakes}{2 eggs} \hspace{10mm} \frac{5 pancakes}{1 tsp baking powder}
} 
$$


- If you want to make more or less than 5 pancakes, you can either multiply or divide by the **stoichiometric ratios** above to determine how many ingredients you will need.

$$
\ce{
10 pancakes \left(\frac{1 cup flour}{5 pancakes}\right) = 2 cup flours
\\\\
10 pancakes \left(\frac{2 eggs}{5 pancakes}\right) = 4 eggs
\\\\
10 pancakes \left(\frac{1 tsp baking powder}{5 pancakes}\right) = 2 tsp baking powder
}
$$

- You can also determine how many pancakes you can make based on how much of a particular ingredient you have.

$$
\ce{
5 cups flour \left(\frac{5 pancakes}{1 cup flour}\right) = 25 pancakes
\\\\
3.5 tsp baking powder \left(\frac{5 pancakes}{1 tsp baking powder}\right) = 17.5 pancakes
\\\\
5 eggs \left(\frac{5 pancakes}{2 eggs}\right) = 12.5 pancakes
}
$$

#### Mole-to-Mole Conversions

- The balanced equation is the “recipe” for a chemical reaction.
  - The equation $\ce{3 H2($g$) + N2($g$)  -> 2 NH3($g$)}$ tells us that 3 molecules of H~2~ react with exactly 1 molecule of N~2~ and make exactly 2 molecules of NH~3~.
  - We can write 6 total **stoichiometric ratios**.

$$
\ce{
\frac{3 mole H2}{1 mole N2} \hspace{10mm} \frac{3 mole H2}{2 mole NH3}
\\\\
\frac{1 mole N2}{3 mole H2} \hspace{10mm} \frac{1 mole N2}{2 mole NH3}
\\\\
\frac{2 mole NH3}{3 mole H2} \hspace{10mm} \frac{2 mole NH3}{1 mole N2}
}
$$
- We can use these stoichiometric ratios to determine how many reactants we will need to produce a certain amount of product.

$$
\ce{
5.7 mol NH3 \left(\frac{3 mole H2}{2 mole NH3}\right) = 8.6 mole H2
\\\\
5.7 mole NH3 \left(\frac{1 mole N2}{2 mole NH3}\right) = 2.9 mole N2
}
$$

- We can also use the ratios to determine the amount of product that can be made from a certain quantity of reactant (assuming all other reactants are in excess).

$$
\ce{
4.1 mole N2 \left(\frac{2 mole NH3}{1 mole N2}\right) = 8 mole NH3
\\\\
6.8 mole H2 \left(\frac{2 mole NH3}{3 mole H2}\right) = 4.5 mole NH3
}
$$



**How Many Moles of NaCl Result from the Complete Reaction of 3.4 Mol of Cl~2~?**
$$
\ce{2 Na($s$) + Cl2($g$) -> 2 NaCl} 
$$

$$
\ce{
3.4 mole Cl2 \left(\frac{2 mole NaCl}{1 mole Cl2}\right) = 6.8 mole NaCl
}
$$



**According to the following equation, how many moles of water are made in the combustion of 0.10 moles of glucose?**
$$
\ce{C6H12O6 + 6 O2 -> 6 CO2 + 6 H2O}
$$

$$
\ce{
0.10 moles C6H12O6 \left(\frac{6 moles H2O}{1 mole C6H12O6}\right) = 0.60 moles H2O
}
$$


#### Mass-to-Mass Conversions

- We know there is a relationship between the mass and number of moles of a chemical.

$$
\ce{
Formula Mass = \frac{Mass in grams}{1 mole of element or compound}
}
$$

- The molar mass of the chemicals in the reaction and the balanced chemical equation allow us to convert from the amount of any chemical in the reaction to the amount of any other.


**How Many Grams of Glucose Can Be Synthesized from 58.5 g of CO~2~ in Photosynthesis?** 

$$
\ce{6 CO2($g$) + 6 H2O($g$) -> C6H12O6($s$) + 6 O2($g$)} 
$$

First we need to calculate the formula mass of CO~2~ and glucose.

$$
\ce{
M_{CO_2} = 1 C (12.01 \pu{g//mol}) + 2 O (16.00 \pu{g//mol}) = 44.01 \pu{g//mol}
\\\\
M_{C_6H_{12}O_6} = 6 C (12.01 \pu{g//mol}) + 12 H (1.01 \pu{g//mol}) + 6 O (16.00 \pu{g//mol}) = 180.18 \pu{g//mol} 
}
$$

Now we can convert the mass of CO~2~ to moles
$$
\ce{
58.5 g CO2 \left(\frac{1 mole CO2}{44.01 g}\right) = 1.33 mole CO2
}
$$
Now we use the proper stoichiometric ratio to determine the amount of glucose the can be produced from this CO~2~.
$$
\ce{
1.33 mole CO2 \left(\frac{1 mole C6H12O6}{6 mole CO2}\right) =  0.222 mole C6H12O6
}
$$
Finally, we can determine the mass of 0.222 moles of glucose.
$$
\ce{
0.222 moles C6H12O6 \left(\frac{180.18 g}{1 mole C6H12O6}\right) = 40.0 g C6H12O6
}
$$



**How Many Grams of O~2~ Can Be Made from the Decomposition of 100.0 g of PbO~2~?**
$$
\ce{2 PbO2($s$) -> 2 PbO($s$) + O2($g$)}
$$

First we need to calculate the formula mass of O~2~ and PbO~2~.

$$
\ce{
M_{O_2} = 2 O (16.00 \pu{g//mol}) = 32.00 \pu{g//mol}
\\\\
M_{PbO_2} = 1 Pb (207.20 \pu{g//mol}) + 2 O (16.00 \pu{g//mol}) = 239.20 \pu{g//mol}
}
$$

Now we can calculate the mass of O~2~ produced. This time we will combine the steps together.
$$
\ce{
100.0 g PbO2 \left(\frac{1 mole PbO2}{239.20 g PbO2}\right) \left(\frac{2 mole O2}{1 mole PbO2}\right) \left(\frac{32.00 g O2}{1 mole O2}\right) = 26.76 g O2
}
$$


### Limiting Reagents

- Remember our recipe for pancakes?

$$
\ce{
1 cup flour + 2 eggs + 1 tsp baking powder -> 5 pancakes 
}
$$

- Imagine that you go to the pantry and find 3 cups of flour , 10 eggs, and 4 tsp of baking powder.
  - We can calculate how many pancakes we can make with each ingradient. Assuming that we have excess of the other ingredients.

$$
\ce{
3 cups flour \left(\frac{5 pancakes}{1 cup of flour}\right) = 15 pancakes
\\\\
10 eggs \left(\frac{5 pancakes}{2 eggs}\right) = 25 pancakes
\\\\
4 tsp baking powder \left(\frac{5 pancakes}{1 tsp baking powder}\right) = 20 pancakes
}
$$

- We see that the flour produces the least pancakes. Flour is our **limiting reagent**. 
  - You cannot produce more product than the limiting reagent will allow
  - The limiting reagent will be completely consumed
  - All other reagents will be only partially consumed.
- Based on these results, we can determine how much of each reagent will be consumed.

$$
\ce{
15 pancakes \left(\frac{1 cup flour}{5 pancakes}\right) = 3 cups flour
\\\\
15 pancakes \left(\frac{2 eggs}{5 pancakes}\right) = 6 eggs
\\\\
15 pancakes \left(\frac{1 tsp}{5 pancakes}\right) = 3 tsp baking powder
}
$$

- Finally, we can calculate how much of each nonlimiting reagent we have left.

$$
\ce{
10 eggs initially - 6 eggs consumed = 4 eggs leftover
\\\\
4 tsp baking powder initially - 3 tsp baking powder consumed = 1 tsp baking powder leftover
}
$$



**What Is the Limiting Reagent and Theoretical Yield When 0.552 Mol of Al React with 0.887 Mol of Cl~2~?** 

$$
\ce{2 Al($s$) + 3 Cl2($g$) -> 2 AlCl3($s$)}
$$

First, we must determine how many moles of AlCl~3~ can be produced from the completely reactionn of each reactant.

$$
\ce{
0.552 mole Al \left(\frac{2 mole AlCl3}{2 mole Al}\right) = 0.552 mole AlCl3
\\\\
0.887 mole Cl2 \left(\frac{2 mole AlCl3}{3 mole Cl2}\right) = 0.591 mole AlCl3
}
$$

We can see that Al produces less product. It is therefore the limiting reagent.



**How Many Moles of Si~3~N~4~ Can Be Made from 1.20 Moles of Si and 1.00 Moles of N~2~ in the Reaction** 

$$
\ce{3 Si + 2 N2 -> Si3N4}
$$

First, we will need to calculate how much Si~3~N~4~ can be produced from each ragent. Assuming the other reagents are present in excess.

$$
\ce{
1.20 moles Si \left(\frac{1 mole Si3N4}{3 mole Si}\right) = 0.400 moles Si3N4
\\\\
1.00 moles N2 \left(\frac{1 mole Si3N4}{2 mole N2}\right) = 0.500 moles Si3N4
}
$$

From here, we can see that silicon (Si) ins the limiting reagent. All of the silicon will be consumed and 0.400 moles of Si~3~N~4~ will be produced. We can also calulate the amount of N~2~ consumed to produce 0.400 moles of Si~3~N~4~.

$$
\ce{
0.400 moles Si3N4 \left(\frac{2 mole N2}{1 mole Si3N4}\right) = 0.800 moles N2
}
$$

Finally, we can calculate how much excess N~2~ is leftover.

$$
\ce{
1.00 moles N2 - 0.800 mole N2 = 0.200 mols N2 leftover
}
$$

### More Making Pancakes

Let’s now assume that as we are making a dozen pancakes, we spill some of the batter, burn a pancake, drop one on the floor, or other uncontrollable events happen so that we only make 11 pancakes. These things happen. And they happen in chemistry as well.

The actual amount of product made in a chemical reaction is called the **actual yield**. We can determine the efficiency of making pancakes by calculating the percentage of the maximum number of pancakes we actually make.  In chemical reactions, we call this the percent yield.

$$
\ce{
\% Yield = \frac{Actual Yield}{Theoretical Yield} \times 100 \% 
}
$$

In our pancake example, our %Yield would be

$$
\ce{
\% Yield = \frac{11 pancakes}{12 pancakes} \times 100 \% = 92 \%
}
$$

In chemistry, our **theoretical yield** will be the amount of product possible when all of the limiting reagent has been consumed. Because of both controllable and uncontrollable factors, the **actual yield** of product will always be less than the theoretical yield. The yield values can be either mass (g) or moles, but they must both have the same units.


**How Many Grams of N~2~(*g*) Can Be Made from 9.05 g of NH~3~ Reacting with 45.2 g of CuO? If 4.61 g of N~2~ Are Made, What Is the Percent Yield?**

$$
\ce{2 NH3($g$) + 3 CuO($s$) -> N2($g$) + 3 Cu($s$) + 3 H2O($l$)}
$$

First, we will need to calulate the formula mass of NH~3~ and CuO.

$$
M_{NH_3} = 1 N (14.01 \pu{g//mol}) + 3 H (1.01 \pu{g//mol}) = 17.04 \pu{g//mol}
\\\\
M_{CuO} = 1 Cu (63.55 \pu{g//mol}) + 1 O (16.00 \pu{g//mol}) = 79.55 \pu{g//mol}
$$

Next, we will need to find the number of moles of NH~3~ and CuO we have to start.

$$
\ce{
9.05 g NH3 \left(\frac{1 mole NH3}{17.04 g NH3}\right) = 0.531 mole NH3
\\\\
45.2 g CuO \left(\frac{1 mole CuO}{79.55 g CuO}\right) = 0.568 mole CuO
}
$$

Now, we can find the limiting reagent.

$$
\ce{
0.531 mole NH3 \left(\frac{1 mole N2}{2 mole NH3}\right) = 0.266 mole N2
\\\\
0.568 mole CuO \left(\frac{1 mole N2}{3 mole CuO}\right) = 0.189 mole N2
}
$$

From here, we can see CuO is the limiting reagent. The most N~2~ we can produce from this reaction is 0.189 moles, this is our theoretical yield. The actual yield is 4.61 g of N~2~. In order to calulate the %Yield, we need these two values to have the same units. We can convert either, but we will convert the 4.61 g to moles.

$$
\ce{
4.61 g N2 \left(\frac{1 mole N2}{28.02 g}\right) = 0.165 mole N2
}
$$

$$
\ce{
\% Yield = \frac{0.165 mole N2}{0.189 mole N2} \times 100 \% = 87.3 \%
}
$$


### Enthalpy Change

- We previously described processes as exothermic if they released heat, or endothermic if they absorbed heat.
- The enthalpy of reaction is the amount of thermal energy that flows through a process. 
  - At constant pressure.
  - It is abbreviated as $\Delta H_{rxn}$

#### Sign of Enthalpy Change

- For exothermic reactions, the sign of the enthalpy change is negative:
  - Thermal energy is produced by the reaction.
  - The surroundings get hotter.
  - $\Delta H_{rxm} < 0$

For the reaction $\ce{CH4($s$) + 2 O2($g$) -> CO2($g$) + 2 H2O($l$)}$, the $\Delta H_{rxn} = −802.3 \pu{kJ // mol}$ of CH~4~.

- For endothermic reactions, the sign of the enthalpy change is positive:
  - Thermal energy is absorbed by the reaction.
  - The surroundings get colder.
  - $\Delta H > 0$

For the reaction $\ce{N2($s$) +  O2($g$) -> 2 NO($g$)}$, the $\Delta H_{rxn} = +182.6 \pu{kJ // mol}$ of N~2~.

#### Enthalpy and Stoichiometry

- The amount of energy change in a reaction depends on the amount of reactants.
  - You get twice as much heat out when you burn twice as much CH~4~.
- Writing a reaction implies that the enthalpy change is per the stoichiometric amount given in the equation.

Consider the combustin of propane (C~3~H~4~)

$$
\ce{C3H8($l$) + 5 O2($g$) -> 3 CO2($g$) + 4 H2O($g$) \hspace{5mm} \Delta H_{rxn} = −2044 \pu{kJ}}
$$

This implies that each of these factors are true
$$
\ce{
\frac{-2044 \pu{kJ}}{1 mol C3H8 consumed} \hspace{10mm} \frac{-2044 \pu{kJ}}{5 mole O2 consumed} 
\\\\
\frac{-2044 \pu{kJ}}{3 mole CO2 produced} \hspace{10mm} \frac{-2044 \pu{kJ}}{4 mole H2O produced}
}
$$


**How Much Heat Is Associated with the Complete Combustion of 1.18 x 10^3^ g of C~3~H~8~(*g*)?**

First we calculate the formula mass of propane.
$$
\ce{
3 C (12.0 \pu{g // mol}) + 8 H (1.01 \pu{g // mol}) = 44.10 \pu{g //mol}
}
$$
Now, we can calculate the moles of propane.
$$
\ce{
1180 g C3H8 \left(\frac{1 mole C3H8}{44.10 g C3H8}\right) = 26.8 mole C3H8
}
$$
We can now determine how much energy is released
$$
\ce{
26.8 mole C3H8 \left(\frac{-2044 \pu{kJ}}{1 mole C3H8}\right) = 54800 \pu{kJ}
}
$$

# Chapter 9

## Electrons in Atoms and the Periodic Table

### Classical View of the Universe

- Since the time of the ancient Greeks, the stuff of the physical universe has been classified as either matter or energy.
- We define matter as the stuff of the universe that has mass and volume. 
- Energy is the stuff in the universe that doesn’t have mass and volume.

### Light and other Forms of Electromagnetic Radiation

- Light is a form of electromagnetic radiation.
- Electromagnetic radiation has properties consistent with both particles and waves.
- Electromagnetic radiation moves through space like waves move across the surface of a pond
- Every wave has four characteristics that determine its properties: 
  - Wave speed, 
  - Height (amplitude), 
  - Length (wavelength) 
  - Frequency
    - number of wave peaks that pass in a given time.

#### Wave Speed

- All electromagnetic waves move through space at the same, constant speed.
  - 3.00 x 10^8^ $\pu{m // s}$ in a vacuum
  - This speed is typically abbreviated using the variable *c*

#### Amplitude

- The amplitude is the height of the wave. 
- The vertical distance from node to crest. 
  - Or node to trough.
- The amplitude is a measure of how intense the light is—the larger the amplitude, the brighter the light.

#### Wavelength

- The wavelength ($\lambda$) is a measure of the distance covered by the wave.
  - The distance from one crest to the next. 
  - Or the distance from one trough to the next, or the distance between alternate nodes.
- Usually measured in nanometers.
  - 1 nm = 1 x 10^-9^ m

#### Frequency

The frequency ($\nu$) is the number of waves that pass a point in a given period of time.
  - The number of waves = number of cycles.
  - Units are hertz (Hz), or cycles/s = $\pu{1 // s}$.
  - 1 Hz = 1 $\pu{1 // s}$
- The total energy is proportional to the amplitude and frequency of the waves.

$$
E = h\nu
$$

where h is Planck's Constant, $6.62607015 \times 10^{−34} \pu{J // s}$

#### Relationship between Speed, Wavelength and Frequency

- The speed (*c*), wavelength ($\lambda$), and frequency ($\nu$) of an electromagnetic wave is related by the equation

$$
c = \lambda \nu
$$

![](./assets/image-20241201172559052.png)



### Electromagnetic Spectrum

- White light passed through a prism is separated into all its colors. 
  - This is called a continuous spectrum.

<img src="./assets/image-20241201172724254.png" alt="image-20241201172724254" style="zoom: 25%;" />

- The color of the light is determined by its wavelength.
  - Or frequency.
- White light is a mixture of all the colors of visible light.
- When an object absorbs some of the wavelengths of white light while reflecting others, it appears colored.
  - The observed color is predominantly the colors reflected.

### Types of Electromagnetic Radiation

#### Classified by the Wavelength

- Radiowaves = $\lambda$ > 0.01 m. 
  - Low frequency and energy.
- Microwaves = 10^-4^ m < $\lambda$ < 10^-2^ m.
- Infrared (IR) = 8 x 10^-7^ m < $\lambda$ < 10^-5^ m.
- Visible = 4 x 10^-7^ m < $\lambda$ < 8 x 10^-7^ m.
- Ultraviolet (UV) = 10^-8^ m < $\lambda$ < 4 x 10^-7^ m.
- X-rays = 10^-10^ m < $\lambda$ < 10^-8^ m.
- Gamma rays = $\lambda$ < 10^-10^ m. 
  - High frequency and energy.

![](./assets/Screenshot%20from%202024-12-01%2017-32-56.png)

### Particles of Light
- Scientists in the early 20th century showed that electromagnetic radiation was composed of particles we call photons.
  - Max Planck and Albert Einstein.
- Photons are particles of light energy.
- Each wavelength of light has photons that have a different amount of energy.
  - Short wavelength light has photons with high energy.
  - High frequency light has photons with high energy.
  - Radiowave photons have the lowest energy.
  - Gamma ray photons have the highest energy.
- High-energy electromagnetic radiation can potentially damage biological molecules.
  - Ionizing radiation.

**Order the Following Types of Electromagnetic Radiation**
Microwaves, Gamma Rays, Green Light, Red Light, Ultraviolet Light

By wavelength (short to long).
	Gamma < UV < green < red < microwaves.
By frequency (low to high).
	Microwaves < red < green < UV < gamma.
By energy (least to most).
	Microwaves < red < green < UV < gamma.

### Light’s Relationship to Matter

- Atoms can acquire extra energy, but they must eventually release it.
- When atoms emit energy, it usually is released in the form of light.
  - However, atoms don’t emit all colors, only very specific wavelengths.
  - The spectrum of wavelengths can be used to identify the element.
    - Emission Spectrum

<img src="./assets/image-20241201180103496.png" alt="image-20241201180103496" style="zoom: 50%;" />

![image-20241201180144384](./assets/image-20241201180144384.png)

### The Bohr Model

- The nuclear model of the atom does not explain how the atom can gain or lose energy.
- Neils Bohr developed a model of the atom to explain how the structure of the atom changes when it undergoes energy transitions.
- Bohr’s hypothesized that the energy of the atom was quantized, and that the amount of energy in the atom was related to the electron’s position in the atom.
  - Quantized means that the atom could only have very specific amounts of energy.
- In the Bohr model, electrons travel in orbits around the nucleus.
  - More like shells than planet orbits.
  - The farther the electron is from the nucleus the more energy it has.
  - Each orbit has a specific amount of energy.
- The energy of each orbit is characterized by an integer—the larger the integer, the more energy an electron in that orbit has and the farther it is from the nucleus.
  - The integer, *n*, is called a **quantum number**.  

<img src="./assets/image-20241201180448451.png" alt="image-20241201180448451" style="zoom:50%;" />

- When the atom gains energy, the electron leaps from a lower energy orbit to one that is further from the nucleus.
  - During that “quantum leap” it doesn’t travel through the space between the orbits, it just disappears from the lower orbit and appears in the higher orbit.
  - When the electron leaps from a higher energy orbit to one that is closer to the nucleus, energy is emitted from the atom as a photon of light
    - A quantum of energy.

<img src="./assets/image-20241201180818325.png" alt="image-20241201180818325" style="zoom: 33%;" />

#### Ground and Excited States
- In the Bohr model of hydrogen, the lowest amount of energy hydrogen’s one electron can have corresponds to being in the n = 1 orbit. 
  - We call this its ground state.
- When the atom gains energy, the electron leaps to a higher energy orbit.  
  - We call this an excited state.
- The atom is less stable in an excited state and so it will release the extra energy to return to the ground state.
  - Either all at once or in several steps.
- Every hydrogen atom has identical orbits, so every hydrogen atom can undergo the same energy transitions.
- However, since the distances between the orbits in an atom are not all the same, no two leaps in an atom will have the same energy.
  - The closer the orbits are in energy, the lower the energy of the photon emitted.
  - Lower energy photon = longer wavelength.
- Therefore, we get an emission spectrum that has a lot of lines that are unique to hydrogen. 

<img src="./assets/image-20241201181047325.png" alt="image-20241201181047325" style="zoom:50%;" />


#### The Bohr Model Successes and Failures

- The mathematics of the Bohr model very accurately predicts the spectrum of hydrogen.
- However, its mathematics fails when applied to multi-electron atoms.
  - It cannot account for electron-electron interactions.
- A better theory was needed.
  - This realization lead to the *Quantum-Mechanical Model of the Atom*