# Chapter 1

## Science vs. Philosophy

Science was born out of philosophy. It was developed after it became obvious that philosophy alone could not fully explain the physical universe.

|                     Philosophers                      |                     Scientists                      |
| :---------------------------------------------------: | :-------------------------------------------------: |
|                    Observe Nature                     |                   Observe Nature                    |
|            Explain the Behavior of Nature             |           Explain the Behavior of Nature            |
| Communicate and Debate Ideas with other Philosophers. | Communicate and Debate Ideas with other Scientists. |
|      Truth is revealed through Logic and Debate       |      Truth is revealed through Experimentation      |

### Structure Determines Properties
- Everything is made of tiny particles called **atoms** and **molecules**.
- Properties of a substance are determined by the type, amount, and interactions between these pieces.

<img src="./assets/image-20240729111830354.png" alt="image-20240729111830354" style="zoom: 33%;" />

## The Scientific Method

- A process for trying to understand nature by observing it and analyzing the way it behaves. 
- **Observations** are made to identify phenomenon to study and collect *data*.
- **Hypotheses** are formed and tested through **experimentation**
- **Conclusions** are drawn by analyzing data obtained from experiments.
- These conclusions are used to *confirm* or *reject* the hypothesis

<img src="./assets/image-20240729114539148.png" alt="image-20240729114539148" style="zoom: 33%;" />

## Observation

- A way of acquiring information about nature.
- The information obtained from observation is  known as Data.
- Some observations are simple descriptions about the characteristics or behavior of nature.
  - This is called *qualitative* data 

“The soda pop is a liquid with a brown color and a sweet taste.  Bubbles are seen floating up through it.”

- Some observations compare a characteristic to a standard numerical scale.
  
   - This is called *quantitative* data

“A 240-mL serving of soda pop contains 27 g of sugar.”



## Hypothesis

- A tentative interpretation or explanation of your observations.
  

“The sweet taste of soda pop is due to the presence of sugar.”

- A good hypothesis is one that can be tested to be proven wrong.
  - One test should be able to invalidate your hypothesis.
  
## Experiments

- Tests of hypotheses, laws, or theories.
  - Can you think of a way to test whether the sweet taste of soda pop is due to the presence of sugar?
  
- Results either validate (confirm) or invalidate (deny) your ideas.
  - Invalidate = Discard or Modify
    - Many times experiments invalidate only parts of the hypothesis or theory, in which case the idea is modified.
  - Validate ≠ Proof your idea will always hold

## Laws

- Summary of observations that combines all past observations into one general statement.
  - Allows you to predict future observations.
  - Law of Conservation of Mass— “In a chemical reaction matter is neither created nor destroyed.”
-  What’s the Difference Between an Observation and a Law?
    - An observation tells you what happened in a single event.
    - A law summarizes all the observations, effectively telling you what you will observe in future events.

## Theories

- General explanation for the characteristics and behavior of nature.
  - Models of nature.
  - Ex. Dalton’s Atomic Theory, Theory of Gravity, Germ Theory
  - Can be used to predict future observations.
- What’s the Difference Between a Hypothesis and a Theory?
  - A hypothesis is an explanation of a single or small number of observations.
  - A theory is an explanation that extends beyond individual observations to an understanding of the underlying causes for the way nature is or behaves.

## What’s the Difference Between a Law and a Theory?
- Laws answer the question “What” will happen.
- Theories tell us "What" will happen but also “Why” it happens.
    - Theories allow to extend your predictions to a wider set of circumstances.

<img src="./assets/image-20240729140309276.png" alt="image-20240729140309276" style="zoom: 33%;" />


# Chapter 2

## What Is a Measurement?
- Quantitative observation.
- Comparison to an agreed upon standard.
- Every measurement has a number, a unit, and an indicated degree of uncertainty.

- The unit tells you to what standard you are comparing your object. 
- The number tells you:
  - What multiple of the standard the object measures.
  - The uncertainty in the measurement.

<img src="./assets/image-20241012172517403.png" style="zoom:50%;" />

## Scientific Notation

- We commonly measure objects that are many times larger or smaller than our standard of comparison.
- Writing large numbers of zeros is tricky and confusing.

<img src="./assets/image-20240729190505170.png" alt="image-20240729190505170" style="zoom: 33%;" />

<img src="./assets/image-20240729190532017.png" alt="image-20240729190532017" style="zoom: 33%;" />

- Each decimal place in our number system represents a different power of 10.
- Scientific notation writes the numbers so they are easily comparable by looking at the power of 10.

<img src="./assets/image-20240729190655695.png" alt="image-20240729190655695" style="zoom: 33%;" />

<img src="./assets/image-20240729190720954.png" alt="image-20240729190720954" style="zoom: 33%;" />

<img src="./assets/image-20240729191022204.png" alt="image-20240729191022204" style="zoom: 33%;" />


## Exponents

- When the exponent on 10 is positive, it means the number is that many powers of 10 larger. 
  - Sun’s diameter = 1.392 × 10^9^ m = 1.392 × 1000000000 m =  1,392,000,000 m.
  
- When the exponent on 10 is negative, it means the number is that many powers of 10 smaller.
  - Average atom’s diameter = 3 × 10^-10^ m = 3 × 0.0000000001 m = 0.0000000003 m.
  
- To compare numbers written in scientific notation:
  - First compare exponents on 10.
  
  - If exponents are equal, then compare decimal numbers

<img src="./assets/image-20240729191047238.png" alt="image-20240729191047238" style="zoom: 33%;" />

## Writing Numbers in Scientific Notation

1.	Locate the decimal point.
2.	Move the decimal point to obtain a number between 1 and 10.
3.	Multiply the new number by 10*^n^*. Where *n* is the number of places you moved the decimal point.
4.	If you moved the decimal point to the left, then *n* is positive; if you moved it to the right, then *n* is negative.
  - If the original number is 1 or larger, then *n* is positive .
  - If the original number is less than 1, then *n* is negative .

### Example

​	12345
1.  Locate the decimal point.
    12345.

2.  Move the decimal point to obtain a number between 1 and 10.
    1.2345

3.  Multiply the new number by 10*^n^* . Where *n* is the number of places you moved the decimal point.
    1.2345 x 10^4^

4.  If you moved the decimal point to the left, then n is positive; if you moved it to the right, then n is negative .
    1.2345 x 10^4^

### Example

1.  Locate the decimal point.
    0.00012340

2.  Move the decimal point to obtain a number between 1 and 10.
    1.2340

3.  Multiply the new number by 10*^n^* . Where *n* is the number of places you moved the decimal point.
    1.2340 x 10^4^

4.  If you moved the decimal point to the left, then *n* is postive; if you moved it to the right, then *n* is negative .
    1.2340 x 10^-4^


## Writing a Number in Standard Form

1.234 x 10^-6^
- Since the exponent is -6, make the number smaller by moving the decimal point to the left 6 places.
  - When you run out of digits to move around, add zeros.
  - Add a zero in front of the decimal point for decimal numbers.

<img src="./assets/image-20240729192104445.png" alt="image-20240729192104445" style="zoom:50%;" />

### Write the Following Numbers in Scientific Notation

**123.4** = $1.234 \times 10^2$				**8.0012** = $8.0012 \times 10^0$

**145000** = $1.45 \times 10^5$			      **0.00234** = $2.34 \times 10^{-3}$

**25.25** = $2.525 \times 10^1$			       **0.0123** = $1.23 \times 10^{-2}$

**1.45** = $1.45 \times 10^0$			           **0.000008706** = $8.706 \times 10^{-6}$

### Write the Following Numbers in Standard Form

**2.1 × 10^3^** = 2100					**4.02 × 10^0^** = 4.02

**9.66 × 10^-4^** = 0.000966		             **3.3 × 10^1^** = 33

**6.04 × 10^-2^** = 0.0604	                         **1.2 × 10^5^** = 120000

## Significant Figures

### Writing numbers to reflect precision.

### Exact Numbers vs. Measurements
- Sometimes you can determine an exact value for a quality of an object.
  - Often by counting.
    - Pennies in a pile.
  - Sometimes by definition
    - 1 ounce is exactly 1/16 pounds.
- Whenever you use an instrument to compare a quality of an object to a standard, there is uncertainty in the comparison.


### Reporting Measurements
- Measurements are written to indicate the uncertainty in the measurement.
- The system of writing measurements we use is called **significant figures**.
- When writing measurements, all the digits written are known with certainty except the last one, which is an estimate.

<img src="./assets/image-20240729193939360.png" alt="image-20240729193939360" style="zoom: 33%;" />

### Estimating the Last Digit

- For instruments marked with a scale, you get the last digit by estimating between the marks.

  - If possible.

- Mentally divide the space into 10 equal spaces, then estimate how many spaces over the indicator is.

<img src="./assets/image-20240729190044580.png" alt="image-20240729190044580" style="zoom: 15%;" />

<img src="./assets/image-20240729194130267.png" alt="image-20240729194130267" style="zoom: 50%;" />

  ### What is the temperature reading on the thermometer to the correct number of digits?

<img src="./assets/image-20240729194347473.png" alt="image-20240729194347473" style="zoom: 20%;" />

103.3 ^o^F

## Which Digits are Significant?

- The non-placeholding digits in a reported measurement are called significant figures.
  - Some zeros in a written number are only there to help you locate the decimal point. 
  
- Significant figures tell us the range of values to expect for repeated measurements.
  - The more significant figures there are in a measurement, the smaller the range of values.  Therefore, the measurement is more precise.

<img src="./assets/image-20240729194825658.png" alt="image-20240729194825658" style="zoom:50%;" />

## Counting Significant Figures
- All non-zero digits are significant.
  - 1.5 has 2 significant figures.
- Interior zeros are significant.
  - 1.05 has 3 significant figures.
- Trailing zeros after a decimal point are significant.
  - 1.050 has 4 significant figures.
- Leading zeros are **NOT** significant.
  - 0.001050 has 4 significant figures.
- Zeros at the end of a number without a written decimal point are ambiguous and should be avoided by using scientific notation.
  - If 150 has 2 significant figures, then 1.5 x 10^2^, but if 150 has 3 significant figures, then 1.50 x 10^2^.

**Scientific Numbers are only written with Significant Digits. This is how you avoid ambiguity**

### Significant Figures and Exact Numbers

- Exact numbers have an unlimited number of significant figures. 
- A number whose value is known with complete certainty is exact.
  - From counting individual objects.
  - From definitions.
    - 1 cm is exactly equal to 0.01 m.
  - From integer values in equations.
       - In the equation for the radius of a circle, the 2 is exact.

$$
\bar{r} = \frac{Diameter}{2}
$$


### How many significant figures are in each of the following numbers?

**0.0035** - 2 sig figs											**1.080** - 4 sig figs

<br/>

**2371** - 4 sig figs											**2.97 × 10^5^** - 3 sig figs

<br/>

**1 dozen = 12** - Unlimited sig figs (definition)	       			**100,000** - Ambiguous

<br/>

## Rounding

- When rounding to the correct number of significant figures, if the number after the place of the last significant figure is:
  - 0 to 4, round down.
    - Drop all digits after the last significant figure and leave the last significant figure alone.
    - Add insignificant zeros to keep the value, if necessary.
  - 5 to 9, round up.
    - Drop all digits after the last significat figure and increase the last significant figure by one.
    - Add insignificant zeros to keep the value, if necessary.
#### Example
- Rounding to 2 significant figures.
  - 2.34 rounds to 2.3
  - 2.37 rounds to 2.4
  - 2.349865 rounds to 2.3
  - 0.0234 rounds to 0.023 or 2.3 × 10^-2^
  - 0.0237 rounds to 0.024 or 2.4 × 10^-2^
  - 0.02349865 rounds to 0.023 or 2.3 × 10^-2^
  - 234 rounds to 230 or 2.3 × 10^2^ 
  - 237 rounds to 240 or 2.4 × 10^2^ 
  - 234.9865 rounds to 230 or 2.3 × 10^2^ 

## Multiplication and Division with Significant Figures

When multiplying or dividing measurements with significant figures, the result has the same number of significant figures as the measurement with the fewest number of significant figures.

<img src="./assets/image-20240729201437439.png" alt="image-20240729201437439" style="zoom:33%;" />

### Determine the Correct Number of  Significant Figures for Each Calculation. Round and Report the Result.

$\Large\frac{1.01 \times 0.12 \times 53.51}{96} = 0.067556375 = 0.068$



$\Large\frac{56.55 \times 0.920}{34.2585} = 1.5186304128 = 1.52$



## Addition and Subtraction with Significant Figures

When adding or subtracting measurements with significant figures, the result has the same number of decimal places as the measurement with the fewest number of decimal places.

<img src="./assets/image-20240729203516297.png" alt="image-20240729203516297" style="zoom: 33%;" />

### Determine the Correct Number of  Significant Figures for Each Calculation. Round and Report the Result.

$\large0.987 + 125.1 - 1.22 = 124.9$



$\large0.764 - 3.449 - 5.98 = -8.67$




## Both Multiplication/Division and Addition/Subtraction with Significant Figures

- When doing different kinds of operations with measurements with significant figures, evaluate the significant figures in the intermediate answer, then do the remaining steps.
- Follow the standard order of operations.
  - Please Excuse My Dear Aunt Sally.
    ![image-20240729203924340](./assets/image-20240729203924340.png)

<img src="./assets/image-20240729204020374.png" alt="image-20240729204020374" style="zoom: 50%;" />

### Perform the Following Calculations to the Correct Number of Significant Figures

$\large1.10 \times 0.5120 \times 4.0015 - 3.4555 = 2.2\underline{5}36448 - 3.4555= -1.2\underline{0}18552 = -1.20$



$\Large\frac{4.562 \times 3.99870}{452.6755 - 452.33} = \frac{18.2\underline{4}20694}{0.3\underline{4}55} = 5\underline{2}.7990431259 = 53$



$\large(14.84 \times 0.55) - 8.02 = 8.\underline{1}62 - 8.02 = 0.\underline{1}42 = 0.1$



## Units

- Units tell the standard quantity to which we are comparing the measured property.
  - Without an associated unit, a measurement is without meaning.
- Scientists use a set of standard units for comparing all our measurements.
  - So we can easily compare our results.
- Each of the units is defined as precisely as possible.
- Scientists generally report results in an agreed upon International System.
- The SI System
  - Système International

|  Quantity   |     Unit      | Symbol |
| :---------: | :-----------: | :----: |
|   Length    |     meter     |   m    |
|    Mass     |   kilogram    |   kg   |
|    Time     |    second     |   s    |
| Temperature |    kelvin     |   K    |
|   Volume    | liter (litre) |   L    |

## Length

- Measure of the two-dimensional distance an object covers.
- The SI unit for length is a meter, about 3½ inches longer than a yard.
  - Distance covered by a certain number of wavelengths of a special color of light

<img src="./assets/image-20240729205453100.png" alt="image-20240729205453100" style="zoom:33%;" />

## Mass

- Measure of the amount of matter present in an object.
- The SI unit is the kilogram (kg), about 2 lbs. 3 oz. It's important to note the base unit is **not** the gram.



## Time

- Measure of the duration of an event.
- The SI units is the second (s)
  - 1 s is defined as the period of time it takes for a specific number of radiation events of a specific transition from cesium-133.

## Temperature

- Measure of the average amount of kinetic energy.
  - The higher the temperature the greater the average kinetic energy
- Heat flows from the matter that has high thermal energy into matter that has low thermal energy.
  -  Until they reach the same temperature.
- Heat is exchanged through molecular collisions between the two materials.
  Related Units in the 

## SI System
- All units in the SI system are related to the standard unit by a power of 10.
- The power of 10 is indicated by a prefix.
- The prefixes are always the same, regardless of the standard unit.
- It is usually best to measure a property in a unit close to the size of the property.
  - It reduces the number of confusing zeros.
  Common Prefixes in the 

<img src="./assets/image-20241012174914842.png" alt="image-20241012174914842" style="zoom:50%;" />



<img src="./assets/image-20240729215550961.png" alt="image-20240729215550961" style="zoom: 33%;" />



##### Which of the Following Units Would Be Best Used for Measuring the Diameter of a Quarter? 

- kilometer
- meter
- centimeter
- micrometer
- megameters

## Volume

- Derived unit.
  - Any length unit cubed.
  
  <img src="./assets/image-20240729222236832.png" alt="image-20240729222236832" style="zoom: 25%;" />
- Measure of the amount of space occupied.
- SI unit = cubic meter (m^3^)
- Commonly measure liquid or gas volume in milliliters (mL).
  - 1 L is slightly larger than 1 quart.
  - 1 L =  1 dm^3^ = 1000 ml = 10^3^ mL 
  - 1 ml = 0.001 L = 10^-3^ L
  - 1 mL = 1 cm^3^      

##### Which Is Larger?
- 1 yard or 1 meter?
- 1 mile or 1 km?
- 1 cm or 1 inch?
- 1 kg or 1 lb?
- 1 mg or 1 μg?
- 1 qt or 1 L?
- 1 L or 1 gal?
- 1 gal or 1000 cm^3^?

### How to use Units

- Always write every number with its associated unit.
- Always include units in your calculations.
 - You can do the same kind of operations on units as you can with numbers.
    - cm × cm = cm^2^
    - cm + cm = cm
    - cm ÷ cm = 1
- You can use units as a guide to problem solving 
  - This is called dimensional analysis.

## Conversions

- Many problems in chemistry involve using relationships to convert one unit of measurement to another.
- Conversion factors are relationships between two units.
  - May be exact or measured.
  - Both parts of the conversion factor have the same number of significant figures.
- Conversion factors generated from equivalence statements.

$$
1 \text{ inch} = 2.54 \text{ cm}
$$

$$
\frac{2.54 \text{ cm}}{1 \text{ in}} \hspace{20mm} \frac{1 \text{ in}}{2.54 \text{ cm}}
$$

- Arrange conversion factors so the starting unit cancels.
  - The starting unit should in the denominator of the conversion factor.
$$
2 \color{red}\cancel{\color{black}\text{ hr}}\color{black} \left(\frac{30 \text{ mi}}{1 \color{red}\cancel{\color{black}\text{ hr}}} \right) = 60 \text{ miles}
$$
- May string conversion factors.
  - So we do not need to know every relationship, as long as we can find something else the starting and desired units are related to :

$$
5 \color{red}\cancel{\color{black}\text{ cups}}\color{black}\left( \frac{1 \color{blue}\cancel{\color{black}\text{ pint}}}{2 \color{red}\cancel{\color{black}\text{ cups}}} \right) \left( \frac{1 \text{ quart}}{2 \color{blue}\cancel{\color{black}\text{ pints}}} \right) = 1.25 \text{ quarts}
$$

##### Convert 7.8 km to miles

$$
\ce{
7.8 km \left(\frac{1 mile}{1.609 km}\right) = 4.8 miles
}
$$



##### Convert 30.0 g to Ounces

$$
\ce{
30.0 g \left(\frac{16 oz}{453.6 g}\right) = 1.06 oz
}
$$



##### An Italian recipe for making creamy pasta sauce calls for 0.75 L of cream.  Your measuring cup measures only in cups.  How many cups should you use?

$$
\ce{
0.75 L \left(\frac{1.057 qt}{1 L}\right)\left(\frac{2 pints}{1 qt}\right)\left(\frac{2 cups}{1 pint}\right) = 3.2 cups
}
$$



##### Convert 30.0 mL to Quarts

$$
\ce{
30.0 mL \left(\frac{1 L}{1000 mL}\right)\left(\frac{1.057 qt}{1 L}\right) = 0.0317 qt
}
$$



##### Convert 2,659 cm^2^ to Square Meters

$$
\ce{
2659 cm^2 \left(\frac{1 m}{100 cm}\right)^2 = 2659 cm^2 \left(\frac{1 m^2}{10000 cm^2}\right) = 0.2659 m^2
}
$$



## Mass and Volume
- Two main characteristics of matter.
- Cannot be used to identify what type of matter something is.
  - If you are given a large glass containing 100 g of a clear, colorless liquid and a small glass containing 25 g of a clear, colorless liquid, are both liquids the same stuff?
- Even though mass and volume are individual properties, for a given type of matter they are related to each other!

## Density
- Ratio of mass to volume.

$$
D=\frac{m}{V}
$$

- Its value depends on the kind of material, not the amount.
  - Solids = g/cm^3^ (g/ml)
  - Liquids = g/mL
  - Gases = g/L
- Volume of a solid can be determined by water displacement—Archimedes Principle.
- Density :  solids > liquids > gases
  - Water is an exception
- When volumes are equal, the more dense substance will be heavier .
- When the mass of two samples is equal, the more dense substance will have smaller volume.
- Heating causes objects causes objects to expand. Lowering their density.
    - Volume will increase
    - Mass will remain the same
- In a heterogeneous mixture, the more dense object sinks.

<img src="./assets/image-20241012175046555.png" alt="image-20241012175046555" style="zoom:67%;" />

##### Solve the density equation for mass and volume.

$$
V = \frac{m}{D}
$$

$$
m = VD
$$

#####  A woman decides to perform a test to determine if her ring is in fact made of platinum. She places the ring on a balance and finds it has a mass of 5.84 grams.  She then finds that the ring displaces 0.556 cm^3^ of water.  Is the ring made of platinum? (Density Pt = 21.4 g/cm^3^)

$$
\ce{
\frac{5.84 g}{0.556 cm^3} = 10.5 \hspace{1mm}\frac{g}{cm^3}
}
$$

The ring cannot be platinum.

##### What Is the Density of Metal if a 100.0 g Sample Added to a Cylinder of Water Causes the Water Level to Rise from 25.0 mL to 37.8 mL?

$$
\ce{
D = \frac{m}{V} = \frac{100.0 g}{37.8 ml} = 2.65 \frac{g}{ml}
}
$$



##### How much does 4.0 cm^3^ of lead (11.3 g/cm^3^) weigh?

$$
\ce{
$m$ = $VD$ = 4.0 cm^3 \left(\frac{11.3 g}{1 cm^3}\right) = 45 g
}
$$



##### The gasoline in an automobile gas tank has a mass of 60.0 kg and a density of 0.752 g/cm^3^.  What is the volume?

$$
\ce{
$V = \frac{m}{D}$ = 60.0 kg \left(\frac{1000 g}{1 kg}\right)\left(\frac{1 cm^3}{0.752 g}\right) = 7.98 \times 10^4 cm^3
}
$$

$$
\ce{
7.98 \times 10^4 cm^3 \left(\frac{1 L}{1000 cm^3}\right)\left(\frac{1 gal}{3.785 L}\right) = 21.1 gal
}
$$

##### A 55.9 kg person displaces 57.2 L of water when submerged in a water tank.  What is the density of the person in g/cm^3^?

$$
\ce{
$D=\frac{m}{V}$ = \frac{55.9 kg}{57.2 L} = 0.977 \frac{kg}{L}
}
$$

$$
\ce{
\frac{0.977 kg}{1 L}\left(\frac{1000 g}{1 kg}\right)\left(\frac{1 L}{1000 ml}\right) = 0.977 \frac{g}{ml}
}
$$



# Chapter 3
## What is Matter?
- Matter is defined as anything that occupies space and has mass

- Even though it appears to be smooth and continuous, matter is actually composed of a lot of tiny little pieces we call **atoms** and **molecules**

- Atoms are the tiny particles that make up all matter.

- In most substances, the atoms are joined together in units called molecules


## Classifying Matter by Physical State

- Matter can be classified as solid, liquid or gas based on what properties it exhibits 

<img src="./assets/image-20241012175713724.png" alt="image-20241012175713724" style="zoom:50%;" />

- These properties are the result of the arrangement of the atoms and molecules comprising a sample of matter. 

<img src="./assets/image-20241012175328594.png" alt="image-20241012175328594" style="zoom: 33%;" />

## Solid

- The particles in a solid are packed close together and are fixed in position
  - though they may vibrate
  
- The close packing of the particles results in solids being incompressible

- The inability of the particles to move around results in solids retaining their shape and volume when placed in a new container; and prevents the particles from flowing

  <img src="./assets/image-20240730152701577.png" alt="image-20240730152701577" style="zoom:50%;" />

- Some solids have their particles arranged in an orderly geometric pattern – we call these **crystalline solids**.

  - Salt and Diamonds are examples

- Other solids have particles that do not show a regular geometric pattern over a long range. They are called **amorphous solids**

  - Plastic and Glass are examples

  <img src="./assets/image-20240802170717791.png" alt="image-20240802170717791" style="zoom:40%;" />

## Liquids

- The particles in a liquid are closely packed, but they have some ability to move around 

- the close packing results in liquids being incompressible

- The ability of the particles to move allows liquids to take the shape of their container and to flow. However they don’t have enough freedom to escape and expand to fill the container.

## Gases

- In the gas state, the particles have complete freedom from each other

- The particles are constantly flying around, bumping into each other and the container

- In the gas state, there is a lot of empty space between the particles
  - on average 
- Because there is a lot of empty space, the particles can be squeezed closer together – therefore gases are compressible

<img src="./assets/image-20240730153409308.png" alt="image-20240730153409308" style="zoom:50%;" />

- Because the particles are not held in close contact and are moving freely, gases expand to fill and take the shape of their container, and will flow



## Pure Substances vs. Mixtures

- In a **Pure Substance** the entire sample is made of the same atoms or molecules.

  - All samples have the same properties

- In **Mixtures**  different samples may have components present in different percentages

  - Samples with varying composition will exhibit different properties.

  <img src="./assets/image-20241012175806375.png" alt="image-20241012175806375" style="zoom: 33%;" />

## Elements and Compounds

- Substances which can not be broken down into simpler substances by chemical reactions are called **elements**.

- Most substances are chemical combinations of elements.  These are called **compounds**.
  - Compounds can be broken down into elements
  - Properties of the compound not related to the properties of the elements that compose it

### Elements

- Smallest piece of an **element** is called an **atom**
  - There are subatomic particles, but these are no longer the element
- Every sample of an element is made up of lots of identical atoms
- 118 known, of which about 91 are found in nature
  - The others are man made. Usually inside a particle accelerator.
- There is a natural distribution of elements known as there **abundance**
  - The abundance and form of an element varies in different parts of the environment
  - Oxygen most abundant element (by mass) on earth and in the human body

### Compounds

- Smallest piece of a **compound** is called a **molecule**
  - Molecules are made of atoms
  - All molecules of a compound are identical
  - Each molecule has the same number and type of atoms
 - Composed of elements in fixed percentages
  - water is 89 mass% O & 11 mass% H
- Billions of known compounds
- Same elements can form more than one different compound
  - Water and hydrogen peroxide contain just hydrogen and oxygen
  - Carbohydrates all contain just C, H and O
  



## Mixtures  

- Mixtures come in two forms **homogeneous** and **heterogeneous**.

- Homogeneous Mixtures are uniform throughout 

  - Appears to be one thing
  - Every piece of a sample has identical properties 
    - Another sample with the same components may have different properties
  - Homogeneous mixtures are sometimes called solutions

- Heterogeneous Mixtures are non-uniform 

- They contain different regions with different properties

  

  | Pure Substances                                              | Mixtures                                                     |
  | ------------------------------------------------------------ | ------------------------------------------------------------ |
  | All samples have the same physical and chemical properties   | Different samples may show different properties              |
  | Constant composition; all samples have the same components in the same percentages. | Variable composition; samples made with the same pure substances may have different percentages |
  | Homogeneous                                                  | Homogeneous or Heterogeneous                                 |
  | Separate components of a **compound** based on chemical properties | Separate into components based on physical properties        |
  | Temperature usually stays constant while melting or boiling  | Temperature changes while melting or boiling because composition changes |

  

## Properties of Matter

- **Physical Properties** are the characteristics of matter that can be changed without changing its composition
- **Chemical Properties** are the characteristics that determine how the composition of matter changes as a result of contact with other matter or the influence of energy 

### Some Physical Properties
- mass
- volume
- density
- phase
- magnetic susceptability
- specific heat
- melting point
- boiling point
- volatility
- taste
- solubility
- electrical condictivity
- thermal conductivity
- malleability
- ductility

### Some Chemical Properties

- acidity
- basicity
- corrosiveness
- reactivity
- explosiveness
- flammability
- combustibility
- reduction potential

### Physical Changes

- Physical Changes are changes in the properties of matter that do not effect its composition

  - Heating water raises its temperature. But it is still water. 

  - Evaporating butane from a lighter

  - Dissolving sugar in water 

### Chemical Changes

- Chemical Changes involve a change in a sample’s composition. A Chemical Reaction.

  - Rusting is iron combining with oxygen to make iron(III) oxide

  - Burning butane from a lighter changes it into carbon dioxide and water

  - Silver combines with sulfur in the air to make tarnish

<img src="./assets/image-20240802162212381.png" alt="image-20240802162212381" style="zoom: 50%;" />



### Phase Changes are Physical Changes

- Boiling = liquid to gas
- Melting = solid to liquid
- Subliming = solid to gas
- Condensing = gas to liquid
- Freezing = liquid to solid
- Deposition = gas to solid
- State changes require heating or cooling the substance
  - Evaporation is not a simple phase change, it is a solution process

<img src="./assets/image-20240730192910216.png" alt="image-20240730192910216" style="zoom:80%;" />

### Separation of Mixtures

- Mixtures are separated based on different physical properties of the components

  | Physical Property | Separation Technique |
  | ----------------- | -------------------- |
  | Boiling Point     | Distillation         |
  | Phase             | Filtration           |
  | Surface Adhesion  | Chromatography       |
  | Volatility        | Evaporation          |
  | Density           | Centrifugation       |




##### Distillation and Filtration

<img src="./assets/image-20240802161855169.png" alt="image-20240802161855169" style="zoom:50%;" />

## Law of Conservation of Mass

- This Law is attributed to Antoine Lavoisier

> Matter is neither created nor destroyed in a chemical reaction

- The total amount of matter present before a chemical reaction is always the same as the total amount after
- The total mass of all the reactants is equal to the total mass of all the products
- Total amount of matter remains constant in a chemical reaction

##### 58 grams of butane burns in 208 grams of oxygen to form 176 grams of carbon dioxide and 90 grams of water
$$
\ce{
butane + oxygen -> carbon dioxide + water
\\
58 g + 208 g -> 176 g + 90 g
\\
266 g -> 266 g
}
$$


## Energy

- We have observed something that has neither mass or volume, Energy.

- Energy is anything that has the capacity to do work

- Even though Chemistry is the study of matter, matter is effected by energy
  - it can cause physical and/or chemical changes in matter



### Law of Conservation of Energy

>  Energy can neither be created nor destroyed 

- The total amount of energy in the universe is constant – there is no process that can increase or decrease that amount
- However we can transfer energy from one place in the universe to another, and we can change its form
	- When a piece of matter possesses energy, it can give some it to another object
- All chemical and physical changes result in matter releasing or absorbing energy



### Kinds of Energy

- **Kinetic Energy** is energy of motion, or energy that is being transferred from one object to another

- **Potential Energy** is energy that is stored

- **Electrical Energy** is kinetic energy associated with the flow of electrical charge

- **Thermal Energy** is kinetic energy associated with molecular motion

- **Light** or **Radiant Energy** is kinetic energy associated with energy of subatomic particles called photons

- **Nuclear Energy** is potential energy in the nucleus of atoms 

- **Chemical Energy** is potential energy in the attachment of atoms or because of their position
- We use energy to accomplish all kinds of processes, but according to the Law of Conservation of Energy we don’t really use it up!
  - When we use energy we are changing it from one form to another
  - For example, converting the chemical energy in gasoline into mechanical energy to make your car move 
- In practice no process is 100% efficient. Some energy will be loss usually in the form of heat. 



### Units of Energy

- **calorie** (cal) is the amount of energy needed to raise one gram of water by 1°C
- 1 *food calorie* or **Calorie** (cal)[Note the capital "C"} is 1,000 *calories* (cal) [Lower case "c"]l
  - 1 Cal = 1000 cal = 1 kcal
- Joule (J) is equal to the amount of work done when a force of 1 newton displaces a mass through a distance of 1 meter in the direction of the force applied.
  - It is the standard SI unit for energy
- Kilowatt-hour (kWh) is the energy delivered by 1000 Watts of power over one hour.
  - Typically used when dealing with large amounts of energy

<img src="./assets/image-20240802162347839.png" alt="image-20240802162347839" style="zoom: 67%;" />

##### A candy bar contains 225 Cal of nutritional energy.  How many joules does it contain?

$$
\ce{
225 Cal \left(\frac{1000 cal}{1 Cal}\right)\left(\frac{4.184 J}{1 cal}\right) = 9.41 \times 10^5 J
}
$$



### Exothermic vs. Endothermic

- A chemical change (reaction) can either release or absorb energy
- Chemical reactions where energy is released are called **exothermic**
- Chemical reactions where energy is absorbed are called **endothermic**
- Energy is usually transferred in the form of heat

<img src="./assets/image-20240802165044263.png" alt="image-20240802165044263" style="zoom: 67%;" />

##### Classify each process as exothermic or endothermic.

a. gasoline burning in a car (exothermic)
b. isopropyl alcohol evaporating from skin (endothermic)
c. water condensing as dew during the night (exothermic)

### Heat

- Heat is the exchange of thermal energy between samples of matter
- Heat flows from the matter that has high thermal energy to matter that has low thermal energy
  - Until they reach the same temperature
- Heat is exchanged through molecular collisions between two samples
  
## The Meaning of Temperature

- Temperature is a measure of the average kinetic energy of the molecules in a sample
- Not all molecules have in a sample the same amount of  kinetic energy
- A higher temperature means a larger *average* kinetic energy

### Fahrenheit

- The Fahrenheit Temperature Scale used as its two reference points the freezing point of concentrated saltwater (0 °F) and average body temperature (100 °F)
  - more accurate measure now set average body temperature at 98.6 °F
- Room temperature is about 75 °F 


### Celsius

- The Celsius Temperature Scale used as its two reference points the freezing point of distilled water (0 °C) and boiling point of distilled water (100 °C)
  - more reproducible standards
  - most commonly used in science
- Room temperature is about 25 °C 

### Fahrenheit vs. Celsius

- A Celsius degree is 1.8 times larger than a Fahrenheit degree
- 0 °C is 32 °F
- Because the scales are offset from one another, we have a more complicated formula for converting between them.

<img src="./assets/image-20240802154441310.png" alt="image-20240802154441310" style="zoom: 33%;" />

### The Kelvin Temperature Scale

- Both the Celsius and Fahrenheit scales have negative numbers
- The Kelvin scale is an absolute scale, meaning it does not allow for negative values. 
- 0 K is called **Absolute Zero**. The lowest possible temperature. 
  - All molecular motion would stop at 0 K
  - Absolute Zero is a theoretical value and has not yet been achieved in lab.

## Kelvin vs. Celsius
- The size of a “degree” on the Kelvin scale is the same as on the Celsius scale
  - that makes 1 K 1.8 times larger than 1°F
- The 0 standard on the Kelvin scale is a much lower temperature than on the Celsius scale

<img src="./assets/image-20240802155223971.png" alt="image-20240802155223971" style="zoom: 13%;" />



<img src="./assets/image-20240802165126717.png" alt="image-20240802165126717" style="zoom: 80%;" />




##### Convert 310 K to Fahrenheit

$$
\ce{
(310K - 273.15 K)\left(\frac{1^{\circ}C}{1 K}\right) = 36.9 ^{\circ}C
}
$$

$$
\ce{
\left( \frac{1.8^\circ F}{1 ^\circ C} \right) 36.9 ^\circ C + 32 ^\circ F = 98.4 ^\circ F
}
$$



## Energy and the Temperature of Matter

- The amount the temperature of an object increases depends on the amount of heat energy added (q).
  - If you double the added heat energy the temperature will increase twice as much.
- The amount the temperature of an object increases depends on its mass
  - If you double the mass it will take twice as much heat energy to raise the temperature the same amount.

### Heat Capacity

- Heat capacity is the amount of heat *an object* must absorb to raise its temperature 1°C
  - cal/°C or J/°C
  - Metals have low heat capacities
  - Thermal insulators high
  - Extensive quantity
- Specific heat = heat capacity of 1 gram of the substance
  - cal/g°C or J/g°C
  - Waters specific heat = 4.184 J/g°C for liquid 
    - 1.000 cal/g°C
- The larger a material’s specific heat is, the more energy it takes to raise its temperature.
  - Water’s high specific heat is the reason it is such a good cooling agent
- like density, specific heat is a property of the type of matter
  - It can be used to identify the type of matter
- it doesn’t matter how much material you have 
  - Intensive quantity

<img src="./assets/image-20241012191058248.png" alt="image-20241012191058248" style="zoom: 67%;" />

## Heat Gain or Loss by an Object

- The amount of heat energy gained or lost by an object depends on 3 factors
  - The mass of the substance (*m*)
  - The sunstances **Specific Heat Capacity** (*c*) 
  - The temperature changed, T~F~ - T~i~, or ΔT

$$
\Large
q = mc\Delta T
$$



##### Gallium is a solid metal at room temperature, but melts at 29.9°C.  If you hold gallium in your hand, it melts from body heat.  How much heat must 2.5 g of gallium absorb from your hand to raise its temperature from 25.0°C to 29.9°C?  The heat capacity of gallium is 0.372 J/g°C

$$
q=mc\Delta T= \ce{(2.5g)\left(0.372 \frac{J}{g \cdot ^\circ C}\right)(29.9 ^\circ C - 25.0 ^\circ C) = 4.6 J}
$$



##### A backpacker wants to carry enough fuel to heat 2.5 kg of water from 25.0 °C to 100.0 °C. If the fuel she carries produces 36 kJ of heat per gram when it burns, how much fuel should she carry? (For the sake of simplicity, assume that the transfer of heat is 100% efficient.)

The specific heat capacity of water is 4.84 Jg^-1^^o^C^-1^, first we need to convert the mass to have the same units as *c*
$$
\ce{
2.5 kg \left(\frac{1000 g}{1 kg}\right) = 2500 g
}
$$
We can now calculate the amount of heat required for the water
$$
\ce{
$q = mc\Delta T$ = (2500 g)\left(4.184 \frac{J}{g \cdot ^\circ C}\right)(100.0 ^\circ C - 25.0 ^\circ C) = 7.8 \times 10^5 J = 784.5 kJ
}
$$
Now we can calculate the mass of fuel required
$$
\ce{
784.5 kJ \left(\frac{1 g}{36 kJ}\right) = 22 g
}
$$


##### If 89 J of heat are added to a pure gold coin with a mass of 12 g, what is its temperature change?

$$
\Delta T = \frac{q}{mc} = \ce{\frac{89 J}{(12 g)(0.128 \frac{J}{g \cdot ^\circ C})}= 58 ^\circ C}
$$

Using the specific heat capacity of gold in the table above.

##### An iron nail with a mass of 12 g absorbs 15 J of heat. If the nail was initially at 28 °C, what is its final temperature?

$$
\Delta T = \frac{q}{mc} = \ce{\frac{15 J}{(12 g)(0.449 \frac{J}{g \cdot ^\circ C})} = 2.8 ^\circ C = T^F - 28 ^\circ C}
$$

$$
\ce{
T^F = 28 ^\circ C + 2.8 ^\circ C = 30.8 ^\circ C = 31 ^\circ C
}
$$



# Chapter 4

## Atoms and Elements

- Atoms are incredibly small, yet they compose everything.
- Atoms are the pieces of elements.
  - Each has its own, unique kind of atom.
  - They have different structures. Therefore they have different properties.
- Properties of the atoms determine the properties of the elements.

<img src="./assets/image-20240803132443218.png" alt="image-20240803132443218" style="zoom: 25%;" />

### The Divisibility of Matter

- Infinitely divisible
  - For any two points, there is always a point between. 
- Ultimate particle
  - Upon division, eventually a particle is reached which can no longer be divided. 

<img src="./assets/image-20240803143831716.png" alt="image-20240803143831716" style="zoom: 33%;" />

### Dalton’s Atomic Theory

1. Each Element is composed of tiny, indestructible particles called atoms.
2. All atoms of an element are identical.
  - They have the same mass, volume, and other physical and chemical properties.
3. Atoms combine in simple, whole-number ratios to form molecules of compounds.  
  - Because atoms are unbreakable, they must combine as whole atoms.
  - The nature of the atom determines the ratios in which it combines.  
  - Each molecule of a compound contains the exact same types and numbers of atoms.
    - Law of Constant Composition
    - Chemical formulas

- Using compositions of compounds and assumed formulas, Dalton was able to determine the relative masses of all the atoms.
  - Dalton based his scale on H = 1 amu. 
  - We now base it on C-12 = 12 amu exactly.
  - amu = atomic mass unit. 
- Absolute sizes of atoms:
     Mass of H atom= 1.67 x 10^-24^ g.
     Volume of H atom = 2.1 x 10^-25^ cm^3^.

## Charges

- There are two kinds of charges, called positive (+) and negative (-).
  - Opposite charges attract.
  - Like charges repel.
  - Neutral objects **either** have no charge **or** equal amounts of opposite charges.


<img src="./assets/image-20240803150812796.png" alt="image-20240803150812796" style="zoom: 25%;" />

### The Electron

- Work done by J. J. Thomson and others proved that the atom had pieces called **electrons**.

- Thomson found that electrons are much smaller than atoms and carry a negative charge.
  - The mass of the electron is 1/1836^th^ the mass of a hydrogen atom.
  - The charge on the electron is the fundamental unit of charge that we call –1 charge unit.

### Rutherford’s Experiment

**How can you prove something is empty? Put something through it.**

- Use large target atoms.
  - Use very thin sheets of target so they do not absorb the “bullet”. 
- Use very small particles as “bullet” with very high energy. 
  - But not so small that electrons will effect it.
- Rutherford used Gold Foil and alpha (α) particle radiation
  - Alpha particles have a mass of 4 amu & charge of +2 c.u.
  - Gold has a mass of 197 amu and is very malleable.

<img src="./assets/image-20240803155733295.png" alt="image-20240803155733295" style="zoom: 33%;" />

- Over 98% of the alpha particles went straight through.
- About 2% of the alpha particles went through, but were deflected by large angles.
- About 0.01% of the alpha particles bounced off the gold foil.

##### Rutherford’s Conclusions

- Because almost all the particles went straight through, atoms are mostly empty space.
- Because of the few particles that bounced back, atoms contain a dense particle that was small in volume, compared to the atom, but large in mass. 
- Because of the large deflections of some of the particles, he concluded that the dense particle was positively charged.
  - It would have to be to repel the positively charged alpha particles.

<img src="./assets/image-20240803161132758.png" alt="image-20240803161132758" style="zoom: 50%;" />

##### The Nuclear Model
1.	The atom contains a tiny dense center called the nucleus.
     - The amount of space taken by the nucleus is only about 1 trillionth the volume of the atom.
2.	The nucleus has essentially the entire mass of the atom.
- The electrons weigh so little they contribute practically no mass to the atom.
3.	The nucleus is positively charged. 
     - The amount of positive charge balances the negative charge of the electrons.
4.	The electrons are dispersed in the empty space of the atom surrounding the nucleus.
     - Like water droplets in a cloud. 

### The Proton

- Rutherford proposed that the nucleus had a particle that had the same amount of charge as an electron but opposite sign.
- He called these particles are called protons.
- Protons have a charge of +1 c.u. and a mass of 1 amu or 1.67262 × 10^-27^ kg.
- Since protons and electrons have the same amount of charge, for the atom to be neutral, there must be equal numbers of protons and electrons.

### The Neutron

**How could beryllium have 4 protons stuck together in the nucleus? Shouldn’t they repel each other?**

- If a beryllium atom has 4 protons, then it should weigh 4 amu, but it actually weighs 9.01 amu!  
  - Where is the extra mass coming from?
- To answer these questions, Rutherford proposed that there was another particle in the nucleus.
  - Since this particle could not carry a charge he called it the neutron.
  - Neutrons have a mass of 1 amu or 1.67262 × 10^-27^ kg.

### The Modern Atom

- We now know atoms are composed of three main pieces
  - protons
  - neutrons
  - electrons.
- The nucleus contains protons and neutrons.
- The radius of the atom is about 105 times larger than the radius of the nucleus.

<img src="./assets/image-20240803162524736.png" alt="image-20240803162524736" style="zoom:50%;" />



| Subatomic Particle | Mass (g)          | Mass (amu) | Charge (c.u.) | Location | Symbol     |
| ------------------ | ----------------- | ---------- | ------------- | -------- | ---------- |
| Proton             | 1.67262 × 10^-24^ | 1.0073     | 1+            | Nucleus  | p^+^, H^+^ |
| Electron           | 9.1 × 10^-28^     | 0.00055    | 1-            | Orbital  | e^-^       |
| Neutron            | 1.67493 × 10^-24^ | 1.0087     | 0             | Nucleus  | n, n^0^    |



##### An Atom Has 20 Protons.  Determine if Each of the Following Statements Is True or False?

A. If it is a neutral atom, it will have 20 electrons.
B. If it also has 20 neutrons, its mass will be approximately 40 amu.
C. If it has 18 electrons, it will have a net 2+ charge.

## The Periodic Table

### Mendeleev

<img src="./assets/image-20240803165400595.png" alt="image-20240803165400595" style="zoom:15%;" />

- Ordered elements by atomic mass.
- Saw a repeating pattern of properties. 
- Periodic law
  - When the elements are arranged in order of increasing relative mass, certain sets of properties recur periodically?
  - Used pattern to predict properties of undiscovered elements.
- Where atomic mass order did not fit other properties, he reordered by other properties.
  - Te & I

<img src="./assets/image-20240803165702109.png" alt="image-20240803165702109" style="zoom:55%;" />



<img src="./assets/image-20240803165731949.png" alt="image-20240803165731949" style="zoom:50%;" />

### Modern Periodic Table

- Each element has a unique number of protons in its nucleus.
  - All carbon atoms have 6 protons in their nuclei.
  - The number of protons in the nucleus of an atom is called the atomic number.
  - *Z* is the short-hand designation for the atomic number. 
- Because each element’s atoms have a unique number of protons, each element can be identified by its atomic number.
- The elements are arranged on the Periodic Table in order of their atomic numbers.
- Each element has a unique name and symbol.
  - The symbol is either one or two letters

- Elements with similar chemical and physical properties are in the same column.
  - Columns are called **Groups** or **Families**.
  - Designated by a number
- Rows are called **Periods**.
  - Each period shows the pattern of properties repeated in the next period.

<img src="./assets/image-20240803170930547.png" alt="image-20240803170930547" style="zoom: 50%;" />

##### What is the atomic number of boron, B?

5

##### What is the atomic mass of silicon, Si?

28.09 amu

##### How many protons does a chlorine atom have?

17

##### How many electrons does a neutral neon atom have? 

10

##### Will an atom with 6 protons, 6 neutrons, and 6 electrons be electrically neutral?

Yes, it has equal number of electrons and protons.

##### Will an atom with 27 protons, 32 neutrons, and 27 electrons be electrically neutral? 

Yes, it has equal number of electrons and protons.

##### Will an Na atom with 10 electrons be electrically neutral?

No, Na has 11 protons. So this atom would not have an equal number of protons and electrons.

### Periodicity

<img src="./assets/image-20240803172830897.png" alt="image-20240803172830897" style="zoom:50%;" />

##### Metals

- Solids at room temperature, except Hg.
- Reflective surface.
- Conduct heat.
- Conduct electricity.
- Malleable..
- Ductile.
- Lose electrons and form cations in reactions.
- About 75% of the elements are metals.
- Lower left on the table.

##### Nonmetals

- Found in all 3 states at standard temperature and pressure.
- Poor conductors of heat.
- Poor conductors of electricity.
- Solids are brittle.
- Gain electrons in reactions to become anions.
- Upper right on the table.
  - Except H.

##### Metalloids

- Show some properties of metals and some of nonmetals.
- Also known as semiconductors.



##### Classify Each Element as Metal, Nonmetal, or Metalloid.

- Xenon, Xe (nonmetal)
- Tungsten, W (metal)
- Bromine, Br (nonmetal)
- Arsenic, As (metalloid)
- Cerium, Ce (metal)

### Groups

<img src="./assets/image-20240803174438496.png" alt="image-20240803174438496" style="zoom: 67%;" />

<img src="./assets/image-20240803174725666.png" alt="image-20240803174725666" style="zoom: 67%;" />

## Charge and Ions

- In a chemical change, the number of protons in the nucleus of the atom doesn’t change.
  - Radioactive and nuclear changes are an exception
- Atoms in a compound are often electrically charged, these are called ions.
- Atoms acquire a charge by gaining or losing electrons.
  - Never protons!

$$
\large
\text{Ionic Charge} = \# \text{ protons} - \# \text{ electrons}
$$

$$
\large
q = n_{p^+} - n_{e^-}
$$

- Ions with a positive charge are called **cations**.
  - Metals
  - More protons than electrons.
  - Form by losing electrons.

- Ions with a negative charge are called **anions**.
  - Nonmetals
  - More electrons than protons.
  - Form by gaining electrons.

- Chemically, ions are much different than the neutral atoms.
- Anions are named by changing the ending of the name to –ide.

$$
\ce{
Fluorine \hspace{5mm} F + 1 e^- -> F- \hspace{5mm} Fluoride Ion
\\
Oxygen \hspace{5mm} O + 2e^- -> O^2- \hspace{5mm} Oxide Ion
}
$$

- Cations are named the same as the metal.

$$
\ce{
Sodium \hspace{5mm} Na -> Na+ + 1e^- \hspace{5mm} Sodium Ion
\\
Calcium \hspace{5mm} Ca -> Ca^{2+} + 2e^- \hspace{5mm} Calcium Ion
}
$$

- The charge on a ion can often be determined from the group number on the periodic table.

<img src="./assets/image-20240803182027336.png" alt="image-20240803182027336" style="zoom:50%;" />

##### Fill in the Table

|  Ion   | p^+^ | e^-^ |
| :----: | :--: | :--: |
| Cl^1-^ |  17  |  18  |
| K^1+^  |  19  |  17  |
| S^2-^  |  16  |  18  |
| Sr^2+^ |  38  |  36  |
| Ca^2+^ |  20  |  18  |



### Valence Electrons and Ion Charge

- The highest energy electrons in an atom are called the valence electrons.
- Metals form cations by losing their valence electrons to get the same number of electrons as the previous noble gas.
  - Main group metals.
  - Li^+^ has the same number of electrons as He
  - Al^3+^ has the same number of electrons as Ne
- Nonmetals form anions by gaining electrons to have the same number of electrons as the next noble gas.
  - Cl^-^ has the same number of electrons as Ar
  - Se^2-^ has the same number of electrons as Kr



## Isotopes

- Soddy discovered that the same element could have atoms with different masses, which he called isotopes.
  - There are two isotopes of chlorine found in nature, one that has a mass of about 35 amu and another that weighs about 37 amu.
- The **atomic mass** is a *weighted average* of the weights of all the naturally occurring atoms.
  - The atomic mass of chlorine is 35.45 amu.
- The **exact mass** is the mass of a specific isotope
- All isotopes of an element are chemically identical.
- All isotopes of an element have the same number of protons and a different number of neutrons.
  - Isotopes of an element have different masses.
- Isotopes are identified by their **mass numbers**.

$$
\text{Mass Number} = \# \text{ Protons} + \# \text{ Neutrons}
$$

  - Unlike the atomic mass or the exact mass, *mass number* is always a whole number
    Isotopes

<img src="./assets/image-20240803220604142.png" alt="image-20240803220604142" style="zoom: 80%;" />

<img src="./assets/image-20240803220714842.png" alt="image-20240803220714842" style="zoom: 67%;" />

<img src="./assets/image-20240803220754394.png" alt="image-20240803220754394" style="zoom: 80%;" />

<img src="./assets/image-20240803220827752.png" alt="image-20240803220827752" style="zoom: 80%;" />

- Each isotope has a **natural abundance** based on the relative amount of the isotope found in nature
  - Natural abundance is the probability of finding a particular isotope in a sample of an element

  - Cl-35 makes up about 75% of chlorine atoms in nature, and Cl-37 makes up the remaining 25%.

<img src="./assets/image-20241012221820219.png" alt="image-20241012221820219" style="zoom:50%;" />



##### What is the atomic mass of Neon?

| Isotope | Exact Mass | Natural Abundance (%) |
| :-----: | :--------: | :-------------------: |
| ^20^Ne  |   19.992   |         90.48         |
| ^21^Ne  |   20.994   |         0.27          |
| ^22^Ne  |   21.991   |         9.25          |

$$
\ce{
(19.992 amu)(0.9048) + (20.994 amu)(0.0027) + (21.991 amu)(0.0925) = 20.180 amu
}
$$



##### How Many Protons and Neutrons Are in an Atom of $\ce{^52_24Cr}$?

$\#p^+ = 24$

$\ce{Mass Number =} \#n^0 + \#p^+ = 52$

$\#n^0 = 52-24 = 28$

##### Gallium has two naturally occurring isotopes. Ga-69 with Mass 68.9256 Amu and Abundance of 60.11% and Ga-71 with Mass 70.9247 Amu and Abundance of 39.89%.  Calculate the Atomic Mass of Gallium.

<br/>

##### If Copper Is 69.17% Cu-63 with a Mass of 62.9396 Amu and the Rest Cu-65 with a Mass of 64.9278 Amu, Find Copper’s Atomic Mass.

<br/>


# Chapter 5

## Molecules and Compounds

- Compounds have chemical and physical properties distinct from their component elements.
  - Salt
    - Sodium—shiny, reactive, poisonous.
    - Chlorine—pale yellow gas, reactive, poisonous.
    - Sodium chloride—table salt.
  - Sugar
    - Carbon—pencil or diamonds.
    - Hydrogen—flammable gas.
    - Oxygen—a gas in air.

### Law of Constant Composition

- All samples of a pure substance contain the same elements in the same percentages (ratios).
  - The smallest piece of a compound is called a molecule.
  - Every molecule of a compound has the same number and type of atoms.
  - Since all the molecules of a compound are identical, every sample will have the same 
  ratio of the elements.
  - Since all molecules of a compound are identical, every sample of the compound will have the same properties.
- Mixtures have variable composition.

- If we decompose water by electrolysis, we get 16.0 grams of oxygen to every 2.00 grams of hydrogen. 

<img src="https://2012books.lardbucket.org/books/beginning-chemistry/section_18/9679947ab90398b8826bea46aa85c1c6.jpg" alt="https://2012books.lardbucket.org/books/beginning-chemistry/section_18/9679947ab90398b8826bea46aa85c1c6.jpg" style="zoom: 15%;" />

- Water has a constant mass ratio of oxygen to hydrogen of 8.0

$$
\text{Mass Ratio} = \frac{m_O}{m_H} = \frac{16.0 \text{ g}}{2.0 \text{ g}} = 8.0
$$

##### Show that Two Samples of Carbon Dioxide Are Consistent with the Law of Constant Composition. 

| Sample | Carbon (g) | Oxygen (g) |
| :----: | :--------: | :--------: |
|   1    |    1.8     |    4.8     |
|   2    |    6.4     |    17.1    |

$$
\ce{
\frac{Mass of Carbon}{Mass of Oxygen} = \frac{1.8 g}{4.8 g} = \frac{6.4 g}{ 17.1 g} =  0.375
}
$$

##### Show that Hematite Has Constant Composition if a 10.0 g Sample Has 7.2 g Fe and the Rest Is Oxygen; and a Second Sample Has 18.1 g Fe and 6.91 g O.

<br/>

### Polyatomics

**Certain groups of atoms are bonded together to form what is called a polyatomic ion that acts as a single unit**

<img src="./assets/image-20240804141730110.png" alt="image-20240804141730110" style="zoom:50%;" />


### Molecular Formulas Describe Compounds

- We describe the compound by describing the number and type of each atom in the simplest unit of the compound.
  - Molecules or ions.
- Each element is represented by its letter symbol.
- The number of atoms of each element is written to the right of the element as a subscript.
  - If there is only one atom, the 1 subscript is not written.

<img src="./assets/image-20240804141830611.png" alt="image-20240804141830611" style="zoom: 67%;" />

- **Polyatomic groups** are placed in parentheses. 
  - If more than one.

<img src="./assets/image-20240804142032701.png" alt="image-20240804142032701" style="zoom:67%;" />

- Order of Elements in a Formula
  - Metals are written first.
  - Nonmetals are written in order
- There are occasional exceptions for historical or informational reasons.
  - H~2~O, but NaOH . 

<img src="./assets/image-20240804141933657.png" alt="image-20240804141933657" style="zoom:67%;" />

##### Hematite is composed of three oxide ions for every two iron ions. What is the chemical formula for hematite?

$\ce{Fe2O3}$

##### Acetone molecules contain six hydrogen atoms, three carbon atoms, and one oxygen atom. What is it's chemical formula? 

$\ce{C3H6O}$

##### Determine the Total Number of Atoms or Ions in One Formula Unit of Each of the Following.

Mg(C~2~H~3~O~2~)~2~

1 Mg, 4 C, 6 H, 4 O

Hg~6~(PO~4~)~2~

6 Hg, 2 P, 8 O

(NH~4~)~3~PO~4~

3 N, 12 H, 1 P, 4 O

### Structural Formulas

- **Structural formulas** use lines to represent chemical bonds
- Unlike **molecular formulas**, structural formulas demonstrate how the atoms in a molecular are connected.

<img src="./assets/image-20240804143410969.png" alt="image-20240804143410969" style="zoom: 33%;" />

### Empirical Formulas

- An **empirical formula** is the simplest whole-number ratio of atoms of each
element in a compound.

| Molecular Formula | Empirical Formula |
| :---------------: | :---------------: |
|     C~6~H~6~      |        CH         |
|   C~2~O~4~H~2~    |      CO~2~H       |
|   Al(NO~3~)~3~    |   Al(NO~3~)~3~    |



## Classifying Materials

<img src="./assets/image-20240804144133125.png" alt="image-20240804144133125" style="zoom: 33%;" />

### Atomic Elements

- Atomic elements have single atoms as their basic units. 
  - Most elements fall into this category

### Molecular Elements

- Molecular elements do not normally exist in nature with single atoms as
  their basic units. 
  - Smallest unit is a molecule.
  - Two or more nonmetals.
  - These elements usually exist as diatomic molecules.

<img src="./assets/image-20240804144825453.png" alt="image-20240804144825453" style="zoom: 80%;" />

### Molecular Compounds

- **Molecular compounds** are composed of two or more nonmetals.
  - The basic units are molecules.
  - For instance, H~2~O, CO~2~, C~3~H~6~O

<img src="./assets/image-20240804181747198.png" alt="image-20240804181747198" style="zoom:33%;" />

### Ionic Compounds

- **Ionic compounds** are composed of one or more cations (+) paired with one or more
anions (-)
- Usually metals + nonmetals.
- The basic unit of ionic compounds is the **formula unit**.
- Smallest electrically neutral collection of ions


- 
-   No real individual units, instead have a 3-dimensional array of cations and anions.

<img src="./assets/image-20240804230611827.png" alt="image-20240804230611827" style="zoom:50%;" />

##### Classify Each of the Following as Either an Atomic Element, Molecular Element, Molecular Compound, or Ionic Compound. 

Aluminum, Al. (Atomic Element)

Aluminum chloride, AlCl~3~. (Ionic Compound)

Chlorine, Cl~2~. (Molecular Element)

Acetone, C~3~H~6~O. (Molecular Compound)

Carbon monoxide, CO. (Molecular Compound)

Cobalt, Co. (Atomic Element)

### Writing Ionic Formulas

**Ionic compounds are electrically neutral therefore there must be an equal number of positive and negative charges**
$$
\text{Total Positive Charge} + \text{Total Negative Charge} = 0
$$

We know sodium (Na) tends to form a cation with a 1+ charge 

$$
\ce{
Na -> Na+ + e-
}
$$

We also know that sulfur tends to form an anion with a 2- charge

$$
\ce{
S + 2e- -> S^{2-}
}
$$

To achieve an electrically neutral ionic compound, we will need two sodium ions for each sulfide ion.

$$
\ce{
2Na+ + S^{2-} -> Na2S 
}
$$

#### Rules

1. Write the symbol for the metal cation and its charge.
1. Write the symbol for the nonmetal anion and its charge.
1. Charge (without sign) becomes subscript for the other ion.
1. Reduce subscripts to smallest whole-number ratio.
1. Check that the sum of the charges of the cation cancels the sum of the anions.

<img src="./assets/image-20240805155606069.png" alt="image-20240805155606069" style="zoom:33%;" />

##### What Are the Formulas for Compounds Made from the Following Ions?

Potassium ion with a nitride ion

$\ce{3K+ + N^{3-} -> K_3N}$

Calcium ion with a bromide ion

$\ce{Ca^{2+} + 2Br^- -> CaBr2}$

Aluminum ion with a sulfide ion

$\ce{2Al^{3+} + 3S^{2-} -> Al2S3}$

Magnesium ion with sulfite ion

$\ce{Mg^{2+} + SO_3^{2-} -> MgSO_3}$

Ammonium ion with nitrate ion

$\ce{NH_4^+ + NO3^{1-} -> NH_4NO3}$

## Naming

### Common Names

**Some compounds have common names mostly due to historic significance**

- H~2~O = Water, steam, ice.
- NH~3~ = Ammonia.
- CH~4~ = Methane.
- NaCl = Table salt.
- C~12~H~22~O~11~ = Table sugar.

### Ionic compounds.
<img src="./assets/image-20240805163740167.png" alt="image-20240805163740167" style="zoom:50%;" />

<img src="./assets/image-20240805163939396.png" alt="image-20240805163939396" style="zoom:50%;" />

<img src="./assets/image-20240805164019795.png" alt="image-20240805164019795" style="zoom:50%;" />

<img src="./assets/image-20240805164316237.png" alt="image-20240805164316237" style="zoom: 55%;" />

#### Binary Ionic

##### Type 1

<img src="./assets/image-20240805164215350.png" alt="image-20240805164215350" style="zoom: 67%;" />

##### Type 2

<img src="./assets/image-20240805164425314.png" alt="image-20240805164425314" style="zoom:67%;" />

**When the anion is a polyatomic, the suffix is not changed**

##### Write the name for the following ionic compounds

- KCl - Potassium Chloride
- Na~2~O - Sodium Oxide
- CaBr~2~ - Calcium(II) Bromide
- CoF~2~  - Cobalt(II) Fluoride
- CuCl - Copper(I) Chloride
- Mg(NO~2~)~2~ - Magnesium Nitrite
- Li~2~SO~4~ - Lithium Sulfate
- (NH~4~)~3~PO~4~ - Ammonium Phosphate
- Al~2~(SO~3~)~3~ - Aluminum Sulfite

Write the formula for the following ionic compounds

- Copper(II) Bromide - CuBr~2~
- Iron(III) fluoride - FeF~3~
- Calcium Sulfate - CaSO~4~
- Lithium Phosphate - Li~3~PO~4~
- Sodium Oxide - Na~2~O

### Molecular compounds.


- 2 or more nonmetals

<img src="./assets/image-20240805165402994.png" alt="image-20240805165402994" style="zoom:67%;" />

<img src="./assets/image-20240805165428184.png" alt="image-20240805165428184" style="zoom:67%;" />


### Acids

- Formula starts with hydrogen (H).
  - H~2~SO~4~, HBr
- Sour taste
- Though acids are molecular, they behave as ionic when dissolved in water.

$$
\ce{
HA -> H+ + A-
}
$$

- May be binary or oxyacid.

<img src="./assets/image-20240805213718131.png" alt="image-20240805213718131" style="zoom:50%;" />

<img src="./assets/image-20240805213754630.png" alt="image-20240805213754630" style="zoom:50%;" />
$$
\ce{
HCl -> H+ + Cl-
}
$$

$$
\ce{
HNO3 -> H+ + NO3-
}
$$

#### Binary Acids

- Binary acids have H+1 cation and nonmetal anion

<img src="./assets/image-20240805213819156.png" alt="image-20240805213819156" style="zoom:67%;" />

##### Name the following binary acids

- HF - Hydrofluoric Acid
- HBr - Hydrobromic Acid
- HI - Hydroiodic Acid
- H~2~S - Hydrosulfic Acid

#### Oxyacids

- Oxyacids have H^+1^ cation and polyatomic anion.

<img src="./assets/image-20240805214222544.png" alt="image-20240805214222544" style="zoom: 67%;" />

- The names of acids containing oxyanions ending with -*ite*

<img src="./assets/image-20240805214322780.png" alt="image-20240805214322780" style="zoom: 67%;" />

- The names of acids containing oxyanions ending with -*ate*

<img src="./assets/image-20240805214454179.png" alt="image-20240805214454179" style="zoom:67%;" />



##### Name the following oxyacids

- H~2~SO~4~ - Sulfuric Acid
- HNO~3~ - Nitric Acid
- HNO~2~ - Nitrous Acid
- H~3~PO~4~ - Phosphoric Acid



##### Write the chemical equation for the following acid

- Sulfurous Acid - H~2~SO~3~
- Hydrochloric Acid - HCl
- Nitrous Acid - HNO~2~
- Chromic Acid - H~2~CrO~4~



## Formula Mass

- The mass of an individual molecule or formula unit.
  - Also known as molecular mass or molecular weight.
  - Sum of the masses of the atoms in a single molecule or formula unit.

$$
\text{H}_2\text{O}
$$

$$
2 \text{ H} \hspace{5mm} 2 (1.008 \text{ amu}) = 2.016 \text{ amu}
$$
$$
\text{O} \hspace{5mm} 15.99 \text{ amu}
$$

$$
2.016 \text{ amu} + 15.99 \text{ amu} = 18.01 \text{ amu}
$$

##### Calculate the Formula Mass for the following compounds

$\ce{Al2(SO4)3}$

$$
\ce{
2 Al (26.98 amu) + 3 S (32.07 amu) + 12 O (16.00 amu) = 342.2 amu
}
$$
$\ce{C6H8O2}$

$$
\ce{
6 C (12.01 amu) + 8 H (1.01 amu) + 2 O (16.00 amu) = 112.1 amu
}
$$




$\ce{Ba(NO3)2}$

